<?php
session_start();
require 'includes/db.php';

// Vérifie que l'utilisateur est admin (à adapter selon ton système)
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') exit('Accès refusé');

$groupes = [
    'A' => ['MAR' => 'Maroc', 'MAL' => 'Mali', 'ZAM' => 'Zambie', 'COM' => 'Comores'],
    'B' => ['EGY' => 'Égypte', 'RSA' => 'Afrique du Sud', 'ANG' => 'Angola', 'ZIM' => 'Zimbabwe'],
    'C' => ['NGA' => 'Nigeria', 'TUN' => 'Tunisie', 'UGA' => 'Ouganda', 'TAN' => 'Tanzanie'],
    'D' => ['SEN' => 'Sénégal', 'COD' => 'RD Congo', 'BEN' => 'Bénin', 'BOT' => 'Botswana'],
    'E' => ['ALG' => 'Algérie', 'BFA' => 'Burkina Faso', 'EQG' => 'Guinée Équatoriale', 'SUD' => 'Soudan'],
    'F' => ['CIV' => "Côte d'Ivoire", 'CMR' => 'Cameroun', 'GAB' => 'Gabon', 'MOZ' => 'Mozambique'],
];
$flags = [
    'MAR' => 'ma', 'MAL' => 'ml', 'ZAM' => 'zm', 'COM' => 'km',
    'EGY' => 'eg', 'RSA' => 'za', 'ANG' => 'ao', 'ZIM' => 'zw',
    'NGA' => 'ng', 'TUN' => 'tn', 'UGA' => 'ug', 'TAN' => 'tz',
    'SEN' => 'sn', 'COD' => 'cd', 'BEN' => 'bj', 'BOT' => 'bw',
    'ALG' => 'dz', 'BFA' => 'bf', 'EQG' => 'gq', 'SUD' => 'sd',
    'CIV' => 'ci', 'CMR' => 'cm', 'GAB' => 'ga', 'MOZ' => 'mz'
];

$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($groupes as $groupe => $equipes) {
        $classement = isset($_POST["classement_$groupe"]) ? explode(',', $_POST["classement_$groupe"]) : [];
        $classement_str = implode(',', $classement);
        $is_final = isset($_POST["final_$groupe"]) ? 1 : 0;
        $stmt = $mysqli->prepare("INSERT INTO groupe_results (groupe, classement, is_final) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE classement = VALUES(classement), is_final = VALUES(is_final), created_at = NOW()");
        $stmt->bind_param('ssi', $groupe, $classement_str, $is_final);
        $stmt->execute();
        $stmt->close();
        // Si le classement est final, calculer les points pour chaque utilisateur
        if ($is_final) {
            $stmt2 = $mysqli->prepare("SELECT user_id, classement FROM groupe_predictions WHERE groupe = ?");
            $stmt2->bind_param('s', $groupe);
            $stmt2->execute();
            $result2 = $stmt2->get_result();
            $resultat = $classement;
            while ($row = $result2->fetch_assoc()) {
                $pronostic = explode(',', $row['classement']);
                $points = 0;
                foreach ($resultat as $i => $code) {
                    if (isset($pronostic[$i]) && $pronostic[$i] === $code) $points++;
                }
                $stmt3 = $mysqli->prepare("INSERT INTO groupe_points (user_id, groupe, points) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE points = VALUES(points)");
                $stmt3->bind_param('isi', $row['user_id'], $groupe, $points);
                $stmt3->execute();
                $stmt3->close();
            }
            $stmt2->close();
        }
    }
    $message = "<div style='color:green'>Résultats enregistrés et points calculés !</div>";
}

$mysqli->query("CREATE TABLE IF NOT EXISTS groupe_points (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    groupe CHAR(1) NOT NULL,
    points INT DEFAULT 0,
    UNIQUE KEY (user_id, groupe)
)");

include 'templates/header.php';
?>

<link rel=\"stylesheet\" href=\"https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css\">
<style>
.list-group-item { background: #b22222; color: #fff; font-weight: 500; border: none; margin-bottom: 6px; cursor: grab; }
.list-group-item img { width: 28px; margin-right: 8px; border-radius: 3px; }
</style>

<div class="container py-4">
  <h2 class="mb-4">Saisie des classements réels des groupes</h2>
  <?= $message ?>
  <form method="post" id="adminGroupForm">
    <div class="row">
    <?php foreach ($groupes as $groupe => $equipes): ?>
      <div class="col-md-4">
        <h4>Groupe <?= $groupe ?></h4>
        <ul class="list-group sortable-group-admin" id="adminGroup<?= $groupe ?>">
          <?php foreach ($equipes as $code => $nom): ?>
            <li class="list-group-item d-flex align-items-center" data-team="<?= $code ?>">
              <img src="https://flagcdn.com/24x18/<?= $flags[$code] ?>.png" alt="" style="margin-right:8px;">
              <?= $nom ?>
            </li>
          <?php endforeach; ?>
        </ul>
        <input type="hidden" name="classement_<?= $groupe ?>" id="inputClassement<?= $groupe ?>">
        <div class="form-check mt-2">
          <input class="form-check-input" type="checkbox" name="final_<?= $groupe ?>" id="final_<?= $groupe ?>">
          <label class="form-check-label" for="final_<?= $groupe ?>">Classement final</label>
        </div>
      </div>
    <?php endforeach; ?>
    </div>
    <button type="submit" class="btn btn-primary mt-3">Enregistrer les résultats</button>
  </form>
</div>

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script>
$(function() {
  $(".sortable-group-admin").sortable({
    placeholder: "ui-state-highlight"
  });

  $("#adminGroupForm").on("submit", function() {
    <?php foreach ($groupes as $groupe => $equipes): ?>
      var ordre = [];
      $("#adminGroup<?= $groupe ?> li").each(function() {
        ordre.push($(this).data("team"));
      });
      $("#inputClassement<?= $groupe ?>").val(ordre.join(","));
    <?php endforeach; ?>
  });
});
</script>

<?php include 'templates/footer.php'; ?> 