<?php
if (session_status() === PHP_SESSION_NONE) session_start();
// Autoriser les rôles 'admin' et 'stat'
if (!isset($_SESSION['role']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'stat')) {
    header('Location: ../index.php');
    exit;
}

// Pages disponibles selon le rôle
$all_admin_pages = [
    'dashboard.php' => 'Dashboard',
    'utilisateurs.php' => 'Liste des utilisateurs',
    'configuration.php' => 'Configuration',
    'matchs.php' => 'Gestion des matchs',
    'groupes.php' => 'Gestion des groupes',
    'questions.php' => 'Gestion des questions',
    'phase_management.php' => 'Gestion des phases',
    // 'points_par_phase.php' => 'Points par phase',        // Masqué
    // 'points_totaux.php' => 'Points totaux',              // Masqué
    // 'points_par_site.php' => 'Points par critères',      // Masqué
    'titulaires.php' => 'Gestion joueurs Maroc',
    'titulaires_match.php' => 'Titulaires par match',
    'photo_challenges.php' => 'Défis photos',
    'mur_messages.php' => 'Gestion murs de message',
    'clear_user_data.php' => 'Supprimer pronostics',
];

// Filtrer les pages selon le rôle
if ($_SESSION['role'] === 'stat') {
    // Le rôle 'stat' voit dashboard, utilisateurs et gestion mur de messages
    $admin_pages = [
        'dashboard.php' => 'Dashboard',
        'utilisateurs.php' => 'Liste des utilisateurs',
        'mur_messages.php' => 'Gestion murs de message',
    ];
} else {
    // Le rôle 'admin' voit toutes les pages
    $admin_pages = $all_admin_pages;
}

$current = basename($_SERVER['SCRIPT_NAME']);

// Vérifier que l'utilisateur a accès à la page actuelle
if ($_SESSION['role'] === 'stat' && !isset($admin_pages[$current])) {
    header('Location: dashboard.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin CAN 2025</title>
    <link rel="stylesheet" href="../assets/style_admin.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <style>
    body { background: #003e22; }
    .sidebar { min-height: 100vh; background: #1e293b; color: #fff; }
    .sidebar .nav-link { color: #fff; font-weight: 500; }
    .sidebar .nav-link.active, .sidebar .nav-link:hover { background: #b71c1c; color: #fff; }
    </style>
</head>
<body>
<!-- Burger menu mobile -->
<nav class="navbar navbar-dark bg-dark d-md-none">
  <div class="container-fluid">
    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#adminSidebarMobile" aria-controls="adminSidebarMobile" aria-label="Menu admin">
      <span class="navbar-toggler-icon"></span>
    </button>
    <span class="navbar-brand ms-2">Admin CAN 2025</span>
  </div>
</nav>
<!-- Sidebar mobile (offcanvas) -->
<div class="offcanvas offcanvas-start d-md-none" tabindex="-1" id="adminSidebarMobile" aria-labelledby="adminSidebarMobileLabel">
  <div class="offcanvas-header">
    <h5 class="offcanvas-title" id="adminSidebarMobileLabel">Menu admin</h5>
    <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Fermer"></button>
  </div>
  <div class="offcanvas-body">
    <ul class="nav flex-column gap-2">
      <?php foreach ($admin_pages as $file => $label): ?>
        <li class="nav-item">
          <a class="nav-link<?= $current === $file ? ' active' : '' ?>" href="<?= $file ?>" data-bs-dismiss="offcanvas"><?= $label ?></a>
        </li>
      <?php endforeach; ?>
      <li class="nav-item mt-4"><a class="nav-link text-danger fw-bold" href="../logout.php">Déconnexion</a></li>
    </ul>
  </div>
</div>
<div class="container-fluid">
  <div class="row">
    <nav class="col-md-2 d-none d-md-block sidebar py-4">
      <div class="position-sticky">
        <ul class="nav flex-column gap-2">
          <?php foreach ($admin_pages as $file => $label): ?>
            <li class="nav-item">
              <a class="nav-link<?= $current === $file ? ' active' : '' ?>" href="<?= $file ?>"><?= $label ?></a>
            </li>
          <?php endforeach; ?>
          <li class="nav-item mt-4"><a class="nav-link text-danger fw-bold" href="../logout.php">Déconnexion</a></li>
        </ul>
      </div>
    </nav>
    <main class="col-md-10 ms-sm-auto px-md-4 py-4"> 
<script>
  $(function() {
    // Redirection fiable sur mobile pour le menu offcanvas
    $(document).on('click', '.offcanvas .nav-link', function(e) {
      var href = $(this).attr('href');
      // Ne gère pas la déconnexion (logout)
      if (!href || href.indexOf('logout') !== -1) return;
      e.preventDefault();
      var offcanvasEl = $(this).closest('.offcanvas')[0];
      var bsOffcanvas = bootstrap.Offcanvas.getOrCreateInstance(offcanvasEl);
      bsOffcanvas.hide();
      setTimeout(function() { window.location = href; }, 350); // attendre la fermeture
    });
  });
</script> 