<?php
session_start();
require 'includes/db.php';

// Récupérer tous les utilisateurs et leurs points par groupe
$sql = "SELECT u.username, gp.groupe, gp.points FROM Users u LEFT JOIN groupe_points gp ON u.id = gp.user_id ORDER BY u.username, gp.groupe";
$result = $mysqli->query($sql);

// Organiser les données
$classement = [];
$groupes = ['A','B','C','D','E','F'];
while ($row = $result->fetch_assoc()) {
    $user = $row['username'];
    $groupe = $row['groupe'];
    $points = (int)($row['points'] ?? 0);
    if (!isset($classement[$user])) {
        $classement[$user] = ['total' => 0];
        foreach ($groupes as $g) $classement[$user][$g] = 0;
    }
    if ($groupe) {
        $classement[$user][$groupe] = $points;
        $classement[$user]['total'] += $points;
    }
}
$result->close();

// Points vainqueur CAN
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
$points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;

// Trier par total de points décroissant
uksort($classement, function($a, $b) use ($classement) {
    return $classement[$b]['total'] <=> $classement[$a]['total'];
});

foreach ($classement as $user => &$data) {
    // Points vainqueur CAN
    $pts_vainqueur = 0;
    if ($winner_team) {
        $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions wp JOIN Users u ON wp.user_id = u.id WHERE u.username = ?');
        $stmt3->bind_param('s', $user);
        $stmt3->execute();
        $stmt3->bind_result($user_team);
        $stmt3->fetch();
        $stmt3->close();
        if ($user_team && $user_team === $winner_team) {
            $pts_vainqueur = $points_vainqueur_can;
        }
    }
    $data['vainqueur'] = $pts_vainqueur;
    $data['total'] += $pts_vainqueur;
}

include 'templates/header.php';
?>
<div class="container py-4">
  <h2 class="mb-4 text-center" style="color:white;">Classement général - Pronostics Groupes</h2>
  <div class="table-responsive">
    <table class="table table-bordered table-striped bg-white">
      <thead class="table-dark">
        <tr>
          <th>Utilisateur</th>
          <th>Total</th>
          <?php foreach ($groupes as $g): ?>
            <th>Groupe <?= $g ?></th>
          <?php endforeach; ?>
          <th>Vainqueur CAN</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($classement as $user => $data): ?>
          <tr>
            <td><?= htmlspecialchars($user) ?></td>
            <td class="fw-bold text-success"><?= $data['total'] ?></td>
            <?php foreach ($groupes as $g): ?>
              <td><?= $data[$g] ?></td>
            <?php endforeach; ?>
            <td><?= $data['vainqueur'] ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include 'templates/footer.php'; ?> 