<?php
session_start();
require_once '../includes/db.php';

// Vérifier que l'utilisateur est admin
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

include 'admin_header.php';

// Traitement de la suppression
$message = '';
$error = '';
$tables_cleared = [];
$total_deleted = 0;

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delete'])) {
    try {
        // Trouver toutes les tables avec une colonne user_id
        $result = $mysqli->query("
            SELECT DISTINCT TABLE_NAME 
            FROM INFORMATION_SCHEMA.COLUMNS 
            WHERE TABLE_SCHEMA = DATABASE() 
            AND COLUMN_NAME = 'user_id'
        ");
        
        if ($result) {
            while ($row = $result->fetch_assoc()) {
                $table_name = $row['TABLE_NAME'];
                
                // Compter les enregistrements avant suppression
                $count_result = $mysqli->query("SELECT COUNT(*) as count FROM `{$table_name}` WHERE user_id IS NOT NULL");
                $count_row = $count_result->fetch_assoc();
                $count_before = $count_row['count'] ?? 0;
                
                // Supprimer les données où user_id n'est pas NULL
                // On utilise DELETE au lieu de TRUNCATE pour préserver la structure
                $delete_query = "DELETE FROM `{$table_name}` WHERE user_id IS NOT NULL";
                if ($mysqli->query($delete_query)) {
                    $tables_cleared[] = [
                        'name' => $table_name,
                        'deleted' => $count_before
                    ];
                    $total_deleted += $count_before;
                } else {
                    $error .= "Erreur lors de la suppression dans {$table_name}: " . $mysqli->error . "<br>";
                }
            }
            $result->close();
            
            if (empty($error)) {
                $message = "Suppression réussie ! {$total_deleted} enregistrements supprimés dans " . count($tables_cleared) . " table(s).";
            }
        } else {
            $error = "Erreur lors de la recherche des tables: " . $mysqli->error;
        }
    } catch (Exception $e) {
        $error = "Erreur: " . $e->getMessage();
    }
}

// Récupérer la liste des tables avec user_id pour affichage
$tables_list = [];
$result = $mysqli->query("
    SELECT DISTINCT TABLE_NAME 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
    AND COLUMN_NAME = 'user_id'
    ORDER BY TABLE_NAME
");

if ($result) {
    while ($row = $result->fetch_assoc()) {
        $table_name = $row['TABLE_NAME'];
        
        // Compter les enregistrements dans chaque table
        $count_result = $mysqli->query("SELECT COUNT(*) as count FROM `{$table_name}` WHERE user_id IS NOT NULL");
        $count_row = $count_result->fetch_assoc();
        $count = $count_row['count'] ?? 0;
        
        $tables_list[] = [
            'name' => $table_name,
            'count' => $count
        ];
    }
    $result->close();
}
?>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center mb-4">
                <h2 class="text-white">
                    <i class="fas fa-trash-alt me-2"></i>Suppression des pronostics et activités
                </h2>
                <a href="dashboard.php" class="btn btn-secondary">
                    <i class="fas fa-arrow-left me-2"></i>Retour au tableau de bord
                </a>
            </div>

            <?php if ($message): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i><?= htmlspecialchars($message) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <?php if ($error): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i><?= $error ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                </div>
            <?php endif; ?>

            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-danger text-white">
                    <h5 class="mb-0">
                        <i class="fas fa-exclamation-triangle me-2"></i>Attention : Action irréversible
                    </h5>
                </div>
                <div class="card-body">
                    <div class="alert alert-warning">
                        <strong><i class="fas fa-warning me-2"></i>Cette action va supprimer :</strong>
                        <ul class="mb-0 mt-2">
                            <li>Tous les pronostics de matchs</li>
                            <li>Tous les pronostics de groupes</li>
                            <li>Tous les pronostics de vainqueur</li>
                            <li>Tous les résultats de quiz</li>
                            <li>Toutes les activités des équipiers</li>
                            <li>Tous les points accumulés</li>
                            <li>Toutes les photos de challenge</li>
                            <li>Tous les messages du mur</li>
                            <li>Et toutes les autres données liées aux utilisateurs</li>
                        </ul>
                    </div>

                    <h6 class="mt-4 mb-3">Tables qui seront vidées :</h6>
                    <div class="table-responsive">
                        <table class="table table-bordered table-hover">
                            <thead class="table-dark">
                                <tr>
                                    <th>Nom de la table</th>
                                    <th class="text-center">Nombre d'enregistrements</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $total_records = 0;
                                foreach ($tables_list as $table): 
                                    $total_records += $table['count'];
                                ?>
                                    <tr>
                                        <td><code><?= htmlspecialchars($table['name']) ?></code></td>
                                        <td class="text-center">
                                            <span class="badge bg-<?= $table['count'] > 0 ? 'warning' : 'secondary' ?>">
                                                <?= number_format($table['count'], 0, ',', ' ') ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                                <?php if (empty($tables_list)): ?>
                                    <tr>
                                        <td colspan="2" class="text-center text-muted">Aucune table trouvée</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                            <tfoot class="table-dark">
                                <tr>
                                    <th>Total</th>
                                    <th class="text-center">
                                        <span class="badge bg-danger">
                                            <?= number_format($total_records, 0, ',', ' ') ?>
                                        </span>
                                    </th>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <?php if (!empty($tables_cleared)): ?>
                        <div class="mt-4">
                            <h6>Résultat de la suppression :</h6>
                            <div class="table-responsive">
                                <table class="table table-sm table-bordered">
                                    <thead class="table-success">
                                        <tr>
                                            <th>Table</th>
                                            <th class="text-center">Enregistrements supprimés</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($tables_cleared as $table): ?>
                                            <tr>
                                                <td><code><?= htmlspecialchars($table['name']) ?></code></td>
                                                <td class="text-center">
                                                    <span class="badge bg-success">
                                                        <?= number_format($table['deleted'], 0, ',', ' ') ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    <?php endif; ?>

                    <form method="POST" class="mt-4" onsubmit="return confirm('Êtes-vous ABSOLUMENT SÛR de vouloir supprimer toutes ces données ? Cette action est IRRÉVERSIBLE !');">
                        <div class="d-flex justify-content-end gap-2">
                            <a href="dashboard.php" class="btn btn-secondary">
                                <i class="fas fa-times me-2"></i>Annuler
                            </a>
                            <button type="submit" name="confirm_delete" value="1" class="btn btn-danger">
                                <i class="fas fa-trash-alt me-2"></i>Supprimer toutes les données
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
    .table {
        background-color: #fff;
        color: #000;
    }
    .table thead th {
        border-bottom: 2px solid #dee2e6;
        color: #fff;
    }
    .table tbody td {
        color: #000;
    }
    code {
        background-color: #f8f9fa;
        padding: 2px 6px;
        border-radius: 3px;
        font-size: 0.9em;
    }
</style>

<?php include 'admin_footer.php'; ?>

