<?php include 'admin_header.php'; ?>
<?php
require '../includes/db.php';

// Récupérer les configurations actuelles
$deadline_file = __DIR__.'/../includes/prediction_deadline.txt';
$prediction_deadline = file_exists($deadline_file) ? trim(file_get_contents($deadline_file)) : '12:00';

$phase_file = __DIR__.'/../includes/phase_dashboard.txt';
$phase_to_show = file_exists($phase_file) ? trim(file_get_contents($phase_file)) : '';

// Configuration pour les pronostics de groupes
$groupes_deadline_file = __DIR__.'/../includes/groupes_deadline.txt';
$groupes_deadline = file_exists($groupes_deadline_file) ? trim(file_get_contents($groupes_deadline_file)) : '';

// Configuration pour le délai (en heures) avant clôture des pronostics de matchs
$match_deadline_hours_file = __DIR__.'/../includes/match_deadline_hours.txt';
$match_deadline_hours = file_exists($match_deadline_hours_file) ? trim(file_get_contents($match_deadline_hours_file)) : '1';

// Configuration pour le pronostic du vainqueur
$winner_deadline_file = __DIR__.'/../includes/winner_deadline.txt';
$winner_deadline = file_exists($winner_deadline_file) ? trim(file_get_contents($winner_deadline_file)) : '';

// Configuration des points
$points_score_exact_file = __DIR__.'/../includes/points_score_exact.txt';
$points_score_exact = file_exists($points_score_exact_file) ? trim(file_get_contents($points_score_exact_file)) : '10';
$points_bon_vainqueur_file = __DIR__.'/../includes/points_bon_vainqueur.txt';
$points_bon_vainqueur = file_exists($points_bon_vainqueur_file) ? trim(file_get_contents($points_bon_vainqueur_file)) : '5';
$points_bonus_both_file = __DIR__.'/../includes/points_bonus_both.txt';
$points_bonus_both = file_exists($points_bonus_both_file) ? trim(file_get_contents($points_bonus_both_file)) : '15';
$points_vainqueur_can_file = __DIR__.'/../includes/points_vainqueur_can.txt';
$points_vainqueur_can = file_exists($points_vainqueur_can_file) ? trim(file_get_contents($points_vainqueur_can_file)) : '100';
$points_groupe_file = __DIR__.'/../includes/points_groupe.txt';
$points_groupe = file_exists($points_groupe_file) ? trim(file_get_contents($points_groupe_file)) : '5';

// Gestion équipe vainqueur CAN
$equipes = [
    'MAR' => 'Maroc', 'MAL' => 'Mali', 'ZAM' => 'Zambie', 'COM' => 'Comores',
    'EGY' => 'Égypte', 'RSA' => 'Afrique du Sud', 'ANG' => 'Angola', 'ZIM' => 'Zimbabwe',
    'NGA' => 'Nigeria', 'TUN' => 'Tunisie', 'UGA' => 'Ouganda', 'TAN' => 'Tanzanie',
    'SEN' => 'Sénégal', 'COD' => 'RD Congo', 'BEN' => 'Bénin', 'BOT' => 'Botswana',
    'ALG' => 'Algérie', 'BFA' => 'Burkina Faso', 'EQG' => 'Guinée Équatoriale', 'SUD' => 'Soudan',
    'CIV' => "Côte d'Ivoire", 'CMR' => 'Cameroun', 'GAB' => 'Gabon', 'MOZ' => 'Mozambique'
];
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
if (isset($_POST['set_winner_team'])) {
    $team = $_POST['winner_team'] ?? '';
    if ($team && isset($equipes[$team])) {
        $mysqli->query("INSERT INTO winner_result (id, team, set_at) VALUES (1, '$team', NOW()) ON DUPLICATE KEY UPDATE team = VALUES(team), set_at = NOW()");
        $winner_team = $team;
        echo '<script>Swal.fire("Succès", "Vainqueur CAN enregistré !", "success");</script>';
    }
}

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['prediction_deadline'])) {
        file_put_contents($deadline_file, $_POST['prediction_deadline']);
        $prediction_deadline = $_POST['prediction_deadline'];
        echo '<script>Swal.fire("Succès", "Date limite des pronostics mise à jour !", "success");</script>';
    }
    if (isset($_POST['phase_to_show'])) {
        file_put_contents($phase_file, $_POST['phase_to_show']);
        $phase_to_show = $_POST['phase_to_show'];
        echo '<script>Swal.fire("Succès", "Phase affichée mise à jour !", "success");</script>';
    }
    if (isset($_POST['groupes_deadline'])) {
        file_put_contents($groupes_deadline_file, $_POST['groupes_deadline']);
        $groupes_deadline = $_POST['groupes_deadline'];
        echo '<script>Swal.fire("Succès", "Date limite des pronostics de groupes mise à jour !", "success");</script>';
    }
    if (isset($_POST['match_deadline_hours'])) {
        file_put_contents($match_deadline_hours_file, $_POST['match_deadline_hours']);
        $match_deadline_hours = $_POST['match_deadline_hours'];
        echo '<script>Swal.fire("Succès", "Délai de clôture des pronostics de matchs mis à jour !", "success");</script>';
    }
    if (isset($_POST['winner_deadline'])) {
        file_put_contents($winner_deadline_file, $_POST['winner_deadline']);
        $winner_deadline = $_POST['winner_deadline'];
        echo '<script>Swal.fire("Succès", "Date limite du pronostic vainqueur mise à jour !", "success");</script>';
    }
    if (isset($_POST['points_score_exact'])) {
        file_put_contents($points_score_exact_file, $_POST['points_score_exact']);
        $points_score_exact = $_POST['points_score_exact'];
    }
    if (isset($_POST['points_bon_vainqueur'])) {
        file_put_contents($points_bon_vainqueur_file, $_POST['points_bon_vainqueur']);
        $points_bon_vainqueur = $_POST['points_bon_vainqueur'];
    }
    if (isset($_POST['points_bonus_both'])) {
        file_put_contents($points_bonus_both_file, $_POST['points_bonus_both']);
        $points_bonus_both = $_POST['points_bonus_both'];
    }
    if (isset($_POST['points_vainqueur_can'])) {
        file_put_contents($points_vainqueur_can_file, $_POST['points_vainqueur_can']);
        $points_vainqueur_can = $_POST['points_vainqueur_can'];
    }
    if (isset($_POST['points_groupe'])) {
        file_put_contents($points_groupe_file, $_POST['points_groupe']);
        $points_groupe = $_POST['points_groupe'];
    }
}

// Récupérer les phases disponibles
$phases = [];
$result = $mysqli->query('SELECT DISTINCT phase FROM Matches ORDER BY match_date ASC');
while($row = $result->fetch_assoc()) {
    $phases[] = $row['phase'];
}
$result->close();

// Récupérer les statistiques
$total_matches = $mysqli->query('SELECT COUNT(*) as nb FROM Matches')->fetch_assoc()['nb'];
$completed_matches = $mysqli->query('SELECT COUNT(*) as nb FROM Matches WHERE status = "completed"')->fetch_assoc()['nb'];
$total_users = $mysqli->query('SELECT COUNT(*) as nb FROM Users WHERE role = "user"')->fetch_assoc()['nb'];
$total_predictions = $mysqli->query('SELECT COUNT(*) as nb FROM Predictions')->fetch_assoc()['nb'];
$total_groupes_predictions = $mysqli->query('SELECT COUNT(*) as nb FROM groupe_predictions')->fetch_assoc()['nb'];
?>

<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2 class="mb-0">⚙️ Configuration du système</h2>
        <small class="text-muted">Dernière mise à jour : <?= date('d/m/Y H:i') ?></small>
    </div>
    
    <!-- Configuration compacte en 2 colonnes -->
    <div class="row">
        <!-- Colonne gauche - Délais et Vainqueur -->
        <div class="col-lg-6">
            <!-- Délais de clôture -->
            <div class="card border-0 shadow-sm mb-3">
                <div class="card-header bg-primary text-white py-2">
                    <h6 class="mb-0"><i class="fas fa-clock me-2"></i>Délais de clôture</h6>
                </div>
                <div class="card-body p-3">
                    <form method="post" class="row g-2">
                        <div class="col-md-6">
                            <label class="form-label small">Délai matchs (heures)</label>
                            <input type="number" min="0" step="1" class="form-control form-control-sm" name="match_deadline_hours" value="<?= htmlspecialchars($match_deadline_hours) ?>" required>
                            <small class="text-muted">Actuellement: <?= htmlspecialchars($match_deadline_hours) ?>h</small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small">Délai groupes</label>
                            <input type="datetime-local" class="form-control form-control-sm" name="groupes_deadline" value="<?= htmlspecialchars($groupes_deadline) ?>">
                            <small class="text-muted">
                                <?= $groupes_deadline ? date('d/m H:i', strtotime($groupes_deadline)) : 'Non défini' ?>
                            </small>
                        </div>
                        <div class="col-md-6">
                            <label class="form-label small">Délai vainqueur</label>
                            <input type="datetime-local" class="form-control form-control-sm" name="winner_deadline" value="<?= htmlspecialchars($winner_deadline) ?>">
                            <small class="text-muted">
                                <?= $winner_deadline ? date('d/m H:i', strtotime($winner_deadline)) : 'Non défini' ?>
                            </small>
                        </div>
                        <div class="col-md-6 d-flex align-items-end">
                            <button type="submit" class="btn btn-primary btn-sm w-100">Enregistrer délais</button>
                        </div>
                    </form>
                </div>
            </div>

            <!-- Gestion vainqueur CAN -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-success text-white py-2">
                    <h6 class="mb-0"><i class="fas fa-trophy me-2"></i>Vainqueur CAN 2025</h6>
                </div>
                <div class="card-body p-3">
                    <form method="post">
                        <div class="row g-2">
                            <div class="col-md-8">
                                <label class="form-label small">Équipe gagnante</label>
                                <select class="form-select form-select-sm" name="winner_team" required>
                                    <option value="">-- Choisir --</option>
                                    <?php foreach ($equipes as $code => $nom): ?>
                                        <option value="<?= $code ?>" <?= ($winner_team === $code) ? 'selected' : '' ?>><?= $nom ?> (<?= $code ?>)</option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-4 d-flex align-items-end">
                                <button type="submit" name="set_winner_team" class="btn btn-success btn-sm w-100">Enregistrer</button>
                            </div>
                        </div>
                        <?php if ($winner_team): ?>
                            <div class="mt-2 alert alert-success alert-sm py-2">
                                <strong>Vainqueur actuel :</strong> <?= $equipes[$winner_team] ?> (<?= $winner_team ?>)
                            </div>
                        <?php endif; ?>
                    </form>
                </div>
            </div>
        </div>

        <!-- Colonne droite - Points -->
        <div class="col-lg-6">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-warning text-dark py-2">
                    <h6 class="mb-0"><i class="fas fa-coins me-2"></i>Configuration des points</h6>
                </div>
                <div class="card-body p-3">
                    <form method="post">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="form-label small">Score exact (match)</label>
                                <input type="number" class="form-control form-control-sm" name="points_score_exact" value="<?= htmlspecialchars($points_score_exact) ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small">Bon vainqueur (match)</label>
                                <input type="number" class="form-control form-control-sm" name="points_bon_vainqueur" value="<?= htmlspecialchars($points_bon_vainqueur) ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small">Vainqueur CAN</label>
                                <input type="number" class="form-control form-control-sm" name="points_vainqueur_can" value="<?= htmlspecialchars($points_vainqueur_can) ?>" required>
                            </div>
                            <div class="col-md-6">
                                <label class="form-label small">Équipe groupe</label>
                                <input type="number" class="form-control form-control-sm" name="points_groupe" value="<?= htmlspecialchars($points_groupe) ?>" required>
                            </div>
                            <div class="col-12">
                                <button type="submit" class="btn btn-warning btn-sm w-100">Enregistrer points</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(function() {
    // Mise à jour AJAX de la configuration
    $('#match_deadline_hours').on('change', function() {
        const value = $(this).val();
        $.post('../ajax/update_config.php', {
            action: 'match_deadline_hours',
            value: value
        }, function(data) {
            if(data.success) {
                Swal.fire('Succès', data.message, 'success');
                // Recharger la page pour mettre à jour les statuts
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                Swal.fire('Erreur', data.message, 'error');
            }
        }, 'json');
    });

    $('#groupes_deadline').on('change', function() {
        const value = $(this).val();
        $.post('../ajax/update_config.php', {
            action: 'groupes_deadline',
            value: value
        }, function(data) {
            if(data.success) {
                Swal.fire('Succès', data.message, 'success');
                // Recharger la page pour mettre à jour les statuts
                setTimeout(() => {
                    location.reload();
                }, 1500);
            } else {
                Swal.fire('Erreur', data.message, 'error');
            }
        }, 'json');

    $('#phase_to_show').on('change', function() {
        const value = $(this).val();
        $.post('../ajax/update_config.php', {
            action: 'phase_to_show',
            value: value
        }, function(data) {
            if(data.success) {
                Swal.fire('Succès', data.message, 'success');
            } else {
                Swal.fire('Erreur', data.message, 'error');
            }
        }, 'json');
    });

    // Mise à jour automatique des statuts toutes les minutes
    setInterval(function() {
        updateMatchStatuses();
    }, 60000);

    function updateMatchStatuses() {
        const now = new Date();
        $('.match-status').each(function() {
            const deadline = $(this).data('deadline');
            const matchDate = new Date(deadline);
            
            if (now >= matchDate) {
                $(this).removeClass('bg-success').addClass('bg-danger');
                $(this).text('Pronostics fermés');
            }
        });
    }
});
</script>

<?php include 'admin_footer.php'; ?> 