<style>
    p{
        color: black !important;
    }

</style>

<?php include 'admin_header.php'; ?>
<?php
// Définir le fuseau horaire GMT+1
date_default_timezone_set('Etc/GMT-1');
require '../includes/db.php';

function getNb($row) {
    return isset($row['nb']) ? $row['nb'] : (isset($row['COUNT(*)']) ? $row['COUNT(*)'] : 0);
}

// ===== STATISTIQUES GÉNÉRALES =====
$row = $mysqli->query('SELECT COUNT(*) as nb FROM Matches')->fetch_assoc();
$total_matches = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM Matches WHERE status = "completed"')->fetch_assoc();
$completed_matches = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM Users WHERE role = "user"')->fetch_assoc();
$total_users = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM Predictions')->fetch_assoc();
$total_predictions = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM groupe_predictions')->fetch_assoc();
$total_groupes_predictions = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM winner_predictions')->fetch_assoc();
$total_winner_predictions = getNb($row);

// ===== STATISTIQUES QUIZ =====
$row = $mysqli->query('SELECT COUNT(*) as nb FROM quizz_results_phases')->fetch_assoc();
$total_quiz_completed = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM quizz_questions')->fetch_assoc();
$total_questions_fr = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM quizz_questions_ar')->fetch_assoc();
$total_questions_ar = getNb($row);

// ===== STATISTIQUES DÉFIS PHOTOS =====
$row = $mysqli->query('SELECT COUNT(*) as nb FROM challenge_photos')->fetch_assoc();
$total_photos_uploaded = getNb($row);
$row = $mysqli->query('SELECT COUNT(*) as nb FROM challenge_likes')->fetch_assoc();
$total_photo_likes = getNb($row);

// ===== STATISTIQUES ENGAGEMENT =====
// Utilisateurs avec prédictions (utilisateurs actifs)
$row = $mysqli->query('SELECT COUNT(DISTINCT user_id) as nb FROM Predictions')->fetch_assoc();
$users_with_predictions = getNb($row);

// Utilisateurs avec quiz complétés (locked = 1)
$row = $mysqli->query('SELECT COUNT(DISTINCT user_id) as nb FROM quizz_results_phases WHERE locked = 1')->fetch_assoc();
$users_with_quiz = getNb($row);

// Utilisateurs avec photos uploadées
$row = $mysqli->query('SELECT COUNT(DISTINCT user_id) as nb FROM challenge_photos')->fetch_assoc();
$users_with_photos = getNb($row);

// ===== TOP SCORES =====
$top_scores = [];
$result = $mysqli->query("
    SELECT u.username, 
           COALESCE(SUM(mp.points + IFNULL(mp.titulaire_11,0)), 0) + 
           COALESCE((SELECT SUM(points) FROM groupe_points WHERE user_id = u.id), 0) + 
           COALESCE((SELECT SUM(score) FROM quizz_results_phases WHERE user_id = u.id), 0) + 
           COALESCE((SELECT CASE WHEN wr.team = wp.team THEN 100 ELSE 0 END 
                     FROM winner_predictions wp 
                     LEFT JOIN winner_result wr ON 1=1 
                     WHERE wp.user_id = u.id LIMIT 1), 0) as total_score
    FROM Users u 
    LEFT JOIN match_points mp ON u.id = mp.user_id 
    WHERE u.role = 'user'
    GROUP BY u.id, u.username 
    ORDER BY total_score DESC 
    LIMIT 10
");
while ($row = $result->fetch_assoc()) {
    $top_scores[] = $row;
}
$result->close();

// ===== STATISTIQUES PAR PHASE =====
$phase_stats = [];

// Récupérer les statistiques des matchs par phase
$result = $mysqli->query("
    SELECT phase, 
           COUNT(*) as total_matches,
           SUM(CASE WHEN status = 'completed' THEN 1 ELSE 0 END) as completed_matches
    FROM Matches 
    GROUP BY phase
    ORDER BY 
        CASE phase 
            WHEN 'Phase de groupes · Journée 1 sur 3' THEN 1
            WHEN 'Phase de groupes · Journée 2 sur 3' THEN 2
            WHEN 'Phase de groupes · Journée 3 sur 3' THEN 3
            WHEN '8e de finale' THEN 4
            WHEN 'Quart de finale' THEN 5
            WHEN 'Demi-finale' THEN 6
            WHEN 'Match pour la 3e place' THEN 7
            WHEN 'Finale' THEN 8
            ELSE 9
        END
");

$phases_data = [];
while ($row = $result->fetch_assoc()) {
    $phases_data[$row['phase']] = $row;
}
$result->close();

// Récupérer les participants par phase
$result = $mysqli->query("
    SELECT m.phase, COUNT(DISTINCT p.user_id) as users_participated
    FROM Matches m
    LEFT JOIN Predictions p ON m.id = p.match_id
    GROUP BY m.phase
");

while ($row = $result->fetch_assoc()) {
    if (isset($phases_data[$row['phase']])) {
        $phases_data[$row['phase']]['users_participated'] = $row['users_participated'];
    }
}
$result->close();

// Convertir en tableau indexé
$phase_stats = array_values($phases_data);

// ===== STATISTIQUES RÉCENTES (7 derniers jours) =====
$recent_predictions = [];
$result = $mysqli->query("
    SELECT DATE(created_at) as date, COUNT(*) as count 
    FROM Predictions 
    WHERE created_at >= DATE_SUB(NOW(), INTERVAL 7 DAY)
    GROUP BY DATE(created_at) 
    ORDER BY date DESC
");
while ($row = $result->fetch_assoc()) {
    $recent_predictions[] = $row;
}
$result->close();

// ===== STATISTIQUES QUIZ PAR PHASE =====
$quiz_phase_stats = [];
$result = $mysqli->query("
    SELECT phase, 
           COUNT(*) as completions,
           AVG(score) as avg_score,
           MAX(score) as max_score
    FROM quizz_results_phases 
    WHERE locked = 1
    GROUP BY phase
    ORDER BY 
        CASE phase 
            WHEN 'Phase de groupes' THEN 1
            WHEN '8e de finale' THEN 2
            WHEN 'Quart de finale' THEN 3
            WHEN 'Demi-finale' THEN 4
            ELSE 5
        END
");
while ($row = $result->fetch_assoc()) {
    $quiz_phase_stats[] = $row;
}
$result->close();

// Récupérer le vainqueur CAN et les points (défini au début pour éviter les erreurs)
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
$points_vainqueur_can = file_exists('includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('includes/points_vainqueur_can.txt'))) : 100;

// ===== STATISTIQUES PAR VILLE =====
$stats_ville = [];

// Récupérer toutes les villes avec leurs utilisateurs
$result = $mysqli->query("
    SELECT DISTINCT ville, COUNT(DISTINCT id) as nb_users
    FROM Users 
    WHERE role = 'user' AND ville IS NOT NULL AND ville != ''
    GROUP BY ville
    ORDER BY nb_users DESC
    LIMIT 10
");

$villes_with_scores = [];
while ($row = $result->fetch_assoc()) {
    $ville = $row['ville'];
    $nb_users = $row['nb_users'];
    
    // Récupérer les utilisateurs de cette ville
    $stmt_users = $mysqli->prepare("SELECT id FROM Users WHERE ville = ? AND role = 'user'");
    $stmt_users->bind_param('s', $ville);
    $stmt_users->execute();
    $result_users = $stmt_users->get_result();
    $user_ids = [];
    while ($user_row = $result_users->fetch_assoc()) {
        $user_ids[] = $user_row['id'];
    }
    $stmt_users->close();
    
    // Calculer les statistiques d'engagement
    $users_with_predictions = 0;
    $users_with_quiz = 0;
    $users_with_photos = 0;
    $total_score_ville = 0;
    
    foreach ($user_ids as $user_id) {
        // Vérifier les prédictions
        $stmt_pred = $mysqli->prepare("SELECT COUNT(*) as count FROM Predictions WHERE user_id = ?");
        $stmt_pred->bind_param('i', $user_id);
        $stmt_pred->execute();
        $result_pred = $stmt_pred->get_result();
        $row_pred = $result_pred->fetch_assoc();
        $stmt_pred->close();
        if ($row_pred['count'] > 0) $users_with_predictions++;
        
        // Vérifier les quiz
        $stmt_quiz = $mysqli->prepare("SELECT COUNT(*) as count FROM quizz_results_phases WHERE user_id = ? AND locked = 1");
        $stmt_quiz->bind_param('i', $user_id);
        $stmt_quiz->execute();
        $result_quiz = $stmt_quiz->get_result();
        $row_quiz = $result_quiz->fetch_assoc();
        $stmt_quiz->close();
        if ($row_quiz['count'] > 0) $users_with_quiz++;
        
        // Vérifier les photos
        $stmt_photo = $mysqli->prepare("SELECT COUNT(*) as count FROM challenge_photos WHERE user_id = ?");
        $stmt_photo->bind_param('i', $user_id);
        $stmt_photo->execute();
        $result_photo = $stmt_photo->get_result();
        $row_photo = $result_photo->fetch_assoc();
        $stmt_photo->close();
        if ($row_photo['count'] > 0) $users_with_photos++;
        
        // Calculer le score de l'utilisateur
        // Points matchs + titulaires
        $stmt = $mysqli->prepare('SELECT SUM(points) as pts, SUM(IFNULL(titulaire_11,0)) as titulaires FROM match_points WHERE user_id = ?');
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $result_mp = $stmt->get_result();
        $row_mp = $result_mp->fetch_assoc();
        $stmt->close();
        $pts_matchs = $row_mp['pts'] ?? 0;
        $pts_titulaires = $row_mp['titulaires'] ?? 0;
        
        // Points groupes
        $stmt_gp = $mysqli->prepare('SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?');
        $stmt_gp->bind_param('i', $user_id);
        $stmt_gp->execute();
        $result_gp = $stmt_gp->get_result();
        $row_gp = $result_gp->fetch_assoc();
        $stmt_gp->close();
        $pts_groupes = $row_gp['pts'] ?? 0;
        
        // Points vainqueur CAN
        $pts_vainqueur = 0;
        if ($winner_team) {
            $user_team = null;
            $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
            $stmt3->bind_param('i', $user_id);
            $stmt3->execute();
            $stmt3->bind_result($user_team);
            $stmt3->fetch();
            $stmt3->close();
            if ($user_team && $user_team === $winner_team) {
                $pts_vainqueur = $points_vainqueur_can;
            }
        }
        
        // Points quiz par phase
        $quiz_phases = ['Phase de groupes', '8e de finale', 'Quart de finale', 'Demi-finale'];
        $total_quiz_score = 0;
        foreach ($quiz_phases as $phase) {
            $stmt_quiz = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
            $stmt_quiz->bind_param('is', $user_id, $phase);
            $stmt_quiz->execute();
            $result_quiz = $stmt_quiz->get_result();
            $row_quiz = $result_quiz->fetch_assoc();
            $stmt_quiz->close();
            $total_quiz_score += $row_quiz['score'] ?? 0;
        }
        
        $user_total = intval($pts_matchs) + intval($pts_titulaires) + intval($pts_groupes) + intval($pts_vainqueur) + intval($total_quiz_score);
        $total_score_ville += $user_total;
    }
    
    $villes_with_scores[] = [
        'ville' => $ville,
        'nb_users' => $nb_users,
        'users_with_predictions' => $users_with_predictions,
        'users_with_quiz' => $users_with_quiz,
        'users_with_photos' => $users_with_photos,
        'total_score' => $total_score_ville,
        'avg_score' => $nb_users > 0 ? round($total_score_ville / $nb_users, 1) : 0
    ];
}
$result->close();

// Trier par score total décroissant
usort($villes_with_scores, function($a, $b) {
    return $b['total_score'] <=> $a['total_score'];
});
$stats_ville = $villes_with_scores;

// ===== STATISTIQUES PAR DÉPARTEMENT =====
$stats_departement = [];

// Récupérer tous les départements avec leurs utilisateurs
$result = $mysqli->query("
    SELECT DISTINCT departement, COUNT(DISTINCT id) as nb_users
    FROM Users 
    WHERE role = 'user' AND departement IS NOT NULL AND departement != ''
    GROUP BY departement
    ORDER BY nb_users DESC
    LIMIT 10
");

$departements_with_scores = [];
while ($row = $result->fetch_assoc()) {
    $departement = $row['departement'];
    $nb_users = $row['nb_users'];
    
    // Récupérer les utilisateurs de ce département
    $stmt_users = $mysqli->prepare("SELECT id FROM Users WHERE departement = ? AND role = 'user'");
    $stmt_users->bind_param('s', $departement);
    $stmt_users->execute();
    $result_users = $stmt_users->get_result();
    $user_ids = [];
    while ($user_row = $result_users->fetch_assoc()) {
        $user_ids[] = $user_row['id'];
    }
    $stmt_users->close();
    
    // Calculer les statistiques d'engagement
    $users_with_predictions = 0;
    $users_with_quiz = 0;
    $users_with_photos = 0;
    $total_score_departement = 0;
    
    foreach ($user_ids as $user_id) {
        // Vérifier les prédictions
        $stmt_pred = $mysqli->prepare("SELECT COUNT(*) as count FROM Predictions WHERE user_id = ?");
        $stmt_pred->bind_param('i', $user_id);
        $stmt_pred->execute();
        $result_pred = $stmt_pred->get_result();
        $row_pred = $result_pred->fetch_assoc();
        $stmt_pred->close();
        if ($row_pred['count'] > 0) $users_with_predictions++;
        
        // Vérifier les quiz
        $stmt_quiz = $mysqli->prepare("SELECT COUNT(*) as count FROM quizz_results_phases WHERE user_id = ? AND locked = 1");
        $stmt_quiz->bind_param('i', $user_id);
        $stmt_quiz->execute();
        $result_quiz = $stmt_quiz->get_result();
        $row_quiz = $result_quiz->fetch_assoc();
        $stmt_quiz->close();
        if ($row_quiz['count'] > 0) $users_with_quiz++;
        
        // Vérifier les photos
        $stmt_photo = $mysqli->prepare("SELECT COUNT(*) as count FROM challenge_photos WHERE user_id = ?");
        $stmt_photo->bind_param('i', $user_id);
        $stmt_photo->execute();
        $result_photo = $stmt_photo->get_result();
        $row_photo = $result_photo->fetch_assoc();
        $stmt_photo->close();
        if ($row_photo['count'] > 0) $users_with_photos++;
        
        // Calculer le score de l'utilisateur
        // Points matchs + titulaires
        $stmt = $mysqli->prepare('SELECT SUM(points) as pts, SUM(IFNULL(titulaire_11,0)) as titulaires FROM match_points WHERE user_id = ?');
        $stmt->bind_param('i', $user_id);
        $stmt->execute();
        $result_mp = $stmt->get_result();
        $row_mp = $result_mp->fetch_assoc();
        $stmt->close();
        $pts_matchs = $row_mp['pts'] ?? 0;
        $pts_titulaires = $row_mp['titulaires'] ?? 0;
        
        // Points groupes
        $stmt_gp = $mysqli->prepare('SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?');
        $stmt_gp->bind_param('i', $user_id);
        $stmt_gp->execute();
        $result_gp = $stmt_gp->get_result();
        $row_gp = $result_gp->fetch_assoc();
        $stmt_gp->close();
        $pts_groupes = $row_gp['pts'] ?? 0;
        
        // Points vainqueur CAN
        $pts_vainqueur = 0;
        if ($winner_team) {
            $user_team = null;
            $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
            $stmt3->bind_param('i', $user_id);
            $stmt3->execute();
            $stmt3->bind_result($user_team);
            $stmt3->fetch();
            $stmt3->close();
            if ($user_team && $user_team === $winner_team) {
                $pts_vainqueur = $points_vainqueur_can;
            }
        }
        
        // Points quiz par phase
        $quiz_phases = ['Phase de groupes', '8e de finale', 'Quart de finale', 'Demi-finale'];
        $total_quiz_score = 0;
        foreach ($quiz_phases as $phase) {
            $stmt_quiz = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
            $stmt_quiz->bind_param('is', $user_id, $phase);
            $stmt_quiz->execute();
            $result_quiz = $stmt_quiz->get_result();
            $row_quiz = $result_quiz->fetch_assoc();
            $stmt_quiz->close();
            $total_quiz_score += $row_quiz['score'] ?? 0;
        }
        
        $user_total = intval($pts_matchs) + intval($pts_titulaires) + intval($pts_groupes) + intval($pts_vainqueur) + intval($total_quiz_score);
        $total_score_departement += $user_total;
    }
    
    $departements_with_scores[] = [
        'departement' => $departement,
        'nb_users' => $nb_users,
        'users_with_predictions' => $users_with_predictions,
        'users_with_quiz' => $users_with_quiz,
        'users_with_photos' => $users_with_photos,
        'total_score' => $total_score_departement,
        'avg_score' => $nb_users > 0 ? round($total_score_departement / $nb_users, 1) : 0
    ];
}
$result->close();

// Trier par score total décroissant
usort($departements_with_scores, function($a, $b) {
    return $b['total_score'] <=> $a['total_score'];
});
$stats_departement = $departements_with_scores;


// Statistiques avancées : évolution des pronostics par jour
$stats_days = [];
$result = $mysqli->query("SELECT DATE(created_at) as day, COUNT(*) as nb FROM Predictions GROUP BY day ORDER BY day ASC");
while ($row = $result->fetch_assoc()) {
    $stats_days[] = $row;
}
$result->close();
$days = [];
$nb_preds = [];
foreach ($stats_days as $row) {
    $days[] = $row['day'];
    $nb_preds[] = $row['nb'];
}

// Top 5 équipes les plus pronostiquées comme vainqueur
$top_winners = [];
$result = $mysqli->query("SELECT team, COUNT(*) as nb FROM winner_predictions GROUP BY team ORDER BY nb DESC LIMIT 5");
while ($row = $result->fetch_assoc()) {
    $top_winners[] = $row;
}
$result->close();

// Charger la configuration du délai de clôture des pronostics de matchs
$match_deadline_hours_file = __DIR__.'/../includes/match_deadline_hours.txt';
$match_deadline_hours = 1; // Valeur par défaut : 1 heure
if (file_exists($match_deadline_hours_file)) {
    $match_deadline_hours = (int)trim(file_get_contents($match_deadline_hours_file));
    if ($match_deadline_hours <= 0) $match_deadline_hours = 1; // Minimum 1 heure
}
$stmt = $mysqli->prepare('SELECT * FROM Matches WHERE match_date > NOW() ORDER BY match_date ASC LIMIT 10');
$stmt->execute();
$result = $stmt->get_result();
$upcoming_matches = [];
while ($row = $result->fetch_assoc()) {
    $upcoming_matches[] = $row;
}
$stmt->close();

// Statistiques vainqueur CAN
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
$points_vainqueur_can = file_exists('../includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('../includes/points_vainqueur_can.txt'))) : 100;
$nb_gagnants_vainqueur = 0;
if ($winner_team) {
    $stmt = $mysqli->prepare('SELECT COUNT(*) as nb FROM winner_predictions WHERE team = ?');
    $stmt->bind_param('s', $winner_team);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $nb_gagnants_vainqueur = getNb($row);
    $stmt->close();
}
?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">📊 Dashboard CAN 2025 - BMCI</h2>
    <small class="text-white">Dernière mise à jour : <?= date('d/m/Y H:i') ?></small>
</div>

<!-- ===== KPI PRINCIPAUX ===== -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);">
            <div class="card-body text-white">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title text-white-50 mb-1">👥 Utilisateurs</h6>
                        <h3 class="mb-0 fw-bold"><?= number_format($total_users) ?></h3>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-users fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
            <div class="card-body text-white">
                <div class="d-flex justify-content-between">
                    <div>
                        <h6 class="card-title text-white-50 mb-1">⚽ Matchs</h6>
                        <h3 class="mb-0 fw-bold"><?= $completed_matches ?>/<?= $total_matches ?></h3>
                        <small class="text-white-75"><?= $total_matches > 0 ? round(($completed_matches/$total_matches)*100, 1) : 0 ?>% terminés</small>
                    </div>
                    <div class="align-self-center">
                        <i class="fas fa-futbol fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
            <div class="card-body text-white">
                <div class="d-flex justify-content-between">
                     <div>
                         <h6 class="card-title text-white-50 mb-1">🎯 Pronostics</h6>
                         <h3 class="mb-0 fw-bold"><?= number_format($total_predictions) ?></h3>
                     </div>
                    <div class="align-self-center">
                        <i class="fas fa-bullseye fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-lg-3 col-md-6 mb-3">
        <div class="card border-0 shadow-sm h-100" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
            <div class="card-body text-white">
                <div class="d-flex justify-content-between">
                     <div>
                         <h6 class="card-title text-white-50 mb-1">🧠 Quiz</h6>
                         <h3 class="mb-0 fw-bold"><?= number_format($total_quiz_completed) ?></h3>
                     </div>
                    <div class="align-self-center">
                        <i class="fas fa-brain fa-2x opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ===== STATISTIQUES DÉTAILLÉES ===== -->
<div class="row mb-4">
     <!-- Top Équipes Vainqueur -->
     <div class="col-lg-4 mb-4">
         <div class="card border-0 shadow-sm h-100">
             <div class="card-header bg-warning text-dark">
                 <h6 class="mb-0"><i class="fas fa-crown me-2"></i>Top Équipes Vainqueur</h6>
             </div>
             <div class="card-body">
                 <?php if (!empty($top_winners)): ?>
                     <?php foreach($top_winners as $index => $row): ?>
                         <div class="d-flex justify-content-between align-items-center mb-3">
                             <div class="d-flex align-items-center">
                                 <span class="badge bg-<?= $index < 3 ? ($index == 0 ? 'warning' : ($index == 1 ? 'secondary' : 'success')) : 'light text-dark' ?> me-2">
                                     <?= $index + 1 ?>
                                 </span>
                                 <span class="fw-bold"><?= htmlspecialchars($row['team']) ?></span>
                             </div>
                             <span class="badge bg-success"><?= $row['nb'] ?> votes</span>
                         </div>
                     <?php endforeach; ?>
                 <?php else: ?>
                     <p class="text-muted text-center">Aucune donnée disponible</p>
                 <?php endif; ?>
             </div>
         </div>
     </div>
    
    <!-- Contenu du quiz -->
    <div class="col-lg-4 mb-4">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fas fa-question-circle me-2"></i>Contenu Quiz</h6>
            </div>
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <span>Questions FR</span>
                    <span class="badge bg-primary"><?= $total_questions_fr ?></span>
                </div>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <span>Questions AR</span>
                    <span class="badge bg-primary"><?= $total_questions_ar ?></span>
                </div>
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <span>Quiz complétés</span>
                    <span class="badge bg-success"><?= $total_quiz_completed ?></span>
                </div>
                <div class="d-flex justify-content-between align-items-center">
                    <span>Likes photos</span>
                    <span class="badge bg-warning"><?= $total_photo_likes ?></span>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Top 5 Scores -->
    <div class="col-lg-4 mb-4">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-warning text-dark">
                <h6 class="mb-0"><i class="fas fa-trophy me-2"></i>Top 5 Scores</h6>
            </div>
            <div class="card-body">
                <?php if (!empty($top_scores)): ?>
                    <?php foreach (array_slice($top_scores, 0, 5) as $index => $user): ?>
                        <div class="d-flex justify-content-between align-items-center mb-2">
                            <div class="d-flex align-items-center">
                                <span class="badge bg-<?= $index < 3 ? ($index == 0 ? 'warning' : ($index == 1 ? 'secondary' : 'success')) : 'light text-dark' ?> me-2">
                                    <?= $index + 1 ?>
                                </span>
                                <small><?= htmlspecialchars($user['username']) ?></small>
                            </div>
                            <strong class="text-primary"><?= number_format($user['total_score']) ?> pts</strong>
                        </div>
                    <?php endforeach; ?>
                <?php else: ?>
                    <p class="text-muted text-center">Aucun score disponible</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- ===== PHASE ET ÉVOLUTION DES PRONOSTICS ===== -->
<div class="row mb-4">
    <!-- Phase -->
    <?php if (!empty($quiz_phase_stats)): ?>
    <div class="col-lg-6 mb-4">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fas fa-brain me-2"></i>Phase</h6>
            </div>
            <div class="card-body">
                <div class="row">
                    <?php foreach ($quiz_phase_stats as $quiz_phase): ?>
                        <div class="col-md-6 mb-3">
                            <div class="text-center p-3 border rounded">
                                <h6 class="text-muted mb-2"><?= htmlspecialchars($quiz_phase['phase']) ?></h6>
                                <div class="row">
                                    <div class="col-4">
                                        <div class="text-center">
                                            <h5 class="text-primary mb-0"><?= $quiz_phase['completions'] ?></h5>
                                            <small class="text-muted">Complétés</small>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="text-center">
                                            <h5 class="text-success mb-0"><?= round($quiz_phase['avg_score'], 1) ?></h5>
                                            <small class="text-muted">Moyenne</small>
                                        </div>
                                    </div>
                                    <div class="col-4">
                                        <div class="text-center">
                                            <h5 class="text-warning mb-0"><?= $quiz_phase['max_score'] ?></h5>
                                            <small class="text-muted">Max</small>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
    <!-- Évolution des Pronostics -->
    <div class="col-lg-6 mb-4">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="fas fa-chart-line me-2"></i>Évolution des Pronostics (7 derniers jours)</h6>
            </div>
            <div class="card-body">
                <canvas id="chartRecent" height="100"></canvas>
            </div>
        </div>
    </div>
</div>

<!-- ===== STATISTIQUES DE CONNEXION ===== -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-info text-white d-flex justify-content-between align-items-center">
                <h6 class="mb-0"><i class="fas fa-sign-in-alt me-2"></i>Statistiques de Connexion par Jour</h6>
                <div class="d-flex gap-2 align-items-center">
                    <label class="text-white small me-2">Du:</label>
                    <input type="date" id="loginStartDate" class="form-control form-control-sm" style="width: 150px;" value="<?= date('Y-m-d', strtotime('-7 days')) ?>">
                    <label class="text-white small me-2 ms-2">Au:</label>
                    <input type="date" id="loginEndDate" class="form-control form-control-sm" style="width: 150px;" value="<?= date('Y-m-d') ?>">
                    <button type="button" class="btn btn-light btn-sm ms-2" onclick="updateLoginStats()">
                        <i class="fas fa-filter me-1"></i>Filtrer
                    </button>
                </div>
            </div>
            <div class="card-body">
                <!-- Cartes de résumé -->
                <div class="row mb-4" id="loginSummaryCards">
                    <div class="col-md-4">
                        <div class="card border-0 shadow-sm text-center" style="background: linear-gradient(135deg, #4facfe 0%, #00f2fe 100%);">
                            <div class="card-body text-white">
                                <h6 class="text-white-50 mb-2">Total Connexions</h6>
                                <h3 class="mb-0 fw-bold" id="totalLoginsCount">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border-0 shadow-sm text-center" style="background: linear-gradient(135deg, #43e97b 0%, #38f9d7 100%);">
                            <div class="card-body text-white">
                                <h6 class="text-white-50 mb-2">Utilisateurs Uniques</h6>
                                <h3 class="mb-0 fw-bold" id="uniqueUsersCount">0</h3>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border-0 shadow-sm text-center" style="background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);">
                            <div class="card-body text-white">
                                <h6 class="text-white-50 mb-2">Moyenne par Jour</h6>
                                <h3 class="mb-0 fw-bold" id="avgPerDay">0</h3>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Graphique -->
                <div class="mb-4">
                    <canvas id="chartLoginStats" height="80"></canvas>
                </div>
                
                <!-- Tableau détaillé -->
                <div class="table-responsive">
                    <table class="table table-hover mb-0" id="loginStatsTable">
                        <thead>
                            <tr>
                                <th>Date</th>
                                <th class="text-center">Total Connexions</th>
                                <th class="text-center">Utilisateurs Uniques</th>
                                <th class="text-center">Moyenne par Utilisateur</th>
                            </tr>
                        </thead>
                        <tbody id="loginStatsTableBody">
                            <tr>
                                <td colspan="4" class="text-center text-muted">Chargement...</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ===== STATISTIQUES PAR PHASE ===== -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="fas fa-chart-bar me-2"></i>Statistiques par Phase</h6>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead>
                            <tr>
                                <th>Phase</th>
                                <th class="text-center">Matchs</th>
                                <th class="text-center">Terminés</th>
                                <th class="text-center">Participants</th>
                                <th class="text-center">Progression</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($phase_stats as $phase): ?>
                                <tr>
                                    <td><strong><?= htmlspecialchars($phase['phase']) ?></strong></td>
                                    <td class="text-center">
                                        <span class="badge bg-primary"><?= $phase['total_matches'] ?></span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-success"><?= $phase['completed_matches'] ?></span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-info"><?= $phase['users_participated'] ?></span>
                                    </td>
                                    <td class="text-center">
                                        <?php 
                                        $progress = $phase['total_matches'] > 0 ? ($phase['completed_matches'] / $phase['total_matches']) * 100 : 0;
                                        ?>
                                        <div class="progress" style="width: 100px; height: 20px;">
                                            <div class="progress-bar bg-<?= $progress == 100 ? 'success' : ($progress > 50 ? 'warning' : 'danger') ?>" 
                                                 style="width: <?= $progress ?>%">
                                                <?= round($progress, 1) ?>%
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- ===== GRAPHIQUES ET ANALYSES ===== -->
<div class="row mb-4">
    <!-- Vainqueur CAN 2025 -->
    <?php if ($winner_team): ?>
    <div class="col-lg-4 mb-4">
        <div class="card border-0 shadow-sm h-100">
            <div class="card-header bg-success text-white">
                <h6 class="mb-0"><i class="fas fa-trophy me-2"></i>Vainqueur CAN 2025</h6>
            </div>
            <div class="card-body">
                <div class="text-center">
                    <div class="mb-3">
                        <h5 class="text-success mb-1"><?= htmlspecialchars($winner_team) ?></h5>
                        <small class="text-muted">Équipe gagnante</small>
                    </div>
                    <div class="mb-3">
                        <h5 class="text-primary mb-1"><?= $nb_gagnants_vainqueur ?></h5>
                        <small class="text-muted">Utilisateurs ayant trouvé</small>
                    </div>
                    <div class="mb-3">
                        <h5 class="text-warning mb-1"><?= $points_vainqueur_can ?></h5>
                        <small class="text-muted">Points par personne</small>
                    </div>
                    <div>
                        <h5 class="text-info mb-1"><?= $nb_gagnants_vainqueur * $points_vainqueur_can ?></h5>
                        <small class="text-muted">Total points attribués</small>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>
    
</div>


<!-- ===== STATISTIQUES PAR DÉPARTEMENT ===== -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-warning text-dark">
                <h6 class="mb-0"><i class="fas fa-map-marked-alt me-2"></i>Statistiques par Département</h6>
            </div>
            <div class="card-body">
                <?php if (!empty($stats_departement)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Département</th>
                                    <th class="text-center">Utilisateurs</th>
                                    <th class="text-center">Pronostics</th>
                                    <th class="text-center">Quiz</th>
                                    <th class="text-center">Photos</th>
                                    <th class="text-center">Engagement</th>
                                    <th class="text-center">Score Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($stats_departement as $dept): ?>
                                    <tr>
                                        <td><strong><?= htmlspecialchars($dept['departement']) ?></strong></td>
                                        <td class="text-center">
                                            <span class="badge bg-primary"><?= $dept['nb_users'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-success"><?= $dept['users_with_predictions'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-info"><?= $dept['users_with_quiz'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-warning"><?= $dept['users_with_photos'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <?php 
                                            $engagement = $dept['nb_users'] > 0 ? 
                                                round((($dept['users_with_predictions'] + $dept['users_with_quiz'] + $dept['users_with_photos']) / ($dept['nb_users'] * 3)) * 100, 1) : 0;
                                            ?>
                                            <div class="progress" style="width: 80px; height: 20px;">
                                                <div class="progress-bar bg-<?= $engagement >= 70 ? 'success' : ($engagement >= 40 ? 'warning' : 'danger') ?>" 
                                                     style="width: <?= $engagement ?>%">
                                                    <?= $engagement ?>%
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-success"><?= number_format($dept['total_score']) ?> pts</span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center">Aucune donnée disponible</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<!-- ===== STATISTIQUES PAR VILLE ===== -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card border-0 shadow-sm">
            <div class="card-header bg-info text-white">
                <h6 class="mb-0"><i class="fas fa-city me-2"></i>Statistiques par Ville</h6>
            </div>
            <div class="card-body">
                <?php if (!empty($stats_ville)): ?>
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead>
                                <tr>
                                    <th>Ville</th>
                                    <th class="text-center">Utilisateurs</th>
                                    <th class="text-center">Pronostics</th>
                                    <th class="text-center">Quiz</th>
                                    <th class="text-center">Photos</th>
                                    <th class="text-center">Engagement</th>
                                    <th class="text-center">Score Total</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach ($stats_ville as $ville): ?>
                                    <tr>
                                        <td><strong><?= htmlspecialchars($ville['ville']) ?></strong></td>
                                        <td class="text-center">
                                            <span class="badge bg-primary"><?= $ville['nb_users'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-success"><?= $ville['users_with_predictions'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-info"><?= $ville['users_with_quiz'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-warning"><?= $ville['users_with_photos'] ?></span>
                                        </td>
                                        <td class="text-center">
                                            <?php 
                                            $engagement = $ville['nb_users'] > 0 ? 
                                                round((($ville['users_with_predictions'] + $ville['users_with_quiz'] + $ville['users_with_photos']) / ($ville['nb_users'] * 3)) * 100, 1) : 0;
                                            ?>
                                            <div class="progress" style="width: 80px; height: 20px;">
                                                <div class="progress-bar bg-<?= $engagement >= 70 ? 'success' : ($engagement >= 40 ? 'warning' : 'danger') ?>" 
                                                     style="width: <?= $engagement ?>%">
                                                    <?= $engagement ?>%
                                                </div>
                                            </div>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-success"><?= number_format($ville['total_score']) ?> pts</span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted text-center">Aucune donnée disponible</p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>


<div class="row mb-4">
    <div class="col-md-12 mb-4">
        <div class="card bg-light shadow-sm h-100">
            <div class="card-header">
                <h5 class="mb-0">Prochains matchs avec deadline</h5>
            </div>
            <div class="card-body">
                <?php if ($upcoming_matches): ?>
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Match</th>
                                    <th>Date du match</th>
                                    <th>Deadline pronostics</th>
                                    <th>Phase</th>
                                    <th>Statut</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($upcoming_matches as $match): 
                                    // Calculer la deadline : X heures avant le match
                                    $deadline = date('Y-m-d H:i:s', strtotime($match['match_date']) - ($match_deadline_hours * 3600));
                                    $deadline_formatted = date('d/m/Y H:i', strtotime($deadline));
                                    $match_date_formatted = date('d/m/Y H:i', strtotime($match['match_date']));
                                ?>
                                    <tr>
                                        <td><?= htmlspecialchars($match['team_1']) ?> vs <?= htmlspecialchars($match['team_2']) ?></td>
                                        <td><?= $match_date_formatted ?></td>
                                        <td><strong><?= $deadline_formatted ?></strong></td>
                                        <td><?= htmlspecialchars($match['phase']) ?></td>
                                        <td>
                                            <?php if ($match['status'] === 'completed'): ?>
                                                <span class="badge bg-secondary">Match terminé</span>
                                            <?php elseif (date('Y-m-d H:i:s') >= $deadline): ?>
                                                <span class="badge bg-danger match-status" data-deadline="<?= $deadline ?>">Pronostics fermés</span>
                                            <?php else: ?>
                                                <span class="badge bg-success match-status" data-deadline="<?= $deadline ?>">Pronostics ouverts</span>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php else: ?>
                    <p class="text-muted">Aucun match à venir.</p>
                <?php endif; ?>
            </div>
        </div>
    </div>    
</div>

<!-- Chart.js pour les graphiques -->
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
// Graphique des pronostics récents (7 derniers jours)
const recentData = <?= json_encode($recent_predictions) ?>;
const recentLabels = recentData.map(item => {
    const date = new Date(item.date);
    return date.toLocaleDateString('fr-FR', { day: '2-digit', month: '2-digit' });
});
const recentCounts = recentData.map(item => item.count);

const ctxRecent = document.getElementById('chartRecent').getContext('2d');
const chartRecent = new Chart(ctxRecent, {
    type: 'line',
    data: {
        labels: recentLabels,
        datasets: [{
            label: 'Pronostics par jour',
            data: recentCounts,
            borderColor: '#4facfe',
            backgroundColor: 'rgba(79, 172, 254, 0.1)',
            fill: true,
            tension: 0.4,
            pointBackgroundColor: '#4facfe',
            pointBorderColor: '#4facfe',
            pointRadius: 4
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        plugins: {
            legend: { 
                display: true,
                position: 'top'
            }
        },
        scales: {
            x: { 
                title: { 
                    display: true, 
                    text: 'Date',
                    color: '#666'
                },
                grid: {
                    color: 'rgba(0,0,0,0.1)'
                }
            },
            y: { 
                title: { 
                    display: true, 
                    text: 'Nombre de pronostics',
                    color: '#666'
                }, 
                beginAtZero: true,
                grid: {
                    color: 'rgba(0,0,0,0.1)'
                }
            }
        }
    }
});

// Graphique des connexions par jour
let chartLoginStats = null;

function updateLoginStats() {
    const startDate = document.getElementById('loginStartDate').value;
    const endDate = document.getElementById('loginEndDate').value;
    
    if (!startDate || !endDate) {
        alert('Veuillez sélectionner une plage de dates');
        return;
    }
    
    // Afficher un loader
    const canvas = document.getElementById('chartLoginStats');
    const ctx = canvas.getContext('2d');
    ctx.clearRect(0, 0, canvas.width, canvas.height);
    ctx.fillStyle = '#999';
    ctx.font = '16px Arial';
    ctx.textAlign = 'center';
    ctx.fillText('Chargement...', canvas.width / 2, canvas.height / 2);
    
    // Récupérer les données via AJAX
    fetch(`../ajax/get_login_stats.php?start_date=${startDate}&end_date=${endDate}`)
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                const stats = data.data || [];
                
                // Préparer les données pour le graphique
                const labels = [];
                const uniqueUsers = [];
                const totalLogins = [];
                
                // Créer un tableau de toutes les dates dans la plage
                const start = new Date(startDate + 'T00:00:00');
                const end = new Date(endDate + 'T00:00:00');
                const dateMap = {};
                
                // Initialiser toutes les dates avec 0
                for (let d = new Date(start); d <= end; d.setDate(d.getDate() + 1)) {
                    const dateStr = d.toISOString().split('T')[0];
                    dateMap[dateStr] = { unique_users: 0, total_logins: 0 };
                }
                
                // Remplir avec les données réelles
                stats.forEach(stat => {
                    if (dateMap[stat.date]) {
                        dateMap[stat.date] = {
                            unique_users: parseInt(stat.unique_users),
                            total_logins: parseInt(stat.total_logins)
                        };
                    }
                });
                
                // Calculer les totaux pour les cartes de résumé
                let totalConnexions = 0;
                
                stats.forEach(stat => {
                    totalConnexions += parseInt(stat.total_logins);
                });
                
                // Utiliser le total d'utilisateurs uniques de la réponse serveur
                const totalUniqueUsers = data.total_unique_users || 0;
                
                // Calculer le nombre de jours dans la plage
                const daysDiff = Math.ceil((end - start) / (1000 * 60 * 60 * 24)) + 1;
                const avgPerDay = daysDiff > 0 ? (totalConnexions / daysDiff).toFixed(1) : 0;
                
                // Mettre à jour les cartes de résumé
                document.getElementById('totalLoginsCount').textContent = totalConnexions;
                document.getElementById('uniqueUsersCount').textContent = totalUniqueUsers;
                document.getElementById('avgPerDay').textContent = avgPerDay;
                
                // Créer les tableaux pour le graphique
                const tableRows = [];
                Object.keys(dateMap).sort().forEach(date => {
                    const [year, month, day] = date.split('-');
                    const dateObj = new Date(year, month - 1, day);
                    const dateFormatted = dateObj.toLocaleDateString('fr-FR', { day: '2-digit', month: '2-digit', year: 'numeric' });
                    const dateShort = dateObj.toLocaleDateString('fr-FR', { day: '2-digit', month: '2-digit' });
                    
                    labels.push(dateShort);
                    uniqueUsers.push(dateMap[date].unique_users);
                    totalLogins.push(dateMap[date].total_logins);
                    
                    // Calculer la moyenne par utilisateur pour ce jour
                    const avgPerUser = dateMap[date].unique_users > 0 
                        ? (dateMap[date].total_logins / dateMap[date].unique_users).toFixed(1)
                        : '0.0';
                    
                    tableRows.push(`
                        <tr>
                            <td><strong>${dateFormatted}</strong></td>
                            <td class="text-center"><span class="badge bg-primary">${dateMap[date].total_logins}</span></td>
                            <td class="text-center"><span class="badge bg-success">${dateMap[date].unique_users}</span></td>
                            <td class="text-center"><span class="badge bg-info">${avgPerUser}</span></td>
                        </tr>
                    `);
                });
                
                // Mettre à jour le tableau
                document.getElementById('loginStatsTableBody').innerHTML = tableRows.length > 0 
                    ? tableRows.join('') 
                    : '<tr><td colspan="4" class="text-center text-muted">Aucune donnée disponible</td></tr>';
                
                // Si aucune donnée, afficher un message
                if (labels.length === 0 || (uniqueUsers.every(v => v === 0) && totalLogins.every(v => v === 0))) {
                    const ctxLogin = document.getElementById('chartLoginStats').getContext('2d');
                    ctxLogin.clearRect(0, 0, ctxLogin.canvas.width, ctxLogin.canvas.height);
                    ctxLogin.fillStyle = '#999';
                    ctxLogin.font = '16px Arial';
                    ctxLogin.textAlign = 'center';
                    ctxLogin.fillText('Aucune donnée disponible pour cette période', ctxLogin.canvas.width / 2, ctxLogin.canvas.height / 2);
                    if (chartLoginStats) {
                        chartLoginStats.destroy();
                        chartLoginStats = null;
                    }
                    return;
                }
                
                // Créer ou mettre à jour le graphique
                if (chartLoginStats) {
                    chartLoginStats.data.labels = labels;
                    chartLoginStats.data.datasets[0].data = totalLogins;
                    chartLoginStats.data.datasets[1].data = uniqueUsers;
                    chartLoginStats.update();
                } else {
                    const ctxLogin = document.getElementById('chartLoginStats').getContext('2d');
                    chartLoginStats = new Chart(ctxLogin, {
                        type: 'line',
                        data: {
                            labels: labels,
                            datasets: [{
                                label: 'Total Connexions',
                                data: totalLogins,
                                borderColor: '#4facfe',
                                backgroundColor: 'rgba(79, 172, 254, 0.1)',
                                fill: true,
                                tension: 0.4,
                                pointBackgroundColor: '#4facfe',
                                pointBorderColor: '#4facfe',
                                pointRadius: 4,
                                yAxisID: 'y'
                            }, {
                                label: 'Utilisateurs Uniques',
                                data: uniqueUsers,
                                borderColor: '#43e97b',
                                backgroundColor: 'rgba(67, 233, 123, 0.1)',
                                fill: true,
                                tension: 0.4,
                                pointBackgroundColor: '#43e97b',
                                pointBorderColor: '#43e97b',
                                pointRadius: 4,
                                yAxisID: 'y'
                            }]
                        },
                        options: {
                            responsive: true,
                            maintainAspectRatio: false,
                            plugins: {
                                legend: { 
                                    display: true,
                                    position: 'top'
                                },
                                tooltip: {
                                    mode: 'index',
                                    intersect: false
                                }
                            },
                            scales: {
                                x: { 
                                    title: { 
                                        display: true, 
                                        text: 'Date',
                                        color: '#666'
                                    },
                                    grid: {
                                        color: 'rgba(0,0,0,0.1)'
                                    }
                                },
                                y: { 
                                    type: 'linear',
                                    display: true,
                                    position: 'left',
                                    title: { 
                                        display: true, 
                                        text: 'Nombre',
                                        color: '#666'
                                    }, 
                                    beginAtZero: true,
                                    grid: {
                                        color: 'rgba(0,0,0,0.1)'
                                    }
                                }
                            }
                        }
                    });
                }
            } else {
                alert('Erreur lors du chargement des statistiques: ' + (data.message || 'Erreur inconnue'));
            }
        })
        .catch(error => {
            console.error('Error:', error);
            const ctxLogin = document.getElementById('chartLoginStats').getContext('2d');
            ctxLogin.clearRect(0, 0, ctxLogin.canvas.width, ctxLogin.canvas.height);
            ctxLogin.fillStyle = '#dc3545';
            ctxLogin.font = '14px Arial';
            ctxLogin.textAlign = 'center';
            ctxLogin.fillText('Erreur de connexion au serveur', ctxLogin.canvas.width / 2, ctxLogin.canvas.height / 2);
            if (chartLoginStats) {
                chartLoginStats.destroy();
                chartLoginStats = null;
            }
        });
}

// Charger les statistiques au chargement de la page
document.addEventListener('DOMContentLoaded', function() {
    updateLoginStats();
    
    // Mettre à jour automatiquement lors du changement de dates
    document.getElementById('loginStartDate').addEventListener('change', updateLoginStats);
    document.getElementById('loginEndDate').addEventListener('change', updateLoginStats);
});

// Graphique historique des pronostics (si disponible)
<?php if (!empty($days) && !empty($nb_preds)): ?>
const ctx = document.getElementById('chartPreds').getContext('2d');
const chartPreds = new Chart(ctx, {
    type: 'line',
    data: {
        labels: <?= json_encode($days) ?>,
        datasets: [{
            label: 'Pronostics matchs',
            data: <?= json_encode($nb_preds) ?>,
            borderColor: '#b71c1c',
            backgroundColor: 'rgba(183,28,28,0.1)',
            fill: true,
            tension: 0.3
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: false }
        },
        scales: {
            x: { title: { display: true, text: 'Jour' } },
            y: { title: { display: true, text: 'Nombre de pronostics' }, beginAtZero: true }
        }
    }
});
<?php endif; ?>
</script>
<?php include 'admin_footer.php'; ?> 