<?php
// Page pour éditer le nom en arabe d'un joueur

// Démarrer la session et vérifier les permissions AVANT d'inclure admin_header.php
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

require_once '../includes/db.php';

$id = intval($_GET['id'] ?? 0);
$return_to = $_GET['return'] ?? 'titulaires.php';

if (!$id) {
    header('Location: ' . $return_to);
    exit;
}

// Mise à jour - DOIT être fait AVANT l'inclusion de admin_header.php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nom_ar'])) {
    $nom_ar = trim($_POST['nom_ar']);
    $stmt = $mysqli->prepare('UPDATE joueurs_maroc SET nom_ar = ? WHERE id = ?');
    $stmt->bind_param('si', $nom_ar, $id);
    $stmt->execute();
    $stmt->close();
    $msg = "Nom en arabe mis à jour avec succès !";
    header('Location: ' . $return_to . '?msg=' . urlencode($msg));
    exit;
}

include 'admin_header.php';

// Récupérer le joueur
$stmt = $mysqli->prepare('SELECT id, nom, nom_ar, poste FROM joueurs_maroc WHERE id = ?');
$stmt->bind_param('i', $id);
$stmt->execute();
$result = $stmt->get_result();
$joueur = $result->fetch_assoc();
$stmt->close();

if (!$joueur) {
    header('Location: ' . $return_to);
    exit;
}
?>

<div class="container py-4">
    <h2 class="mb-4 text-center text-warning">Modifier le nom en arabe</h2>
    
    <div class="row justify-content-center">
        <div class="col-md-6">
            <div class="card bg-dark text-white">
                <div class="card-body">
                    <h5 class="card-title"><?= htmlspecialchars($joueur['nom']) ?></h5>
                    <p class="card-text">Poste : <?= htmlspecialchars($joueur['poste']) ?></p>
                    
                    <form method="post">
                        <div class="mb-3">
                            <label class="form-label">Nom en arabe</label>
                            <input type="text" name="nom_ar" class="form-control" 
                                   value="<?= htmlspecialchars($joueur['nom_ar'] ?? '') ?>" 
                                   placeholder="أدخل الاسم بالعربية" dir="rtl">
                        </div>
                        <div class="d-flex gap-2">
                            <button type="submit" class="btn btn-success">Enregistrer</button>
                            <a href="<?= htmlspecialchars($return_to) ?>" class="btn btn-secondary">Annuler</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'admin_footer.php'; ?>

