<?php include 'admin_header.php'; ?>
<?php
require '../includes/db.php';
$groupes = [
    'A' => ['MAR' => 'Maroc', 'MAL' => 'Mali', 'ZAM' => 'Zambie', 'COM' => 'Comores'],
    'B' => ['EGY' => 'Égypte', 'RSA' => 'Afrique du Sud', 'ANG' => 'Angola', 'ZIM' => 'Zimbabwe'],
    'C' => ['NGA' => 'Nigeria', 'TUN' => 'Tunisie', 'UGA' => 'Ouganda', 'TAN' => 'Tanzanie'],
    'D' => ['SEN' => 'Sénégal', 'COD' => 'RD Congo', 'BEN' => 'Bénin', 'BOT' => 'Botswana'],
    'E' => ['ALG' => 'Algérie', 'BFA' => 'Burkina Faso', 'EQG' => 'Guinée Équatoriale', 'SUD' => 'Soudan'],
    'F' => ['CIV' => "Côte d'Ivoire", 'CMR' => 'Cameroun', 'GAB' => 'Gabon', 'MOZ' => 'Mozambique'],
];
$flags = [
    'MAR' => 'ma', 'MAL' => 'ml', 'ZAM' => 'zm', 'COM' => 'km',
    'EGY' => 'eg', 'RSA' => 'za', 'ANG' => 'ao', 'ZIM' => 'zw',
    'NGA' => 'ng', 'TUN' => 'tn', 'UGA' => 'ug', 'TAN' => 'tz',
    'SEN' => 'sn', 'COD' => 'cd', 'BEN' => 'bj', 'BOT' => 'bw',
    'ALG' => 'dz', 'BFA' => 'bf', 'EQG' => 'gq', 'SUD' => 'sd',
    'CIV' => 'ci', 'CMR' => 'cm', 'GAB' => 'ga', 'MOZ' => 'mz'
];
$message = '';

// Récupérer les classements déjà enregistrés pour chaque groupe
$classements_existants = [];
$result = $mysqli->query("SELECT groupe, classement, is_final FROM groupe_results");
while ($row = $result->fetch_assoc()) {
    $classements_existants[$row['groupe']] = [
        'ordre' => explode(',', $row['classement']),
        'is_final' => $row['is_final']
    ];
}
$result->close();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // On détecte le groupe soumis (un seul à la fois)
    foreach ($groupes as $groupe => $equipes) {
        if (isset($_POST["classement_$groupe"])) {
            $action = $_POST['action'] ?? 'validate';
            $classement = explode(',', $_POST["classement_$groupe"]);
            $classement_str = implode(',', $classement);
            
            if ($action === 'validate') {
                // Enregistrer ou mettre à jour le classement (toujours final)
                $stmt = $mysqli->prepare("INSERT INTO groupe_results (groupe, classement, is_final) VALUES (?, ?, 1) ON DUPLICATE KEY UPDATE classement = VALUES(classement), is_final = 1, created_at = NOW()");
                $stmt->bind_param('ss', $groupe, $classement_str);
                $stmt->execute();
                $stmt->close();
                
                $message = "<div style='color:green'>Classement du groupe $groupe validé avec succès !</div>";
            } elseif ($action === 'delete') {
                // Supprimer le classement
                $stmt = $mysqli->prepare("DELETE FROM groupe_results WHERE groupe = ?");
                $stmt->bind_param('s', $groupe);
                $stmt->execute();
                $stmt->close();
                
                $message = "<div style='color:orange'>Classement du groupe $groupe supprimé avec succès.</div>";
            }
            // Calcul des points si validation
            if ($action === 'validate') {
                $points_groupe = file_exists('../includes/points_groupe.txt') ? intval(trim(file_get_contents('../includes/points_groupe.txt'))) : 5;
                $stmt2 = $mysqli->prepare("SELECT user_id, classement FROM groupe_predictions WHERE groupe = ?");
                $stmt2->bind_param('s', $groupe);
                $stmt2->execute();
                $result2 = $stmt2->get_result();
                $resultat = $classement;
                while ($row = $result2->fetch_assoc()) {
                    $pronostic = explode(',', $row['classement']);
                    $points = 0;
                    foreach ($resultat as $i => $code) {
                        if (isset($pronostic[$i]) && $pronostic[$i] === $code) $points += $points_groupe;
                    }
                    $stmt3 = $mysqli->prepare("INSERT INTO groupe_points (user_id, groupe, points) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE points = VALUES(points)");
                    $stmt3->bind_param('isi', $row['user_id'], $groupe, $points);
                    $stmt3->execute();
                    $stmt3->close();
                }
                $stmt2->close();
            }
            $message = "<div style='color:green'>Résultat du groupe $groupe enregistré et points calculés !</div>";
            // On recharge les classements existants pour affichage à jour
        }
    }
}
$mysqli->query("CREATE TABLE IF NOT EXISTS groupe_points (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    groupe CHAR(1) NOT NULL,
    points INT DEFAULT 0,
    UNIQUE KEY (user_id, groupe)
)");
?>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<style>
.list-group-item {
  background: #fff;
  color: #333;
  font-weight: 500;
  border: 1px solid #e0e0e0;
  margin-bottom: 6px;
  cursor: grab;
}
.list-group-item img {
  width: 28px;
  margin-right: 8px;
  border-radius: 3px;
}
.group-card {
  background: #fff;
  border: 1.5px solid #e0e0e0;
  border-radius: 12px;
  box-shadow: 0 2px 8px rgba(0,0,0,0.04);
  padding: 22px 16px 16px 16px;
  margin-bottom: 28px;
}
.save-btn {
  width: 100%;
  font-size: 1.05rem;
  padding: 9px 0;
  margin-top: 16px;
}
.btn-sm {
  font-size: 0.875rem;
  padding: 0.375rem 0.75rem;
}
.gap-2 {
  gap: 0.5rem !important;
}
.classement-status {
  text-align: center;
}
.badge {
  font-size: 0.875rem;
  padding: 0.5rem 0.75rem;
}
</style>
<div class="container py-4">
  <h2 class="mb-4 text-center" style="font-weight:bold;">Saisie des classements réels des groupes</h2>
  <?= $message ?>
  <div class="row justify-content-center">
    <?php foreach ($groupes as $groupe => $equipes):
      $ordre = $classements_existants[$groupe]['ordre'] ?? array_keys($equipes);
      $is_final = $classements_existants[$groupe]['is_final'] ?? 0;
    ?>
      <div class="col-md-5 col-lg-4">
        <div class="group-card">
          <form method="post" id="adminGroupForm<?= $groupe ?>">
            <h4 class="mb-3" style="font-weight:700;letter-spacing:1px;">Groupe <?= $groupe ?></h4>
            <ul class="list-group sortable-group-admin mb-3" id="adminGroup<?= $groupe ?>">
              <?php 
                $pos = 1;
                foreach ($ordre as $code): ?>
                <li class="list-group-item d-flex align-items-center" data-team="<?= $code ?>">
                  <span class="badge bg-secondary me-2 position-badge" style="min-width:28px;"><?= $pos ?></span>
                  <img src="https://flagcdn.com/24x18/<?= $flags[$code] ?>.png" alt="" style="margin-right:8px;">
                  <?= $equipes[$code] ?>
                </li>
              <?php $pos++; endforeach; ?>
            </ul>
            <input type="hidden" name="classement_<?= $groupe ?>" id="inputClassement<?= $groupe ?>">
            <!-- Indicateur de statut du classement -->
            <div class="classement-status mt-2 mb-2">
              <?php if ($is_final): ?>
                <span class="badge bg-success">
                  <i class="fas fa-check-circle"></i> Classement sauvegardé
                </span>
              <?php else: ?>
                <span class="badge bg-secondary">
                  <i class="fas fa-clock"></i> En attente
                </span>
              <?php endif; ?>
            </div>
            
            <!-- Boutons d'action -->
            <div class="d-flex gap-2 mt-3">
              <button type="button" class="btn btn-success btn-sm" onclick="confirmValidation('<?= $groupe ?>')">
                <i class="fas fa-check"></i> Valider
              </button>
              <button type="button" class="btn btn-danger btn-sm" id="deleteBtn<?= $groupe ?>" onclick="deleteGroupResult('<?= $groupe ?>')" style="display:<?= $is_final ? 'inline-block' : 'none' ?>;">
                <i class="fas fa-trash"></i> Supprimer
              </button>
            </div>
          </form>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/jqueryui-touch-punch/0.2.3/jquery.ui.touch-punch.min.js"></script>
<script>
$(function() {
  <?php foreach ($groupes as $groupe => $equipes): ?>
    function updateBadges<?= $groupe ?>() {
      $("#adminGroup<?= $groupe ?>").children('li').each(function(i) {
        $(this).find('.position-badge').text(i+1);
      });
    }
    $("#adminGroup<?= $groupe ?>").sortable({
      placeholder: "ui-state-highlight",
      update: updateBadges<?= $groupe ?>
    });
    updateBadges<?= $groupe ?>();
    $("#adminGroupForm<?= $groupe ?> .final-checkbox").on('change', function() {
      var btn = $("#adminGroupForm<?= $groupe ?> .save-btn");
      if ($(this).is(':checked')) {
        btn.show();
      } else {
        btn.hide();
      }
    });
  <?php endforeach; ?>
  

  // Fonction pour confirmer la validation
  window.confirmValidation = function(groupe) {
    Swal.fire({
      title: 'Confirmer la validation',
      text: `Êtes-vous sûr de vouloir valider le classement du groupe ${groupe} ?`,
      icon: 'question',
      showCancelButton: true,
      confirmButtonColor: '#28a745',
      cancelButtonColor: '#6c757d',
      confirmButtonText: 'Oui, valider',
      cancelButtonText: 'Annuler'
    }).then((result) => {
      if (result.isConfirmed) {
        // Mettre à jour l'ordre des équipes
        var ordre = [];
        $("#adminGroup" + groupe + " li").each(function() {
          ordre.push($(this).data("team"));
        });
        $("#inputClassement" + groupe).val(ordre.join(","));
        
        // Créer un formulaire temporaire pour la validation
        const form = document.createElement('form');
        form.method = 'POST';
        form.style.display = 'none';
        
        const classementInput = document.createElement('input');
        classementInput.type = 'hidden';
        classementInput.name = `classement_${groupe}`;
        classementInput.value = ordre.join(",");
        
        const actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'action';
        actionInput.value = 'validate';
        
        form.appendChild(classementInput);
        form.appendChild(actionInput);
        document.body.appendChild(form);
        
        // Afficher un indicateur de chargement
        Swal.fire({
          title: 'Traitement en cours...',
          text: 'Validation du classement',
          icon: 'info',
          allowOutsideClick: false,
          showConfirmButton: false,
          didOpen: () => {
            Swal.showLoading();
          }
        });
        
        // Envoyer via AJAX et mettre à jour l'interface
        fetch(window.location.href, {
          method: 'POST',
          body: new FormData(form)
        })
        .then(response => response.text())
        .then(html => {
          // Extraire les nouvelles données de la réponse
          const parser = new DOMParser();
          const doc = parser.parseFromString(html, 'text/html');
          
          // Mettre à jour le statut du groupe
          const newStatusDiv = doc.querySelector(`#adminGroupForm${groupe} .classement-status`);
          if (newStatusDiv) {
            document.querySelector(`#adminGroupForm${groupe} .classement-status`).innerHTML = newStatusDiv.innerHTML;
          }
          
          // Mettre à jour la visibilité du bouton supprimer
          const newDeleteBtn = doc.getElementById(`deleteBtn${groupe}`);
          const currentDeleteBtn = document.getElementById(`deleteBtn${groupe}`);
          if (newDeleteBtn && currentDeleteBtn) {
            currentDeleteBtn.style.display = newDeleteBtn.style.display;
          }
          
          // Afficher le message de succès
          Swal.fire({
            title: 'Succès !',
            text: 'Classement validé avec succès',
            icon: 'success',
            timer: 1000,
            showConfirmButton: false
          }).then(() => {
            // Recharger la page après 1 seconde
            setTimeout(() => {
              window.location.reload();
            }, 1000);
          });
        })
        .catch(error => {
          console.error('Erreur:', error);
          Swal.fire({
            title: 'Erreur !',
            text: 'Une erreur est survenue',
            icon: 'error'
          });
        });
        
        // Nettoyer le formulaire temporaire
        document.body.removeChild(form);
      }
    });
  };

  // Fonction pour supprimer un classement de groupe
  window.deleteGroupResult = function(groupe) {
    Swal.fire({
      title: 'Confirmer la suppression',
      text: `Êtes-vous sûr de vouloir supprimer le classement final du groupe ${groupe} ?`,
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#d33',
      cancelButtonColor: '#3085d6',
      confirmButtonText: 'Oui, supprimer',
      cancelButtonText: 'Annuler'
    }).then((result) => {
      if (result.isConfirmed) {
        // Créer un formulaire temporaire pour la suppression
        const form = document.createElement('form');
        form.method = 'POST';
        form.style.display = 'none';
        
        const classementInput = document.createElement('input');
        classementInput.type = 'hidden';
        classementInput.name = `classement_${groupe}`;
        classementInput.value = document.getElementById(`inputClassement${groupe}`).value;
        
        const actionInput = document.createElement('input');
        actionInput.type = 'hidden';
        actionInput.name = 'action';
        actionInput.value = 'delete';
        
        form.appendChild(classementInput);
        form.appendChild(actionInput);
        document.body.appendChild(form);
        
        // Afficher un indicateur de chargement
        Swal.fire({
          title: 'Traitement en cours...',
          text: 'Suppression du classement',
          icon: 'info',
          allowOutsideClick: false,
          showConfirmButton: false,
          didOpen: () => {
            Swal.showLoading();
          }
        });
        
        // Envoyer via AJAX et mettre à jour l'interface
        fetch(window.location.href, {
          method: 'POST',
          body: new FormData(form)
        })
        .then(response => response.text())
        .then(html => {
          // Extraire les nouvelles données de la réponse
          const parser = new DOMParser();
          const doc = parser.parseFromString(html, 'text/html');
          
          // Mettre à jour le statut du groupe
          const newStatusDiv = doc.querySelector(`#adminGroupForm${groupe} .classement-status`);
          if (newStatusDiv) {
            document.querySelector(`#adminGroupForm${groupe} .classement-status`).innerHTML = newStatusDiv.innerHTML;
          }
          
          // Mettre à jour la visibilité du bouton supprimer
          const newDeleteBtn = doc.getElementById(`deleteBtn${groupe}`);
          const currentDeleteBtn = document.getElementById(`deleteBtn${groupe}`);
          if (newDeleteBtn && currentDeleteBtn) {
            currentDeleteBtn.style.display = newDeleteBtn.style.display;
          }
          
          // Afficher le message de succès
          Swal.fire({
            title: 'Supprimé !',
            text: 'Classement supprimé avec succès',
            icon: 'success',
            timer: 1000,
            showConfirmButton: false
          }).then(() => {
            // Recharger la page après 1 seconde
            setTimeout(() => {
              window.location.reload();
            }, 1000);
          });
        })
        .catch(error => {
          console.error('Erreur:', error);
          Swal.fire({
            title: 'Erreur !',
            text: 'Une erreur est survenue',
            icon: 'error'
          });
        });
        
        // Nettoyer le formulaire temporaire
        document.body.removeChild(form);
      }
    });
  };

});
</script>
<?php include 'admin_footer.php'; ?> 