<?php include 'admin_header.php'; ?>
<?php
require '../includes/db.php';
// Liste officielle des phases
$phases_officielles = [
    "Phase de groupes · Journée 1 sur 3",
    "Phase de groupes · Journée 2 sur 3",
    "Phase de groupes · Journée 3 sur 3",
    "8e de finale",
    "Quart de finale",
    "Demi-finale",
    "Match pour la 3e place",
    "Finale"
];
// Liste des équipes CAN 2025
$equipes = [
    'MAR' => 'Maroc', 'MAL' => 'Mali', 'ZAM' => 'Zambie', 'COM' => 'Comores',
    'EGY' => 'Égypte', 'RSA' => 'Afrique du Sud', 'ANG' => 'Angola', 'ZIM' => 'Zimbabwe',
    'NGA' => 'Nigeria', 'TUN' => 'Tunisie', 'UGA' => 'Ouganda', 'TAN' => 'Tanzanie',
    'SEN' => 'Sénégal', 'COD' => 'RD Congo', 'BEN' => 'Bénin', 'BOT' => 'Botswana',
    'ALG' => 'Algérie', 'BFA' => 'Burkina Faso', 'EQG' => 'Guinée Équatoriale', 'SUD' => 'Soudan',
    'CIV' => "Côte d'Ivoire", 'CMR' => 'Cameroun', 'GAB' => 'Gabon', 'MOZ' => 'Mozambique'
];
// Récupérer toutes les phases distinctes en base
$phases_db = [];
$result = $mysqli->query('SELECT DISTINCT phase FROM Matches ORDER BY match_date ASC');
while($row = $result->fetch_assoc()) {
    $phases_db[] = $row['phase'];
}
$result->close();
// Fusionner sans doublons
$phases = array_unique(array_merge($phases_officielles, $phases_db));
?>
<ul class="nav nav-tabs mb-4" id="adminTabs" role="tablist">
  <li class="nav-item" role="presentation">
    <button class="nav-link active" id="list-tab" data-bs-toggle="tab" data-bs-target="#list" type="button" role="tab">Liste des matchs</button>
  </li>
  <li class="nav-item" role="presentation">
    <button class="nav-link" id="add-tab" data-bs-toggle="tab" data-bs-target="#add" type="button" role="tab">Ajouter un match</button>
  </li>
</ul>
<div class="tab-content" id="adminTabsContent">
<div class="tab-pane fade show active" id="list" role="tabpanel">
    <div id="matchesList"></div>
  </div>

  <div class="tab-pane fade " id="add" role="tabpanel">
    <div class="card p-4 mb-4">
      <div class="card-header bg-primary text-white">
        <h4 class="mb-0"><i class="fas fa-plus-circle me-2"></i>Ajouter un nouveau match</h4>
      </div>
      <div class="card-body">
        <form id="addMatchForm">
          <div class="row g-4">
            <!-- Section Équipes -->
            <div class="col-12">
              <h5 class="text-primary mb-3"><i class="fas fa-users me-2"></i>Équipes</h5>
            </div>
            
            <div class="col-md-6">
              <label for="team_1" class="form-label fw-bold">Équipe 1</label>
              <select class="form-select select2-with-flag" name="team_1" id="team_1" required>
                <option value="">-- Sélectionner l'équipe 1 --</option>
                <?php 
                $flags = [
                    'Maroc' => 'ma', 'Mali' => 'ml', 'Zambie' => 'zm', 'Comores' => 'km',
                    'Égypte' => 'eg', 'Afrique du Sud' => 'za', 'Angola' => 'ao', 'Zimbabwe' => 'zw',
                    'Nigeria' => 'ng', 'Tunisie' => 'tn', 'Ouganda' => 'ug', 'Tanzanie' => 'tz',
                    'Sénégal' => 'sn', 'RD Congo' => 'cd', 'Bénin' => 'bj', 'Botswana' => 'bw',
                    'Algérie' => 'dz', 'Burkina Faso' => 'bf', 'Guinée Équatoriale' => 'gq', 'Soudan' => 'sd',
                    "Côte d'Ivoire" => 'ci', 'Cameroun' => 'cm', 'Gabon' => 'ga', 'Mozambique' => 'mz'
                ];
                foreach($equipes as $code => $nom): 
                  $flag = $flags[$nom] ?? 'un';
                ?>
                  <option value="<?= htmlspecialchars($nom) ?>" data-flag="<?= $flag ?>">
                    <?= htmlspecialchars($nom) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            
            <div class="col-md-6">
              <label for="team_2" class="form-label fw-bold">Équipe 2</label>
              <select class="form-select select2-with-flag" name="team_2" id="team_2" required>
                <option value="">-- Sélectionner l'équipe 2 --</option>
                <?php foreach($equipes as $code => $nom): 
                  $flag = $flags[$nom] ?? 'un';
                ?>
                  <option value="<?= htmlspecialchars($nom) ?>" data-flag="<?= $flag ?>">
                    <?= htmlspecialchars($nom) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            
            <!-- Section Détails du match -->
            <div class="col-12">
              <hr class="my-4">
              <h5 class="text-primary mb-3"><i class="fas fa-calendar-alt me-2"></i>Détails du match</h5>
            </div>
            
            <div class="col-md-6">
              <label for="match_date" class="form-label fw-bold">Date et heure du match</label>
              <input type="datetime-local" class="form-control" name="match_date" id="match_date" required>
              <div class="form-text">Sélectionnez la date et l'heure du match</div>
            </div>
            
            <div class="col-md-6">
              <label for="phase" class="form-label fw-bold">Phase de la compétition</label>
              <select class="form-select" name="phase" id="phase" required>
                <option value="">-- Sélectionner la phase --</option>
                <option value="Phase de groupes · Journée 1 sur 3">Phase de groupes · Journée 1 sur 3</option>
                <option value="Phase de groupes · Journée 2 sur 3">Phase de groupes · Journée 2 sur 3</option>
                <option value="Phase de groupes · Journée 3 sur 3">Phase de groupes · Journée 3 sur 3</option>
                <option value="8e de finale">8e de finale</option>
                <option value="Quart de finale">Quart de finale</option>
                <option value="Demi-finale">Demi-finale</option>
                <option value="Match pour la 3e place">Match pour la 3e place</option>
                <option value="Finale">Finale</option>
              </select>
              <div class="form-text">Choisissez la phase de la compétition</div>
            </div>
          </div>
          
          <!-- Boutons d'action -->
          <div class="row mt-4">
            <div class="col-12">
              <div class="d-flex gap-3 justify-content-end">
                <button type="reset" class="btn btn-outline-secondary">
                  <i class="fas fa-undo me-2"></i>Réinitialiser
                </button>
                <button type="submit" class="btn btn-primary btn-lg">
                  <i class="fas fa-plus me-2"></i>Ajouter le match
                </button>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
  
</div>

<!-- Modal de modification de match -->
<div class="modal fade" id="editMatchModal" tabindex="-1" aria-labelledby="editMatchModalLabel" aria-hidden="true" data-bs-backdrop="false">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header bg-warning text-dark">
        <h5 class="modal-title" id="editMatchModalLabel"><i class="fas fa-edit me-2"></i>Modifier le match</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form id="editMatchForm">
          <input type="hidden" name="match_id" id="edit_match_id">
          <div class="row g-4">
            <!-- Section Équipes -->
            <div class="col-12">
              <h5 class="text-primary mb-3"><i class="fas fa-users me-2"></i>Équipes</h5>
            </div>
            
            <div class="col-md-6">
              <label for="edit_team_1" class="form-label fw-bold">Équipe 1</label>
              <select class="form-select select2-with-flag-edit" name="team_1" id="edit_team_1" required>
                <option value="">-- Sélectionner l'équipe 1 --</option>
                <?php 
                $flags = [
                    'Maroc' => 'ma', 'Mali' => 'ml', 'Zambie' => 'zm', 'Comores' => 'km',
                    'Égypte' => 'eg', 'Afrique du Sud' => 'za', 'Angola' => 'ao', 'Zimbabwe' => 'zw',
                    'Nigeria' => 'ng', 'Tunisie' => 'tn', 'Ouganda' => 'ug', 'Tanzanie' => 'tz',
                    'Sénégal' => 'sn', 'RD Congo' => 'cd', 'Bénin' => 'bj', 'Botswana' => 'bw',
                    'Algérie' => 'dz', 'Burkina Faso' => 'bf', 'Guinée Équatoriale' => 'gq', 'Soudan' => 'sd',
                    "Côte d'Ivoire" => 'ci', 'Cameroun' => 'cm', 'Gabon' => 'ga', 'Mozambique' => 'mz'
                ];
                foreach($equipes as $code => $nom): 
                  $flag = $flags[$nom] ?? 'un';
                ?>
                  <option value="<?= htmlspecialchars($nom) ?>" data-flag="<?= $flag ?>">
                    <?= htmlspecialchars($nom) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            
            <div class="col-md-6">
              <label for="edit_team_2" class="form-label fw-bold">Équipe 2</label>
              <select class="form-select select2-with-flag-edit" name="team_2" id="edit_team_2" required>
                <option value="">-- Sélectionner l'équipe 2 --</option>
                <?php foreach($equipes as $code => $nom): 
                  $flag = $flags[$nom] ?? 'un';
                ?>
                  <option value="<?= htmlspecialchars($nom) ?>" data-flag="<?= $flag ?>">
                    <?= htmlspecialchars($nom) ?>
                  </option>
                <?php endforeach; ?>
              </select>
            </div>
            
            <!-- Section Détails du match -->
            <div class="col-12">
              <hr class="my-4">
              <h5 class="text-primary mb-3"><i class="fas fa-calendar-alt me-2"></i>Détails du match</h5>
            </div>
            
            <div class="col-md-6">
              <label for="edit_match_date" class="form-label fw-bold">Date et heure du match</label>
              <input type="datetime-local" class="form-control" name="match_date" id="edit_match_date" required>
              <div class="form-text">Sélectionnez la date et l'heure du match</div>
            </div>
            
            <div class="col-md-6">
              <label for="edit_phase" class="form-label fw-bold">Phase de la compétition</label>
              <select class="form-select" name="phase" id="edit_phase" required>
                <option value="">-- Sélectionner la phase --</option>
                <?php foreach($phases_officielles as $phase): ?>
                  <option value="<?= htmlspecialchars($phase) ?>"><?= htmlspecialchars($phase) ?></option>
                <?php endforeach; ?>
                <?php foreach($phases_db as $phase): 
                  if (!in_array($phase, $phases_officielles)): ?>
                    <option value="<?= htmlspecialchars($phase) ?>"><?= htmlspecialchars($phase) ?></option>
                  <?php endif;
                endforeach; ?>
              </select>
              <div class="form-text">Choisissez la phase de la compétition</div>
            </div>
          </div>
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
        <button type="button" class="btn btn-warning" id="saveEditMatchBtn">
          <i class="fas fa-save me-2"></i>Enregistrer les modifications
        </button>
      </div>
    </div>
  </div>
</div>

<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
const base = "..";
$(function() {
  // Configuration Select2 avec drapeaux pour le formulaire d'ajout
  $('.select2-with-flag').select2({
    width: '100%',
    dropdownParent: $('#addMatchForm'),
    templateResult: formatTeamWithFlag,
    templateSelection: formatTeamWithFlag,
    escapeMarkup: function(markup) { return markup; }
  });
  
  // Configuration Select2 avec drapeaux pour le formulaire de modification
  $('.select2-with-flag-edit').select2({
    width: '100%',
    dropdownParent: $('#editMatchModal'),
    templateResult: formatTeamWithFlag,
    templateSelection: formatTeamWithFlag,
    escapeMarkup: function(markup) { return markup; }
  });
  
  // Fonction pour formater les options avec drapeaux
  function formatTeamWithFlag(team) {
    if (!team.id) {
      return team.text;
    }
    
    var flag = $(team.element).data('flag');
    if (flag) {
      var $result = $(
        '<span><img src="https://flagcdn.com/20x15/' + flag + '.png" class="me-2" style="border-radius: 2px;">' + team.text + '</span>'
      );
      return $result;
    }
    
    return team.text;
  }
  // Ajout d'un match
  $('#addMatchForm').on('submit', function(e) {
    e.preventDefault();
    $.post(base + '/ajax/add_match.php', $(this).serialize(), function(data) {
      if(data.success) {
        Swal.fire('Succès', 'Match ajouté !', 'success');
        $('#addMatchForm')[0].reset();
        loadMatches();
      } else {
        Swal.fire('Erreur', data.message, 'error');
      }
    }, 'json');
  });
  // Chargement des matchs
  function loadMatches() {
    $.get(base + '/ajax/list_matches.php', function(data) {
      if(data.success) {
        $('#matchesList').html(data.html);
      } else {
        $('#matchesList').html('<div class="alert alert-danger">'+data.message+'</div>');
      }
    }, 'json');
  }
  // Charger la liste au changement d'onglet
  $('button[data-bs-target="#list"]').on('shown.bs.tab', function() {
    loadMatches();
  });
  // Charger la liste au chargement initial si tab actif
  if($('#list').hasClass('active')) loadMatches();
  
  // Gestion du bouton Modifier - ouverture du modal
  $(document).on('click', '.edit-match-btn', function(e) {
    e.preventDefault();
    var matchId = $(this).data('match');
    var team1 = $(this).data('team1');
    var team2 = $(this).data('team2');
    var date = $(this).data('date');
    var phase = $(this).data('phase');
    
    console.log('Modifier match:', matchId, team1, team2, date, phase); // Debug
    
    // Remplir le formulaire avec les données du match
    $('#edit_match_id').val(matchId);
    $('#edit_team_1').val(team1).trigger('change');
    $('#edit_team_2').val(team2).trigger('change');
    $('#edit_match_date').val(date);
    $('#edit_phase').val(phase);
    
    // Initialiser Select2 si pas déjà fait
    if (!$('#edit_team_1').hasClass('select2-hidden-accessible')) {
      $('#edit_team_1, #edit_team_2').select2({
        width: '100%',
        dropdownParent: $('#editMatchModal'),
        templateResult: formatTeamWithFlag,
        templateSelection: formatTeamWithFlag,
        escapeMarkup: function(markup) { return markup; }
      });
    }
    
    // Ouvrir le modal sans backdrop
    var modalElement = document.getElementById('editMatchModal');
    if (modalElement) {
      var modal = bootstrap.Modal.getOrCreateInstance(modalElement, {
        backdrop: false
      });
      modal.show();
    } else {
      console.error('Modal editMatchModal non trouvé');
    }
  });
  
  // Soumission du formulaire de modification
  $('#saveEditMatchBtn').on('click', function(e) {
    e.preventDefault();
    var formData = $('#editMatchForm').serialize();
    console.log('Données envoyées:', formData); // Debug
    
    $.post(base + '/ajax/update_match.php', formData, function(data) {
      console.log('Réponse serveur:', data); // Debug
      if(data.success) {
        Swal.fire('Succès', 'Match modifié avec succès !', 'success');
        var modalElement = document.getElementById('editMatchModal');
        if (modalElement) {
          var modal = bootstrap.Modal.getInstance(modalElement);
          if (modal) modal.hide();
        }
        loadMatches();
      } else {
        Swal.fire('Erreur', data.message || 'Erreur lors de la modification', 'error');
      }
    }, 'json').fail(function(xhr, status, error) {
      console.error('Erreur AJAX:', status, error, xhr.responseText);
      Swal.fire('Erreur', 'Une erreur est survenue lors de la modification.', 'error');
    });
  });
});
</script>
<?php include 'admin_footer.php'; ?> 