<?php
// Script de migration pour ajouter le champ approved à la table mur_messages
// À exécuter une seule fois depuis l'admin

if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

require '../includes/db.php';

$message = '';
$error = '';

// Vérifier si la colonne existe déjà
$check = $mysqli->query("
    SELECT COUNT(*) as count 
    FROM INFORMATION_SCHEMA.COLUMNS 
    WHERE TABLE_SCHEMA = DATABASE() 
    AND TABLE_NAME = 'mur_messages' 
    AND COLUMN_NAME = 'approved'
");
$exists = $check->fetch_assoc()['count'] > 0;

if (!$exists) {
    // Ajouter la colonne
    if ($mysqli->query("ALTER TABLE mur_messages ADD COLUMN approved TINYINT(1) DEFAULT 1 AFTER image_path")) {
        // Mettre tous les messages existants comme approuvés
        $mysqli->query("UPDATE mur_messages SET approved = 1 WHERE approved IS NULL");
        $message = "Migration réussie ! Le champ 'approved' a été ajouté à la table mur_messages.";
    } else {
        $error = "Erreur lors de la migration : " . $mysqli->error;
    }
} else {
    $message = "Le champ 'approved' existe déjà dans la table mur_messages.";
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Migration - Modération messages</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.1.3/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-dark text-white">
    <div class="container mt-5">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card bg-secondary">
                    <div class="card-header">
                        <h4>Migration - Modération messages</h4>
                    </div>
                    <div class="card-body">
                        <?php if ($message): ?>
                            <div class="alert alert-success"><?= htmlspecialchars($message) ?></div>
                        <?php endif; ?>
                        <?php if ($error): ?>
                            <div class="alert alert-danger"><?= htmlspecialchars($error) ?></div>
                        <?php endif; ?>
                        <a href="mur_messages.php" class="btn btn-primary">Aller à la modération des messages</a>
                        <a href="dashboard.php" class="btn btn-secondary">Retour au dashboard</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</body>
</html>

