<?php
// Démarrer la session et vérifier les permissions AVANT d'inclure admin_header.php
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['role']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'stat')) {
    header('Location: ../index.php');
    exit;
}

require_once '../includes/db.php';

// Traitement des actions (activer/désactiver) - DOIT être fait AVANT l'inclusion de admin_header.php
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'], $_POST['message_id'])) {
    $message_id = (int)$_POST['message_id'];
    $action = $_POST['action'];
    
    if ($action === 'activate') {
        $stmt = $mysqli->prepare('UPDATE mur_messages SET approved = 1 WHERE id = ?');
        $stmt->bind_param('i', $message_id);
        $stmt->execute();
        $stmt->close();
        $msg = "Message activé avec succès !";
    } elseif ($action === 'deactivate') {
        $stmt = $mysqli->prepare('UPDATE mur_messages SET approved = 0 WHERE id = ?');
        $stmt->bind_param('i', $message_id);
        $stmt->execute();
        $stmt->close();
        $msg = "Message désactivé avec succès !";
    }
    
    if (isset($msg)) {
        header('Location: mur_messages.php?msg=' . urlencode($msg));
        exit;
    }
}

include 'admin_header.php';

$msg = $_GET['msg'] ?? '';

// Récupérer tous les messages
$all_messages = [];
$res = $mysqli->query("
    SELECT m.*, u.username, u.email,
        (SELECT COUNT(*) FROM mur_likes l WHERE l.message_id = m.id) as likes
    FROM mur_messages m
    LEFT JOIN Users u ON m.user_id = u.id
    ORDER BY m.created_at DESC
");
while ($row = $res->fetch_assoc()) {
    $all_messages[] = $row;
}

// Compter les messages actifs et inactifs
$active_count = 0;
$inactive_count = 0;
foreach ($all_messages as $m) {
    if ($m['approved'] == 1) {
        $active_count++;
    } else {
        $inactive_count++;
    }
}
?>

<style>
    .message-card {
        background: #f8f9fa;
        border: 1px solid #dee2e6;
        border-radius: 8px;
        padding: 15px;
        margin-bottom: 15px;
    }
    .message-card.active {
        border-left: 4px solid #28a745;
    }
    .message-card.inactive {
        border-left: 4px solid #ffc107;
        background: #fff3cd;
    }
    .message-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }
    .message-author {
        font-weight: bold;
        color: #495057;
    }
    .message-date {
        color: #6c757d;
        font-size: 0.9em;
    }
    .message-content {
        margin: 10px 0;
        color: #212529;
    }
    .message-image {
        max-width: 300px;
        max-height: 300px;
        border-radius: 8px;
        margin-top: 10px;
    }
    .status-badge {
        padding: 4px 12px;
        border-radius: 12px;
        font-size: 0.85em;
        font-weight: bold;
    }
    .status-active {
        background-color: #28a745;
        color: white;
    }
    .status-inactive {
        background-color: #ffc107;
        color: #212529;
    }
    .btn-activate {
        background-color: #28a745;
        color: white;
        border: none;
    }
    .btn-deactivate {
        background-color: #ffc107;
        color: #212529;
        border: none;
    }
    .btn-activate:hover {
        background-color: #218838;
        color: white;
    }
    .btn-deactivate:hover {
        background-color: #e0a800;
        color: #212529;
    }
</style>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0 text-white"><i class="fas fa-comments me-2"></i>Gestion murs de message</h2>
    <div>
        <span class="badge bg-success me-2">Actifs : <?= $active_count ?></span>
        <span class="badge bg-warning">Inactifs : <?= $inactive_count ?></span>
    </div>
</div>

<?php if ($msg): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert" id="successAlert">
        <?= htmlspecialchars($msg) ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Liste de tous les messages en cartes -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-primary text-white">
        <h5 class="mb-0">
            <i class="fas fa-list me-2"></i>Liste des messages
            <span class="badge bg-light text-dark ms-2"><?= count($all_messages) ?></span>
        </h5>
    </div>
    <div class="card-body">
        <?php if (empty($all_messages)): ?>
            <p class="text-muted mb-0">Aucun message.</p>
        <?php else: ?>
            <div class="row g-3">
                <?php foreach ($all_messages as $msg): ?>
                    <div class="col-12">
                        <div class="card h-100 <?= $msg['approved'] == 1 ? 'border-success' : 'border-warning' ?>" style="border-width: 2px;">
                            <div class="card-header d-flex justify-content-between align-items-center <?= $msg['approved'] == 1 ? 'bg-success bg-opacity-10' : 'bg-warning bg-opacity-10' ?>">
                                <div>
                                    <strong class="text-black"><?= htmlspecialchars($msg['username'] ?? 'Utilisateur inconnu') ?></strong>
                                    <br>
                                    <small class="text-black"><?= htmlspecialchars($msg['email'] ?? '') ?></small>
                                </div>
                                <span class="status-badge <?= $msg['approved'] == 1 ? 'status-active' : 'status-inactive' ?>">
                                    <?= $msg['approved'] == 1 ? 'Actif' : 'Inactif' ?>
                                </span>
                            </div>
                            <div class="card-body" style="color: black;">
                                <p class="card-text" style="min-height: 60px; color: black;">
                                    <?= nl2br(htmlspecialchars($msg['message'])) ?>
                                </p>
                                <?php if ($msg['image_path']): ?>
                                    <div class="mb-2">
                                        <button type="button" class="btn btn-sm btn-info" 
                                                onclick="showImageModal('../<?= htmlspecialchars($msg['image_path']) ?>')">
                                            <i class="fas fa-image me-1"></i>Voir l'image
                                        </button>
                                    </div>
                                <?php endif; ?>
                                <small class="text-black">
                                    <i class="fas fa-calendar me-1"></i><?= htmlspecialchars($msg['created_at']) ?>
                                </small>
                            </div>
                            <div class="card-footer bg-transparent">
                                <div class="d-flex justify-content-end">
                                    <?php if ($msg['approved'] == 1): ?>
                                        <button type="button" class="btn btn-sm btn-deactivate" 
                                                data-id="<?= $msg['id'] ?>"
                                                data-username="<?= htmlspecialchars($msg['username'] ?? 'Utilisateur inconnu', ENT_QUOTES) ?>"
                                                data-action="deactivate">
                                            <i class="fas fa-ban me-1"></i>Désactiver
                                        </button>
                                    <?php else: ?>
                                        <button type="button" class="btn btn-sm btn-activate" 
                                                data-id="<?= $msg['id'] ?>"
                                                data-username="<?= htmlspecialchars($msg['username'] ?? 'Utilisateur inconnu', ENT_QUOTES) ?>"
                                                data-action="activate">
                                            <i class="fas fa-check me-1"></i>Activer
                                        </button>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Modal pour afficher l'image -->
<div class="modal fade" id="imageModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Image du message</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body text-center">
                <img id="modalImage" src="" alt="Image" class="img-fluid" style="max-height: 70vh;">
            </div>
        </div>
    </div>
</div>

<!-- Formulaires cachés pour les actions -->
<form id="actionForm" method="POST" style="display: none;">
    <input type="hidden" name="action" id="actionInput">
    <input type="hidden" name="message_id" id="messageIdInput">
</form>

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Gérer les clics sur les boutons d'activation/désactivation
    document.querySelectorAll('[data-action="activate"], [data-action="deactivate"]').forEach(function(btn) {
        btn.addEventListener('click', function() {
            const id = parseInt(this.getAttribute('data-id'));
            const username = this.getAttribute('data-username');
            const action = this.getAttribute('data-action');
            
            if (action === 'activate') {
                Swal.fire({
                    title: 'Activer le message ?',
                    html: 'Voulez-vous activer le message de <strong>' + username + '</strong> ?<br>Il sera visible sur le mur de messages.',
                    icon: 'question',
                    showCancelButton: true,
                    confirmButtonColor: '#28a745',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Oui, activer',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        submitAction('activate', id);
                    }
                });
            } else if (action === 'deactivate') {
                Swal.fire({
                    title: 'Désactiver le message ?',
                    html: 'Voulez-vous désactiver le message de <strong>' + username + '</strong> ?<br>Il ne sera plus visible sur le mur de messages.',
                    icon: 'warning',
                    showCancelButton: true,
                    confirmButtonColor: '#ffc107',
                    cancelButtonColor: '#6c757d',
                    confirmButtonText: 'Oui, désactiver',
                    cancelButtonText: 'Annuler'
                }).then((result) => {
                    if (result.isConfirmed) {
                        submitAction('deactivate', id);
                    }
                });
            }
        });
    });
});

function submitAction(action, messageId) {
    const form = document.getElementById('actionForm');
    document.getElementById('actionInput').value = action;
    document.getElementById('messageIdInput').value = messageId;
    form.submit();
}

function showImageModal(imageSrc) {
    document.getElementById('modalImage').src = imageSrc;
    const modal = new bootstrap.Modal(document.getElementById('imageModal'));
    modal.show();
}

// Afficher un message SweetAlert si un message de succès est présent dans l'URL
<?php if (isset($_GET['msg']) && !empty($_GET['msg'])): ?>
    Swal.fire({
        title: 'Succès !',
        text: <?= json_encode($_GET['msg']) ?>,
        icon: 'success',
        confirmButtonColor: '#28a745',
        timer: 3000,
        timerProgressBar: true
    });
<?php endif; ?>
</script>

<?php include 'admin_footer.php'; ?>
