<?php
session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

require_once '../includes/db.php';
require_once '../includes/language.php';

// Gestion des actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add_phase':
                $phase = trim($_POST['phase']);
                $title = trim($_POST['title']);
                $description = trim($_POST['description']);
                
                if ($phase && $title) {
                    $stmt = $mysqli->prepare("INSERT INTO photo_challenge_phases (phase, title, description) VALUES (?, ?, ?)");
                    $stmt->bind_param('sss', $phase, $title, $description);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
                
            case 'update_phase':
                $id = intval($_POST['id']);
                $phase = trim($_POST['phase']);
                $title = trim($_POST['title']);
                $description = trim($_POST['description']);
                $is_active = isset($_POST['is_active']) ? 1 : 0;
                
                if ($id && $phase && $title) {
                    $stmt = $mysqli->prepare("UPDATE photo_challenge_phases SET phase = ?, title = ?, description = ?, is_active = ? WHERE id = ?");
                    $stmt->bind_param('sssii', $phase, $title, $description, $is_active, $id);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
                
            case 'delete_phase':
                $id = intval($_POST['id']);
                if ($id) {
                    $stmt = $mysqli->prepare("DELETE FROM photo_challenge_phases WHERE id = ?");
                    $stmt->bind_param('i', $id);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
        }
    }
}

// Récupérer toutes les phases (exclure "Match pour la 3e place")
$phases = [];
$res = $mysqli->query("SELECT * FROM photo_challenge_phases WHERE phase != 'Match pour la 3e place' ORDER BY 
    CASE phase 
        WHEN 'Phase de groupes' THEN 1
        WHEN '8e de finale' THEN 2
        WHEN 'Quart de finale' THEN 3
        WHEN 'Demi-finale' THEN 4
        WHEN 'Finale' THEN 5
        ELSE 6
    END, id");
if ($res) {
    $phases = $res->fetch_all(MYSQLI_ASSOC);
    $res->close();
}

include 'admin_header.php';
?>

<div class="container-fluid py-3">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2 class="mb-0">📸 Gestion des Défis Photos</h2>
        <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPhaseModal">
            <i class="fas fa-plus me-2"></i>Nouvelle Phase
        </button>
    </div>
    
    <!-- Statistiques compactes -->
    <div class="row mb-3">
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-2">
                    <i class="fas fa-layer-group text-primary mb-1"></i>
                    <h5 class="text-primary mb-0"><?= count($phases) ?></h5>
                    <small class="text-muted">Phases configurées</small>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-2">
                    <i class="fas fa-check-circle text-success mb-1"></i>
                    <h5 class="text-success mb-0"><?= count(array_filter($phases, function($p) { return $p['is_active']; })) ?></h5>
                    <small class="text-muted">Phases actives</small>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-2">
                    <i class="fas fa-pause-circle text-warning mb-1"></i>
                    <h5 class="text-warning mb-0"><?= count(array_filter($phases, function($p) { return !$p['is_active']; })) ?></h5>
                    <small class="text-muted">Phases inactives</small>
                </div>
            </div>
        </div>
        <div class="col-lg-3 col-md-6 mb-2">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body text-center py-2">
                    <i class="fas fa-camera text-info mb-1"></i>
                    <h5 class="text-info mb-0"><?= $mysqli->query("SELECT COUNT(*) as total FROM challenge_photos")->fetch_assoc()['total'] ?? 0 ?></h5>
                    <small class="text-muted">Photos uploadées</small>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Liste des phases existantes -->
    <div class="card border-0 shadow-sm">
        <div class="card-header bg-primary text-white">
            <h6 class="mb-0"><i class="fas fa-list me-2"></i>Phases Configurées</h6>
        </div>
        <div class="card-body p-0">
            <?php if (empty($phases)): ?>
                <div class="text-center py-5">
                    <i class="fas fa-camera fa-3x text-muted mb-3"></i>
                    <h5 class="text-muted">Aucune phase configurée</h5>
                    <p class="text-muted">Commencez par ajouter une nouvelle phase de défi photo.</p>
                    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addPhaseModal">
                        <i class="fas fa-plus me-2"></i>Ajouter une phase
                    </button>
                </div>
            <?php else: ?>
                <div class="table-responsive">
                    <table class="table table-hover mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="border-0">Phase</th>
                                <th class="border-0">Titre</th>
                                <th class="border-0">Description</th>
                                <th class="border-0 text-center">Statut</th>
                                <th class="border-0 text-center">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($phases as $phase): ?>
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <i class="fas fa-<?= $phase['is_active'] ? 'play-circle text-success' : 'pause-circle text-warning' ?> me-2"></i>
                                            <strong><?= htmlspecialchars($phase['phase']) ?></strong>
                                        </div>
                                    </td>
                                    <td>
                                        <span class="fw-bold"><?= htmlspecialchars($phase['title']) ?></span>
                                    </td>
                                    <td>
                                        <span class="text-muted"><?= htmlspecialchars($phase['description']) ?: 'Aucune description' ?></span>
                                    </td>
                                    <td class="text-center">
                                        <span class="badge bg-<?= $phase['is_active'] ? 'success' : 'secondary' ?>">
                                            <i class="fas fa-<?= $phase['is_active'] ? 'check' : 'times' ?> me-1"></i>
                                            <?= $phase['is_active'] ? 'Actif' : 'Inactif' ?>
                                        </span>
                                    </td>
                                    <td class="text-center">
                                        <div class="btn-group" role="group">
                                            <button class="btn btn-sm btn-outline-primary" onclick="editPhase(<?= htmlspecialchars(json_encode($phase)) ?>)">
                                                <i class="fas fa-edit me-1"></i>Modifier
                                            </button>
                                            <form method="POST" style="display: inline;" onsubmit="return confirm('Êtes-vous sûr de vouloir supprimer cette phase ?')">
                                                <input type="hidden" name="action" value="delete_phase">
                                                <input type="hidden" name="id" value="<?= $phase['id'] ?>">
                                                <button type="submit" class="btn btn-sm btn-outline-danger">
                                                    <i class="fas fa-trash me-1"></i>Supprimer
                                                </button>
                                            </form>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- Modal d'ajout -->
<div class="modal fade" id="addPhaseModal" tabindex="-1" data-bs-backdrop="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title"><i class="fas fa-plus me-2"></i>Nouvelle Phase de Défi</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="addForm">
                <div class="modal-body p-4">
                    <input type="hidden" name="action" value="add_phase">
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="phase" class="form-label fw-bold">Phase</label>
                            <select class="form-select" id="phase" name="phase" required>
                                <option value="">-- Sélectionner une phase --</option>
                                <option value="Phase de groupes">Phase de groupes</option>
                                <option value="8e de finale">8e de finale</option>
                                <option value="Quart de finale">Quart de finale</option>
                                <option value="Demi-finale">Demi-finale</option>
                                <option value="Finale">Finale</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="title" class="form-label fw-bold">Titre du défi</label>
                            <input type="text" class="form-control" id="title" name="title" placeholder="Ex: Défi photo Phase de groupes" required>
                        </div>
                        <div class="col-12">
                            <label for="description" class="form-label fw-bold">Description</label>
                            <textarea class="form-control" id="description" name="description" rows="4" placeholder="Décrivez le défi photo pour cette phase..."></textarea>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Annuler
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-save me-1"></i>Créer la phase
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal de modification -->
<div class="modal fade" id="editModal" tabindex="-1" data-bs-backdrop="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-warning text-dark">
                <h5 class="modal-title"><i class="fas fa-edit me-2"></i>Modifier la Phase</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" id="editForm">
                <div class="modal-body p-4">
                    <input type="hidden" name="action" value="update_phase">
                    <input type="hidden" name="id" id="edit_id">
                    
                    <div class="row g-3">
                        <div class="col-md-6">
                            <label for="edit_phase" class="form-label fw-bold">Phase</label>
                            <select class="form-select" id="edit_phase" name="phase" required>
                                <option value="Phase de groupes">Phase de groupes</option>
                                <option value="8e de finale">8e de finale</option>
                                <option value="Quart de finale">Quart de finale</option>
                                <option value="Demi-finale">Demi-finale</option>
                                <option value="Finale">Finale</option>
                            </select>
                        </div>
                        <div class="col-md-6">
                            <label for="edit_title" class="form-label fw-bold">Titre du défi</label>
                            <input type="text" class="form-control" id="edit_title" name="title" required>
                        </div>
                        <div class="col-12">
                            <label for="edit_description" class="form-label fw-bold">Description</label>
                            <textarea class="form-control" id="edit_description" name="description" rows="4"></textarea>
                        </div>
                        <div class="col-12">
                            <div class="form-check form-switch">
                                <input class="form-check-input" type="checkbox" id="edit_is_active" name="is_active">
                                <label class="form-check-label fw-bold" for="edit_is_active">
                                    <i class="fas fa-toggle-on me-1"></i>Phase active
                                </label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer bg-light">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">
                        <i class="fas fa-times me-1"></i>Annuler
                    </button>
                    <button type="submit" class="btn btn-warning">
                        <i class="fas fa-save me-1"></i>Sauvegarder
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<style>
/* Styles personnalisés pour les modals */
.modal-content {
    border-radius: 15px;
    overflow: hidden;
}

.modal-header {
    border-bottom: none;
    padding: 1.5rem;
}

.modal-body {
    padding: 2rem;
}

.modal-footer {
    border-top: 1px solid #e9ecef;
    padding: 1rem 1.5rem;
}

/* Animation pour les boutons */
.btn {
    transition: all 0.3s ease;
}

.btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
}

/* Styles pour les badges */
.badge {
    font-size: 0.75rem;
    padding: 0.5rem 0.75rem;
}

/* Styles pour les icônes */
.fa-2x {
    font-size: 1.5rem;
}

/* Statistiques compactes */
.card-body.py-2 {
    padding: 0.5rem !important;
}

.card-body.py-2 h5 {
    font-size: 1.1rem;
    margin-bottom: 0.25rem;
}

.card-body.py-2 small {
    font-size: 0.7rem;
}

.card-body.py-2 i {
    font-size: 1rem;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .modal-dialog {
        margin: 1rem;
    }
    
    .btn-group {
        flex-direction: column;
    }
    
    .btn-group .btn {
        margin-bottom: 0.25rem;
    }
    
    .card-body.py-2 {
        padding: 0.25rem !important;
    }
}
</style>

<script>
// Fonction pour éditer une phase
function editPhase(phase) {
    // Remplir les champs du formulaire
    document.getElementById('edit_id').value = phase.id;
    document.getElementById('edit_phase').value = phase.phase;
    document.getElementById('edit_title').value = phase.title;
    document.getElementById('edit_description').value = phase.description;
    document.getElementById('edit_is_active').checked = phase.is_active == 1;
    
    // Afficher le modal sans backdrop
    const modal = new bootstrap.Modal(document.getElementById('editModal'), {
        backdrop: false,
        keyboard: true
    });
    modal.show();
}

// Initialisation au chargement de la page
document.addEventListener('DOMContentLoaded', function() {
    // Gestion des modals sans backdrop
    const addModal = document.getElementById('addPhaseModal');
    const editModal = document.getElementById('editModal');
    
    // Nettoyer les formulaires à la fermeture
    if (addModal) {
        addModal.addEventListener('hidden.bs.modal', function () {
            document.getElementById('addForm').reset();
        });
    }
    
    if (editModal) {
        editModal.addEventListener('hidden.bs.modal', function () {
            document.getElementById('editForm').reset();
        });
    }
    
    // Animation des cartes statistiques (plus rapide)
    const cards = document.querySelectorAll('.card');
    cards.forEach((card, index) => {
        card.style.opacity = '0';
        card.style.transform = 'translateY(10px)';
        setTimeout(() => {
            card.style.transition = 'all 0.3s ease';
            card.style.opacity = '1';
            card.style.transform = 'translateY(0)';
        }, index * 50);
    });
    
    // Popup de confirmation pour l'ajout
    const addForm = document.getElementById('addForm');
    if (addForm) {
        addForm.addEventListener('submit', function(e) {
            e.preventDefault();
            Swal.fire({
                title: 'Créer une nouvelle phase ?',
                text: "Cette phase sera ajoutée aux défis photos.",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#0d6efd',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Oui, créer !',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        });
    }
    
    // Popup de confirmation pour la modification
    const editForm = document.getElementById('editForm');
    if (editForm) {
        editForm.addEventListener('submit', function(e) {
            e.preventDefault();
            Swal.fire({
                title: 'Modifier cette phase ?',
                text: "Les modifications seront appliquées immédiatement.",
                icon: 'question',
                showCancelButton: true,
                confirmButtonColor: '#ffc107',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Oui, modifier !',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        });
    }
    
    // Popup de confirmation pour la suppression
    const deleteForms = document.querySelectorAll('form[onsubmit*="confirm"]');
    deleteForms.forEach(form => {
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            Swal.fire({
                title: 'Supprimer cette phase ?',
                text: "Cette action ne peut pas être annulée !",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#dc3545',
                cancelButtonColor: '#6c757d',
                confirmButtonText: 'Oui, supprimer !',
                cancelButtonText: 'Annuler'
            }).then((result) => {
                if (result.isConfirmed) {
                    this.submit();
                }
            });
        });
    });
});
</script>

<?php include 'admin_footer.php'; ?>
