<?php include 'admin_header.php'; ?>
<?php
require '../includes/db.php';
// Ordre et abréviations officielles des phases
$phases_officielles = [
    "Phase de groupes · Journée 1 sur 3" => "J1",
    "Phase de groupes · Journée 2 sur 3" => "J2",
    "Phase de groupes · Journée 3 sur 3" => "J3",
    "8e de finale" => "8e",
    "Quart de finale" => "QF",
    "Demi-finale" => "DF",
    "Match pour la 3e place" => "3e",
    "Finale" => "F"
];
// Récupérer toutes les phases distinctes en base
$phases_db = [];
$result = $mysqli->query('SELECT DISTINCT phase FROM Matches ORDER BY match_date ASC');
while($row = $result->fetch_assoc()) {
    $phases_db[] = $row['phase'];
}
$result->close();
// Fusionner sans doublons et trier selon l'ordre officiel
$phases = [];
foreach (array_keys($phases_officielles) as $p) {
    if (in_array($p, $phases_db)) $phases[] = $p;
}
foreach ($phases_db as $p) {
    if (!in_array($p, $phases)) $phases[] = $p;
}
// Récupérer tous les utilisateurs (uniquement les users)
$users = [];
$result = $mysqli->query("SELECT id, username FROM Users WHERE role = 'user' ORDER BY username");
while($row = $result->fetch_assoc()) {
    $users[$row['id']] = $row['username'];
}
$result->close();
// Points par phase (matchs)
$points_matchs = [];
foreach ($phases as $phase) {
    $sql = "SELECT user_id, SUM(points + IFNULL(titulaire_11,0)) AS pts FROM match_points mp JOIN Matches m ON m.id = mp.match_id WHERE m.phase = ? GROUP BY user_id";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param('s', $phase);
    $stmt->execute();
    $result = $stmt->get_result();
    while($row = $result->fetch_assoc()) {
        $points_matchs[$row['user_id']][$phase] = $row['pts'];
    }
    $stmt->close();
}
// Points groupes
$points_groupes = [];
$result = $mysqli->query('SELECT user_id, SUM(points) as pts FROM groupe_points GROUP BY user_id');
while($row = $result->fetch_assoc()) {
    $points_groupes[$row['user_id']] = $row['pts'];
}
$result->close();
// Points vainqueur CAN
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
$points_vainqueur_can = file_exists('../includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('../includes/points_vainqueur_can.txt'))) : 100;
// Calculer le total pour chaque utilisateur
$totaux = [];
$points_vainqueur = [];
foreach ($users as $uid => $username) {
    $total = 0;
    foreach ($phases as $phase) {
        $pts = $points_matchs[$uid][$phase] ?? 0;
        $total += $pts;
    }
    $pts_groupes = $points_groupes[$uid] ?? 0;
    $total += $pts_groupes;
    // Points vainqueur CAN
    $pts_vainqueur = 0;
    if ($winner_team) {
        $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
        $stmt3->bind_param('i', $uid);
        $stmt3->execute();
        $stmt3->bind_result($user_team);
        $stmt3->fetch();
        $stmt3->close();
        if ($user_team && $user_team === $winner_team) {
            $pts_vainqueur = $points_vainqueur_can;
        }
    }
    $total += $pts_vainqueur;
    $totaux[$uid] = $total;
    $points_vainqueur[$uid] = $pts_vainqueur;
}
// Trier les utilisateurs par total décroissant
uksort($users, function($a, $b) use ($totaux) {
    return ($totaux[$b] ?? 0) <=> ($totaux[$a] ?? 0);
});
?>
<div class="container py-4">
  <h2 class="mb-4">Points des utilisateurs par phase et groupes</h2>
  <div class="table-responsive">
    <table class="table table-bordered table-striped bg-white">
      <thead class="table-dark">
        <tr>
          <th>Utilisateur</th>
          <?php foreach ($phases as $phase): ?>
            <th><?= htmlspecialchars($phases_officielles[$phase] ?? $phase) ?></th>
          <?php endforeach; ?>
          <th>Groupes</th>
          <th>Vainqueur CAN</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $uid => $username): ?>
          <tr>
            <td><?= htmlspecialchars($username) ?></td>
            <?php $total = 0; ?>
            <?php foreach ($phases as $phase): ?>
              <?php $pts = $points_matchs[$uid][$phase] ?? 0; $total += $pts; ?>
              <td><?= $pts ?></td>
            <?php endforeach; ?>
            <?php $pts_groupes = $points_groupes[$uid] ?? 0; $total += $pts_groupes; ?>
            <td><?= $pts_groupes ?></td>
            <?php $pts_vainqueur = $points_vainqueur[$uid] ?? 0; $total += $pts_vainqueur; ?>
            <td><?= $pts_vainqueur ?></td>
            <td class="fw-bold text-success"><?= $total ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include 'admin_footer.php'; ?> 