<?php
include 'admin_header.php';
require '../includes/db.php';

// Statistiques par ville
$villes = [];
$result = $mysqli->query("SELECT DISTINCT ville FROM Users WHERE ville IS NOT NULL AND ville != '' AND role = 'user' ORDER BY ville");
while ($row = $result->fetch_assoc()) {
    $villes[] = $row['ville'];
}

$stats_ville = [];
foreach ($villes as $ville) {
    // Nombre d'utilisateurs
    $stmt = $mysqli->prepare("SELECT id FROM Users WHERE ville = ? AND role = 'user'");
    $stmt->bind_param('s', $ville);
    $stmt->execute();
    $result = $stmt->get_result();
    $user_ids = [];
    while ($row = $result->fetch_assoc()) {
        $user_ids[] = $row['id'];
    }
    $stmt->close();
    $nb_users = count($user_ids);
    $user_ids_str = $user_ids ? implode(',', $user_ids) : '0';
    
    // Points totaux
    $pts_matchs = 0;
    if ($user_ids) {
        $result = $mysqli->query("SELECT SUM(points + IFNULL(titulaire_11,0)) as pts FROM match_points WHERE user_id IN ($user_ids_str)");
        if ($result) {
            $row = $result->fetch_assoc();
            $pts_matchs = $row ? (int)$row['pts'] : 0;
        }
    }
    $pts_groupes = 0;
    if ($user_ids) {
        $result = $mysqli->query("SELECT SUM(points) as pts FROM groupe_points WHERE user_id IN ($user_ids_str)");
        if ($result) {
            $row = $result->fetch_assoc();
            $pts_groupes = $row ? (int)$row['pts'] : 0;
        }
    }
    $pts_vainqueur = 0;
    if ($user_ids) {
        $result = $mysqli->query("SELECT SUM(points) as pts FROM winner_points WHERE user_id IN ($user_ids_str)");
        if ($result) {
            $row = $result->fetch_assoc();
            $pts_vainqueur = $row ? (int)$row['pts'] : 0;
        }
    }
    $points_total = (int)$pts_matchs + (int)$pts_groupes + (int)$pts_vainqueur;
    $moyenne = $nb_users ? round($points_total / $nb_users, 2) : 0;
    
    $stats_ville[] = [
        'ville' => $ville,
        'users' => $nb_users,
        'points_total' => $points_total,
        'moyenne' => $moyenne
    ];
}

// Statistiques par département
$departements = [];
$result = $mysqli->query("SELECT DISTINCT departement FROM Users WHERE departement IS NOT NULL AND departement != '' AND role = 'user' ORDER BY departement");
while ($row = $result->fetch_assoc()) {
    $departements[] = $row['departement'];
}

$stats_departement = [];
foreach ($departements as $departement) {
    // Nombre d'utilisateurs
    $stmt = $mysqli->prepare("SELECT id FROM Users WHERE departement = ? AND role = 'user'");
    $stmt->bind_param('s', $departement);
    $stmt->execute();
    $result = $stmt->get_result();
    $user_ids = [];
    while ($row = $result->fetch_assoc()) {
        $user_ids[] = $row['id'];
    }
    $stmt->close();
    $nb_users = count($user_ids);
    $user_ids_str = $user_ids ? implode(',', $user_ids) : '0';
    
    // Points totaux
    $pts_matchs = 0;
    if ($user_ids) {
        $result = $mysqli->query("SELECT SUM(points + IFNULL(titulaire_11,0)) as pts FROM match_points WHERE user_id IN ($user_ids_str)");
        if ($result) {
            $row = $result->fetch_assoc();
            $pts_matchs = $row ? (int)$row['pts'] : 0;
        }
    }
    $pts_groupes = 0;
    if ($user_ids) {
        $result = $mysqli->query("SELECT SUM(points) as pts FROM groupe_points WHERE user_id IN ($user_ids_str)");
        if ($result) {
            $row = $result->fetch_assoc();
            $pts_groupes = $row ? (int)$row['pts'] : 0;
        }
    }
    $pts_vainqueur = 0;
    if ($user_ids) {
        $result = $mysqli->query("SELECT SUM(points) as pts FROM winner_points WHERE user_id IN ($user_ids_str)");
        if ($result) {
            $row = $result->fetch_assoc();
            $pts_vainqueur = $row ? (int)$row['pts'] : 0;
        }
    }
    $points_total = (int)$pts_matchs + (int)$pts_groupes + (int)$pts_vainqueur;
    $moyenne = $nb_users ? round($points_total / $nb_users, 2) : 0;
    
    $stats_departement[] = [
        'departement' => $departement,
        'users' => $nb_users,
        'points_total' => $points_total,
        'moyenne' => $moyenne
    ];
}
?>
<div class="container py-4">
  <h2 class="mb-4">Statistiques par critères</h2>
  
  <!-- Tabs pour ville et département -->
  <ul class="nav nav-tabs mb-4" id="criteriaTabs" role="tablist">
    <li class="nav-item" role="presentation">
      <button class="nav-link active" id="ville-tab" data-bs-toggle="tab" data-bs-target="#ville-pane" type="button" role="tab">
        Par Ville
      </button>
    </li>
    <li class="nav-item" role="presentation">
      <button class="nav-link" id="departement-tab" data-bs-toggle="tab" data-bs-target="#departement-pane" type="button" role="tab">
        Par Département
      </button>
    </li>
  </ul>
  
  <div class="tab-content" id="criteriaTabContent">
    <!-- Statistiques par ville -->
    <div class="tab-pane fade show active" id="ville-pane" role="tabpanel">
      <div class="table-responsive mb-5">
        <table class="table table-bordered table-striped bg-white">
          <thead class="table-dark">
            <tr>
              <th>Ville</th>
              <th>Utilisateurs</th>
              <th>Points totaux</th>
              <th>Moyenne par utilisateur</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($stats_ville as $row): ?>
              <tr>
                <td><?= htmlspecialchars($row['ville']) ?></td>
                <td><?= $row['users'] ?></td>
                <td><?= $row['points_total'] ?></td>
                <td><?= $row['moyenne'] ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
    
    <!-- Statistiques par département -->
    <div class="tab-pane fade" id="departement-pane" role="tabpanel">
      <div class="table-responsive mb-5">
        <table class="table table-bordered table-striped bg-white">
          <thead class="table-dark">
            <tr>
              <th>Département</th>
              <th>Utilisateurs</th>
              <th>Points totaux</th>
              <th>Moyenne par utilisateur</th>
            </tr>
          </thead>
          <tbody>
            <?php foreach ($stats_departement as $row): ?>
              <tr>
                <td><?= htmlspecialchars($row['departement']) ?></td>
                <td><?= $row['users'] ?></td>
                <td><?= $row['points_total'] ?></td>
                <td><?= $row['moyenne'] ?></td>
              </tr>
            <?php endforeach; ?>
          </tbody>
        </table>
      </div>
    </div>
  </div>
</div>
<?php include 'admin_footer.php'; ?> 