<?php include 'admin_header.php'; ?>
<?php
require '../includes/db.php';
// Récupérer tous les utilisateurs (uniquement les users)
$users = [];
$result = $mysqli->query("SELECT id, username FROM Users WHERE role = 'user' ORDER BY username");
while($row = $result->fetch_assoc()) {
    $users[$row['id']] = $row['username'];
}
$result->close();
// Points totaux (matchs + groupes + vainqueur)
$totaux = [];
// Récupérer l'équipe gagnante de la CAN (admin)
$winner_team = null;
$result = $mysqli->query('SELECT team FROM winner_result LIMIT 1');
if ($row = $result->fetch_assoc()) {
    $winner_team = $row['team'];
}
$result->close();
$points_vainqueur_can = file_exists('../includes/points_vainqueur_can.txt') ? intval(trim(file_get_contents('../includes/points_vainqueur_can.txt'))) : 100;
foreach ($users as $uid => $username) {
    // Points matchs (sans titulaire_11)
    $sql = "SELECT SUM(points) AS pts FROM match_points WHERE user_id = ?";
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param('i', $uid);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();
    $pts_matchs = $row['pts'] ?? 0;
    $stmt->close();
    // Points groupes
    $stmt2 = $mysqli->prepare('SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?');
    $stmt2->bind_param('i', $uid);
    $stmt2->execute();
    $result2 = $stmt2->get_result();
    $row2 = $result2->fetch_assoc();
    $pts_groupes = $row2['pts'] ?? 0;
    $stmt2->close();
    // Points vainqueur CAN
    $pts_vainqueur = 0;
    if ($winner_team) {
        $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
        $stmt3->bind_param('i', $uid);
        $stmt3->execute();
        $stmt3->bind_result($user_team);
        $stmt3->fetch();
        $stmt3->close();
        if ($user_team && $user_team === $winner_team) {
            $pts_vainqueur = $points_vainqueur_can;
        }
    }
    // Points 11 titulaires
    $stmt4 = $mysqli->prepare('SELECT SUM(titulaire_11) AS pts_titulaires FROM match_points WHERE user_id = ?');
    $stmt4->bind_param('i', $uid);
    $stmt4->execute();
    $result4 = $stmt4->get_result();
    $row4 = $result4->fetch_assoc();
    $pts_titulaires = $row4['pts_titulaires'] ?? 0;
    $stmt4->close();

    $totaux[$uid] = $pts_matchs + $pts_groupes + $pts_vainqueur + $pts_titulaires;
}
// Trier les utilisateurs par total décroissant
uksort($users, function($a, $b) use ($totaux) {
    return ($totaux[$b] ?? 0) <=> ($totaux[$a] ?? 0);
});
?>
<div class="container py-4">
  <h2 class="mb-4">Classement général des utilisateurs</h2>
  <div class="table-responsive">
    <table class="table table-bordered table-striped bg-white">
      <thead class="table-dark">
        <tr>
          <th>Utilisateur</th>
          <th>Points matchs</th>
          <th>Points 11 titulaires</th>
          <th>Points groupes</th>
          <th>Points vainqueur CAN</th>
          <th>Total</th>
        </tr>
      </thead>
      <tbody>
        <?php foreach ($users as $uid => $username): ?>
          <?php
            // Recalcul pour affichage
            $sql = "SELECT SUM(points) AS pts FROM match_points WHERE user_id = ?";
            $stmt = $mysqli->prepare($sql);
            $stmt->bind_param('i', $uid);
            $stmt->execute();
            $result = $stmt->get_result();
            $row = $result->fetch_assoc();
            $pts_matchs = $row['pts'] ?? 0;
            $stmt->close();
            $stmt2 = $mysqli->prepare('SELECT SUM(points) as pts FROM groupe_points WHERE user_id = ?');
            $stmt2->bind_param('i', $uid);
            $stmt2->execute();
            $result2 = $stmt2->get_result();
            $row2 = $result2->fetch_assoc();
            $pts_groupes = $row2['pts'] ?? 0;
            $stmt2->close();
            // Points vainqueur CAN
            $pts_vainqueur = 0;
            if ($winner_team) {
                $stmt3 = $mysqli->prepare('SELECT team FROM winner_predictions WHERE user_id = ?');
                $stmt3->bind_param('i', $uid);
                $stmt3->execute();
                $stmt3->bind_result($user_team);
                $stmt3->fetch();
                $stmt3->close();
                if ($user_team && $user_team === $winner_team) {
                    $pts_vainqueur = $points_vainqueur_can;
                }
            }
            // Points 11 titulaires
            $stmt4 = $mysqli->prepare('SELECT SUM(titulaire_11) AS pts_titulaires FROM match_points WHERE user_id = ?');
            $stmt4->bind_param('i', $uid);
            $stmt4->execute();
            $result4 = $stmt4->get_result();
            $row4 = $result4->fetch_assoc();
            $pts_titulaires = $row4['pts_titulaires'] ?? 0;
            $stmt4->close();
            
            $total = $pts_matchs + $pts_groupes + $pts_vainqueur + $pts_titulaires;

          ?>
          <tr>
            <td><?= htmlspecialchars($username) ?></td>
            <td><?= $pts_matchs ?></td>
            <td><?= $pts_titulaires ?></td>
            <td><?= $pts_groupes ?></td>
            <td><?= $pts_vainqueur ?></td>
            <td class="fw-bold text-success"><?= $total ?></td>
          </tr>
        <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php include 'admin_footer.php'; ?> 