<?php
// Augmentation des limites pour afficher toutes les questions
ini_set('memory_limit', '512M');
ini_set('max_execution_time', 300);
set_time_limit(300);

session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

require_once '../includes/db.php';

// Traitement des actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['action'])) {
        switch ($_POST['action']) {
            case 'add_fr':
                // Insertion sans phase ni theme
                $stmt = $mysqli->prepare("INSERT INTO quizz_questions (question, answer, option1, option2, option3, option4) VALUES (?, ?, ?, ?, ?, ?)");
                if ($stmt) {
                    $stmt->bind_param('ssssss', $_POST['question'], $_POST['answer'], $_POST['option1'], $_POST['option2'], $_POST['option3'], $_POST['option4']);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
                
            case 'add_ar':
                // Insertion sans phase ni theme
                $stmt = $mysqli->prepare("INSERT INTO quizz_questions_ar (question, answer, option1, option2, option3, option4) VALUES (?, ?, ?, ?, ?, ?)");
                if ($stmt) {
                    $stmt->bind_param('ssssss', $_POST['question'], $_POST['answer'], $_POST['option1'], $_POST['option2'], $_POST['option3'], $_POST['option4']);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
                
            case 'update_fr':
                // Mise à jour sans phase ni theme
                $stmt = $mysqli->prepare("UPDATE quizz_questions SET question=?, answer=?, option1=?, option2=?, option3=?, option4=? WHERE id=?");
                if ($stmt) {
                    $stmt->bind_param('ssssssi', $_POST['question'], $_POST['answer'], $_POST['option1'], $_POST['option2'], $_POST['option3'], $_POST['option4'], $_POST['id']);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
                
            case 'update_ar':
                // Mise à jour sans phase ni theme
                $stmt = $mysqli->prepare("UPDATE quizz_questions_ar SET question=?, answer=?, option1=?, option2=?, option3=?, option4=? WHERE id=?");
                if ($stmt) {
                    $stmt->bind_param('ssssssi', $_POST['question'], $_POST['answer'], $_POST['option1'], $_POST['option2'], $_POST['option3'], $_POST['option4'], $_POST['id']);
                    $stmt->execute();
                    $stmt->close();
                }
                break;
                
            case 'delete_fr':
                $stmt = $mysqli->prepare("DELETE FROM quizz_questions WHERE id=?");
                $stmt->bind_param('i', $_POST['id']);
                $stmt->execute();
                $stmt->close();
                break;
                
            case 'delete_ar':
                $stmt = $mysqli->prepare("DELETE FROM quizz_questions_ar WHERE id=?");
                $stmt->bind_param('i', $_POST['id']);
                $stmt->execute();
                $stmt->close();
                break;
        }
        // Redirection avec message de succès pour éviter la re-soumission
        $success_message = '';
        switch ($_POST['action']) {
            case 'add_fr':
                $success_message = 'Question française ajoutée avec succès !';
                break;
            case 'add_ar':
                $success_message = 'تم إضافة السؤال العربي بنجاح!';
                break;
            case 'update_fr':
                $success_message = 'Question française modifiée avec succès !';
                break;
            case 'update_ar':
                $success_message = 'تم تعديل السؤال العربي بنجاح!';
                break;
            case 'delete_fr':
                $success_message = 'Question française supprimée avec succès !';
                break;
            case 'delete_ar':
                $success_message = 'تم حذف السؤال العربي بنجاح!';
                break;
        }
        
        // Stockage temporaire du message de succès en session
        $_SESSION['success_message'] = $success_message;
        header('Location: questions.php');
        exit;
    }
}

// Récupération de TOUTES les questions sans limitation
$questions_fr = [];
$questions_ar = [];

// Récupération de TOUTES les questions françaises (sans filtrage par phase/thème)
$result = $mysqli->query("SELECT * FROM quizz_questions ORDER BY id");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $questions_fr[] = $row;
    }
    $result->free();
}

// Récupération de TOUTES les questions arabes (sans filtrage par phase/thème)
$result = $mysqli->query("SELECT * FROM quizz_questions_ar ORDER BY id");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        $questions_ar[] = $row;
    }
    $result->free();
}

include 'admin_header.php';
?>

<?php if (isset($_SESSION['success_message'])): ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    Swal.fire({
        title: 'Succès !',
        text: '<?= htmlspecialchars($_SESSION['success_message']) ?>',
        icon: 'success',
        confirmButtonColor: '#28a745'
    });
});
</script>
<?php 
    // Suppression du message après affichage pour éviter qu'il réapparaisse
    unset($_SESSION['success_message']);
endif; 
?>

<div class="container-fluid">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Gestion des questions du quiz</h2>
        <a href="check_questions_consistency.php" class="btn btn-warning">
            <i class="fas fa-search"></i> Vérifier la cohérence des questions
        </a>
    </div>
    
    <!-- Onglets -->
    <ul class="nav nav-tabs mb-4" id="questionTabs" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="french-tab" data-bs-toggle="tab" data-bs-target="#french" type="button" role="tab">
                🇫🇷 Questions Françaises (<?= count($questions_fr) ?>)
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="arabic-tab" data-bs-toggle="tab" data-bs-target="#arabic" type="button" role="tab">
                🇲🇦 Questions Arabes (<?= count($questions_ar) ?>)
            </button>
        </li>
    </ul>
    
    <div class="tab-content" id="questionTabsContent">
                 <!-- Onglet Français -->
         <div class="tab-pane fade show active" id="french" role="tabpanel">
             <div class="d-flex justify-content-between align-items-center mb-3">
                 <h4>Questions en français</h4>
                                   <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#addFrenchModal">
                      ➕ Ajouter
                  </button>
             </div>
             
             <!-- Barre de recherche française -->
             <div class="row mb-3">
                 <div class="col-md-9">
                     <div class="input-group">
                         <input type="text" id="searchFrench" class="form-control" placeholder="Rechercher une question ou une réponse...">
                         <button class="btn btn-outline-secondary" type="button" onclick="clearFrenchSearch()">
                             🗑️
                         </button>
                     </div>
                 </div>
                 <div class="col-md-3">
                     <span class="badge bg-info" id="frenchResultsCount"><?= count($questions_fr) ?> questions</span>
                 </div>
             </div>
            
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Question</th>
                            <th>Réponse</th>
                            <th>Options</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                                         <tbody id="frenchTableBody">
                         <?php foreach ($questions_fr as $q): ?>
                         <tr data-question="<?= htmlspecialchars(strtolower($q['question'])) ?>" 
                             data-answer="<?= htmlspecialchars(strtolower($q['answer'])) ?>" 
                             data-options="<?= htmlspecialchars(strtolower($q['option1'] . ' ' . $q['option2'] . ' ' . $q['option3'] . ' ' . $q['option4'])) ?>">
                            <td><?= $q['id'] ?></td>
                            <td><?= htmlspecialchars($q['question']) ?></td>
                            <td><strong><?= htmlspecialchars($q['answer']) ?></strong></td>
                            <td>
                                <small>
                                    A: <?= htmlspecialchars($q['option1']) ?><br>
                                    B: <?= htmlspecialchars($q['option2']) ?><br>
                                    C: <?= htmlspecialchars($q['option3']) ?><br>
                                    D: <?= htmlspecialchars($q['option4']) ?>
                                </small>
                            </td>
                                                         <td>
                                                                   <button class="btn btn-xs btn-primary" onclick="editFrenchQuestion(<?= htmlspecialchars(json_encode($q)) ?>)">
                                      ✏️
                                  </button>
                                  <button class="btn btn-xs btn-danger" onclick="deleteFrenchQuestion(<?= $q['id'] ?>)">
                                      🗑️
                                  </button>
                             </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
        
                 <!-- Onglet Arabe -->
         <div class="tab-pane fade" id="arabic" role="tabpanel">
             <div class="d-flex justify-content-between align-items-center mb-3">
                 <h4>Questions en arabe</h4>
                                   <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#addArabicModal">
                      ➕ إضافة
                  </button>
             </div>
             
             <!-- Barre de recherche arabe -->
             <div class="row mb-3">
                 <div class="col-md-9">
                     <div class="input-group">
                         <input type="text" id="searchArabic" class="form-control" placeholder="البحث في السؤال أو الإجابة..." style="direction: rtl; text-align: right;">
                         <button class="btn btn-outline-secondary" type="button" onclick="clearArabicSearch()">
                             🗑️
                         </button>
                     </div>
                 </div>
                 <div class="col-md-3">
                     <span class="badge bg-info" id="arabicResultsCount"><?= count($questions_ar) ?> أسئلة</span>
                 </div>
             </div>
            
            <div class="table-responsive">
                <table class="table table-striped table-hover">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>السؤال</th>
                            <th>الإجابة</th>
                            <th>الخيارات</th>
                            <th>الإجراءات</th>
                        </tr>
                    </thead>
                                         <tbody id="arabicTableBody">
                         <?php foreach ($questions_ar as $q): ?>
                         <tr data-question="<?= htmlspecialchars(strtolower($q['question'])) ?>" 
                             data-answer="<?= htmlspecialchars(strtolower($q['answer'])) ?>" 
                             data-options="<?= htmlspecialchars(strtolower($q['option1'] . ' ' . $q['option2'] . ' ' . $q['option3'] . ' ' . $q['option4'])) ?>">
                            <td><?= $q['id'] ?></td>
                            <td style="direction: rtl; text-align: right;"><?= htmlspecialchars($q['question']) ?></td>
                            <td style="direction: rtl; text-align: right;"><strong><?= htmlspecialchars($q['answer']) ?></strong></td>
                            <td style="direction: rtl; text-align: right;">
                                <small>
                                    أ: <?= htmlspecialchars($q['option1']) ?><br>
                                    ب: <?= htmlspecialchars($q['option2']) ?><br>
                                    ج: <?= htmlspecialchars($q['option3']) ?><br>
                                    د: <?= htmlspecialchars($q['option4']) ?>
                                </small>
                            </td>
                                                         <td>
                                                                   <button class="btn btn-xs btn-primary" onclick="editArabicQuestion(<?= htmlspecialchars(json_encode($q)) ?>)">
                                      ✏️
                                  </button>
                                  <button class="btn btn-xs btn-danger" onclick="deleteArabicQuestion(<?= $q['id'] ?>)">
                                      🗑️
                                  </button>
                             </td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<!-- Modal Ajout Question Française -->
<div class="modal fade" id="addFrenchModal" tabindex="-1" data-bs-backdrop="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Ajouter une question française</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add_fr">
                    
                    <div class="mb-3">
                        <label class="form-label">Question</label>
                        <textarea name="question" class="form-control" rows="3" required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Réponse correcte</label>
                        <input type="text" name="answer" class="form-control" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 1</label>
                                <input type="text" name="option1" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 2</label>
                                <input type="text" name="option2" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 3</label>
                                <input type="text" name="option3" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 4</label>
                                <input type="text" name="option4" class="form-control" required>
                            </div>
                        </div>
                    </div>
                </div>
                                 <div class="modal-footer">
                     <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                     <button type="submit" class="btn btn-success" onclick="this.disabled=true; this.innerHTML='Ajout en cours...'; this.form.submit();">Ajouter</button>
                 </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Ajout Question Arabe -->
<div class="modal fade" id="addArabicModal" tabindex="-1" data-bs-backdrop="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">إضافة سؤال عربي</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="add_ar">
                    
                    <div class="mb-3">
                        <label class="form-label">السؤال</label>
                        <textarea name="question" class="form-control" rows="3" required style="direction: rtl; text-align: right;"></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">الإجابة الصحيحة</label>
                        <input type="text" name="answer" class="form-control" required style="direction: rtl; text-align: right;">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 1</label>
                                <input type="text" name="option1" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 2</label>
                                <input type="text" name="option2" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 3</label>
                                <input type="text" name="option3" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 4</label>
                                <input type="text" name="option4" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                    </div>
                </div>
                                 <div class="modal-footer">
                     <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                     <button type="submit" class="btn btn-success" onclick="this.disabled=true; this.innerHTML='جاري الإضافة...'; this.form.submit();">إضافة</button>
                 </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Édition Question Française -->
<div class="modal fade" id="editFrenchModal" tabindex="-1" data-bs-backdrop="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">Modifier la question française</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update_fr">
                    <input type="hidden" name="id" id="edit_fr_id">
                    
                    <div class="mb-3">
                        <label class="form-label">Question</label>
                        <textarea name="question" id="edit_fr_question" class="form-control" rows="3" required></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">Réponse correcte</label>
                        <input type="text" name="answer" id="edit_fr_answer" class="form-control" required>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 1</label>
                                <input type="text" name="option1" id="edit_fr_option1" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 2</label>
                                <input type="text" name="option2" id="edit_fr_option2" class="form-control" required>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 3</label>
                                <input type="text" name="option3" id="edit_fr_option3" class="form-control" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">Option 4</label>
                                <input type="text" name="option4" id="edit_fr_option4" class="form-control" required>
                            </div>
                        </div>
                    </div>
                </div>
                                 <div class="modal-footer">
                     <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                     <button type="submit" class="btn btn-primary" onclick="this.disabled=true; this.innerHTML='Modification en cours...'; this.form.submit();">Modifier</button>
                 </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Édition Question Arabe -->
<div class="modal fade" id="editArabicModal" tabindex="-1" data-bs-backdrop="false">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">تعديل السؤال العربي</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST">
                <div class="modal-body">
                    <input type="hidden" name="action" value="update_ar">
                    <input type="hidden" name="id" id="edit_ar_id">
                    
                    <div class="mb-3">
                        <label class="form-label">السؤال</label>
                        <textarea name="question" id="edit_ar_question" class="form-control" rows="3" required style="direction: rtl; text-align: right;"></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label">الإجابة الصحيحة</label>
                        <input type="text" name="answer" id="edit_ar_answer" class="form-control" required style="direction: rtl; text-align: right;">
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 1</label>
                                <input type="text" name="option1" id="edit_ar_option1" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 2</label>
                                <input type="text" name="option2" id="edit_ar_option2" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 3</label>
                                <input type="text" name="option3" id="edit_ar_option3" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label">الخيار 4</label>
                                <input type="text" name="option4" id="edit_ar_option4" class="form-control" required style="direction: rtl; text-align: right;">
                            </div>
                        </div>
                    </div>
                </div>
                                 <div class="modal-footer">
                     <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                     <button type="submit" class="btn btn-primary" onclick="this.disabled=true; this.innerHTML='جاري التعديل...'; this.form.submit();">تعديل</button>
                 </div>
            </form>
        </div>
    </div>
</div>

<script>
function editFrenchQuestion(question) {
    document.getElementById('edit_fr_id').value = question.id;
    document.getElementById('edit_fr_question').value = question.question;
    document.getElementById('edit_fr_answer').value = question.answer;
    document.getElementById('edit_fr_option1').value = question.option1;
    document.getElementById('edit_fr_option2').value = question.option2;
    document.getElementById('edit_fr_option3').value = question.option3;
    document.getElementById('edit_fr_option4').value = question.option4;
    
    new bootstrap.Modal(document.getElementById('editFrenchModal')).show();
}

function editArabicQuestion(question) {
    document.getElementById('edit_ar_id').value = question.id;
    document.getElementById('edit_ar_question').value = question.question;
    document.getElementById('edit_ar_answer').value = question.answer;
    document.getElementById('edit_ar_option1').value = question.option1;
    document.getElementById('edit_ar_option2').value = question.option2;
    document.getElementById('edit_ar_option3').value = question.option3;
    document.getElementById('edit_ar_option4').value = question.option4;
    
    new bootstrap.Modal(document.getElementById('editArabicModal')).show();
}

function deleteFrenchQuestion(id) {
    Swal.fire({
        title: 'Êtes-vous sûr ?',
        text: 'Voulez-vous vraiment supprimer cette question française ?',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'Oui, supprimer !',
        cancelButtonText: 'Annuler'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="action" value="delete_fr">
                <input type="hidden" name="id" value="${id}">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    });
}

function deleteArabicQuestion(id) {
    Swal.fire({
        title: 'هل أنت متأكد؟',
        text: 'هل تريد حقاً حذف هذا السؤال العربي؟',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#3085d6',
        confirmButtonText: 'نعم، احذف!',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            const form = document.createElement('form');
            form.method = 'POST';
            form.innerHTML = `
                <input type="hidden" name="action" value="delete_ar">
                <input type="hidden" name="id" value="${id}">
            `;
            document.body.appendChild(form);
            form.submit();
        }
    });
}

// Fonctions de recherche pour les questions françaises
function searchFrenchQuestions() {
    const searchTerm = document.getElementById('searchFrench').value.toLowerCase();
    const rows = document.querySelectorAll('#frenchTableBody tr');
    let visibleCount = 0;

    rows.forEach(row => {
        const question = row.getAttribute('data-question');
        const answer = row.getAttribute('data-answer');
        const options = row.getAttribute('data-options');
        
        const matchesSearch = !searchTerm || 
            question.includes(searchTerm) || 
            answer.includes(searchTerm) ||
            options.includes(searchTerm);
        
        if (matchesSearch) {
            row.style.display = '';
            visibleCount++;
        } else {
            row.style.display = 'none';
        }
    });
    
    document.getElementById('frenchResultsCount').textContent = `${visibleCount} questions`;
}

function clearFrenchSearch() {
    document.getElementById('searchFrench').value = '';
    searchFrenchQuestions();
}

// Fonctions de recherche pour les questions arabes
function searchArabicQuestions() {
    const searchTerm = document.getElementById('searchArabic').value.toLowerCase();
    const rows = document.querySelectorAll('#arabicTableBody tr');
    let visibleCount = 0;

    rows.forEach(row => {
        const question = row.getAttribute('data-question');
        const answer = row.getAttribute('data-answer');
        const options = row.getAttribute('data-options');
        
        const matchesSearch = !searchTerm || 
            question.includes(searchTerm) || 
            answer.includes(searchTerm) ||
            options.includes(searchTerm);
        
        if (matchesSearch) {
            row.style.display = '';
            visibleCount++;
        } else {
            row.style.display = 'none';
        }
    });
    
    document.getElementById('arabicResultsCount').textContent = `${visibleCount} أسئلة`;
}

function clearArabicSearch() {
    document.getElementById('searchArabic').value = '';
    searchArabicQuestions();
}

// Initialisation des événements de recherche
document.addEventListener('DOMContentLoaded', function() {
    // Recherche française
    document.getElementById('searchFrench').addEventListener('input', searchFrenchQuestions);
    
    // Recherche arabe
    document.getElementById('searchArabic').addEventListener('input', searchArabicQuestions);
    
    // Protection contre la re-soumission de formulaires
    const forms = document.querySelectorAll('form');
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const submitBtn = form.querySelector('button[type="submit"]');
            if (submitBtn && !submitBtn.disabled) {
                submitBtn.disabled = true;
                submitBtn.innerHTML = submitBtn.innerHTML.includes('Ajouter') ? 'Ajout en cours...' : 
                                    submitBtn.innerHTML.includes('إضافة') ? 'جاري الإضافة...' :
                                    submitBtn.innerHTML.includes('Modifier') ? 'Modification en cours...' :
                                    submitBtn.innerHTML.includes('تعديل') ? 'جاري التعديل...' : 'Traitement...';
            }
        });
    });
});
</script>

<style>
.btn-xs {
    padding: 0.25rem 0.5rem;
    font-size: 0.75rem;
    border-radius: 0.2rem;
}
</style>

<?php include 'admin_footer.php'; ?>
