<?php
// Démarrer la session et vérifier les permissions AVANT d'inclure admin_header.php
if (session_status() === PHP_SESSION_NONE) session_start();
if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

require_once '../includes/db.php';

// Suppression joueur - DOIT être fait AVANT l'inclusion de admin_header.php
if (isset($_GET['del'])) {
    $id = intval($_GET['del']);
    $stmt = $mysqli->prepare('SELECT poste, image FROM joueurs_maroc WHERE id = ?');
    $stmt->bind_param('i', $id);
    $stmt->execute();
    $stmt->bind_result($poste, $img);
    if ($stmt->fetch()) {
        $file = "../assets/titulaire/$poste/$img";
        if (file_exists($file)) unlink($file);
    }
    $stmt->close();
    $mysqli->query('DELETE FROM joueurs_maroc WHERE id = '.$id);
    header("Location: titulaires.php");
    exit;
}

include 'admin_header.php';

$msg = $_GET['msg'] ?? '';
// Ajout joueur
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['nom'], $_POST['poste'], $_FILES['image'])) {
    $nom = trim($_POST['nom']);
    $nom_ar = trim($_POST['nom_ar'] ?? '');
    $poste = $_POST['poste'];
    $file = $_FILES['image'];
    $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
    $img_name = str_replace([' ', "'"], ['-', ''], $nom) . '.png';
    $dest = "../assets/titulaire/$poste/" . $img_name;
    if ($ext === 'png' && move_uploaded_file($file['tmp_name'], $dest)) {
        $stmt = $mysqli->prepare('INSERT INTO joueurs_maroc (nom, nom_ar, poste, image) VALUES (?, ?, ?, ?)');
        $stmt->bind_param('ssss', $nom, $nom_ar, $poste, $img_name);
        $stmt->execute();
        $stmt->close();
        $msg = "Joueur ajouté !";
    } else {
        $msg = "Erreur lors de l'upload (format PNG uniquement).";
    }
}
// Liste des joueurs (affichage universel)
$res = $mysqli->query('SELECT id, nom, nom_ar, poste, image FROM joueurs_maroc ORDER BY poste, nom');
$all_joueurs = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
?>
<div class="container py-4">
    <h2 class="mb-4 text-center text-warning"><i class="bi bi-people-fill"></i> Gestion des joueurs du Maroc</h2>
    <?php if ($msg): ?>
        <div class="alert alert-info text-center fw-bold"><?= htmlspecialchars($msg) ?></div>
    <?php endif; ?>
    <form method="post" enctype="multipart/form-data" class="mb-4 bg-dark p-3 rounded shadow">
        <div class="row g-3 align-items-end">
            <div class="col-md-2">
                <label class="form-label text-white"><i class="bi bi-person-plus"></i> Nom du joueur (FR)</label>
                <input type="text" name="nom" class="form-control" required>
            </div>
            <div class="col-md-2">
                <label class="form-label text-white"><i class="bi bi-person-plus"></i> Nom du joueur (AR)</label>
                <input type="text" name="nom_ar" class="form-control" placeholder="الاسم بالعربية">
            </div>
            <div class="col-md-2">
                <label class="form-label text-white"><i class="bi bi-shield-lock"></i> Poste</label>
                <select name="poste" class="form-select" required>
                    <option value="gardiens">Gardiens</option>
                    <option value="défenseurs">Défenseurs</option>
                    <option value="milieux de terrain">Milieux de terrain</option>
                    <option value="attaquants">Attaquants</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label text-white"><i class="bi bi-image"></i> Image PNG du joueur</label>
                <input type="file" name="image" class="form-control" accept=".png" required>
            </div>
            <div class="col-md-1 d-grid">
                <button class="btn btn-success btn-lg" type="submit"><i class="bi bi-plus-circle"></i> Ajouter</button>
            </div>
        </div>
    </form>
    <div class="row mt-4" style="color: white;">
        <div class="col-12">
            <h4 class="mb-3 text-warning"><i class="bi bi-list-ul"></i> Liste des joueurs par poste</h4>
            <?php
            $postes = [
                'gardiens' => 'Gardiens',
                'défenseurs' => 'Défenseurs',
                'milieux de terrain' => 'Milieux de terrain',
                'attaquants' => 'Attaquants'
            ];
            foreach ($postes as $poste => $label) {
                echo '<h5 class="mt-4 mb-3 text-info">'.$label.'</h5><div class="row">';
                foreach ($all_joueurs as $j) {
                    if ($j['poste'] !== $poste) continue;
                    echo '<div class="col-12 col-md-6 col-lg-4 mb-3">';
                    echo '<div class="card bg-secondary text-white shadow-sm d-flex flex-row align-items-center p-2">';
                    echo '<img src="../assets/titulaire/'.htmlspecialchars($j['poste']).'/'.htmlspecialchars($j['image']).'" style="height:48px;width:48px;border-radius:50%;margin-right:16px;">';
                    echo '<div class="flex-grow-1">';
                    echo '<span class="fw-bold">'.htmlspecialchars($j['nom']).'</span>';
                    if (!empty($j['nom_ar'])) {
                        echo '<br><small class="text-muted">'.htmlspecialchars($j['nom_ar']).'</small>';
                    }
                    echo '</div>';
                    echo '<div class="d-flex gap-1">';
                    echo '<a href="edit_player_name_ar.php?id='.$j['id'].'&return=titulaires.php" class="btn btn-sm btn-warning" title="Modifier le nom en arabe"><i class="fas fa-edit"></i></a>';
                    echo '<a href="?del='.$j['id'].'" class="btn btn-sm btn-danger" onclick="return confirm(\'Supprimer ce joueur ?\')" title="Supprimer"><i class="fas fa-trash"></i></a>';
                    echo '</div>';
                    echo '</div></div>';
                }
                echo '</div>';
            }
            ?>
        </div>
    </div>
</div>
<?php include 'admin_footer.php'; ?> 