<?php
include 'admin_header.php';
require_once '../includes/db.php';

// Gestion de l'enregistrement des titulaires réels
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['match_id'], $_POST['titulaire_reel'])) {
    $match_id = intval($_POST['match_id']);
    $joueurs = $_POST['titulaire_reel']; // array of joueur names
    // On supprime les anciens pour ce match
    $stmt = $mysqli->prepare('DELETE FROM titulaires_reels WHERE match_id = ?');
    $stmt->bind_param('i', $match_id);
    $stmt->execute();
    $stmt->close();
    // On insère les nouveaux
    $stmt = $mysqli->prepare('INSERT INTO titulaires_reels (match_id, joueur, poste) VALUES (?, ?, ?)');
    foreach ($joueurs as $joueur_poste) {
        list($joueur, $poste) = explode('|', $joueur_poste, 2);
        $stmt->bind_param('iss', $match_id, $joueur, $poste);
        $stmt->execute();
    }
    $stmt->close();
    echo '<div class="alert alert-success">Titulaires réels enregistrés pour ce match.</div>';
}

$res = $mysqli->query("SELECT id, team_1, team_2, match_date FROM Matches WHERE team_1 = 'Maroc' OR team_2 = 'Maroc' ORDER BY match_date");
if ($res && $res->num_rows > 0) {
    $match_idx = 0;
    echo '<div class="accordion" id="accordionTitulaires">';
    while ($m = $res->fetch_assoc()) {
        $match_idx++;
        $collapse_id = 'collapseMatch'.$m['id'];
        $heading_id = 'headingMatch'.$m['id'];
        $show = ''; // Tous les tabs fermés par défaut
        
        // Vérifier si les 11 titulaires sont validés pour ce match
        $stmt_count = $mysqli->prepare('SELECT COUNT(*) as count FROM titulaires_reels WHERE match_id = ?');
        $stmt_count->bind_param('i', $m['id']);
        $stmt_count->execute();
        $result_count = $stmt_count->get_result();
        $row_count = $result_count->fetch_assoc();
        $stmt_count->close();
        $has_11_titulaires = ($row_count['count'] == 11);
        $check_indicator = $has_11_titulaires ? ' <span style="color: #ffffff; font-size: 1.2rem; margin-left: 8px;">✓</span>' : '';
        
        echo '<div class="accordion-item bg-dark text-white mb-4 shadow">';
        echo '<h2 class="accordion-header" id="'.$heading_id.'">';
        echo '<button class="accordion-button bg-dark text-white collapsed d-flex justify-content-between align-items-center" type="button" data-bs-toggle="collapse" data-bs-target="#'.$collapse_id.'" aria-expanded="false" aria-controls="'.$collapse_id.'" style="font-size:1.2rem;">';
        echo '<span><i class="fa-solid fa-trophy text-warning"></i> '.htmlspecialchars($m['team_1']).' vs '.htmlspecialchars($m['team_2']).'</span>';
        echo '<div class="d-flex align-items-center gap-3">';
        echo '<span class="text-info" style="color: white !important; font-weight: bold;">'.date('d/m/Y H:i', strtotime($m['match_date'])).'</span>';
        echo $check_indicator;
        echo '</div>';
        echo '</button>';
        echo '</h2>';
        echo '<div id="'.$collapse_id.'" class="accordion-collapse collapse" aria-labelledby="'.$heading_id.'" data-bs-parent="#accordionTitulaires">';
        echo '<div class="accordion-body bg-dark">';
        // Récupérer les titulaires réels pour pré-cocher les cases
        $stmt = $mysqli->prepare('SELECT joueur, poste FROM titulaires_reels WHERE match_id = ?');
        $stmt->bind_param('i', $m['id']);
        $stmt->execute();
        $result = $stmt->get_result();
        $titulaires_reels = $result->fetch_all(MYSQLI_ASSOC);
        $stmt->close();
        // Formulaire de sélection
        $res_j = $mysqli->query("SELECT nom, poste, image FROM joueurs_maroc ORDER BY poste, nom");
        $all_joueurs = $res_j ? $res_j->fetch_all(MYSQLI_ASSOC) : [];
        // Organiser les joueurs par poste
        $postes = [
            'gardiens' => 'Gardiens',
            'défenseurs' => 'Défenseurs',
            'milieux de terrain' => 'Milieux de terrain',
            'attaquants' => 'Attaquants'
        ];
        $joueurs_par_poste = [];
        foreach ($all_joueurs as $j) {
            $joueurs_par_poste[$j['poste']][] = $j;
        }
        echo '<form method="post" class="mb-2">';
        echo '<input type="hidden" name="match_id" value="'.intval($m['id']).'">';
        foreach ($postes as $poste_key => $poste_label) {
            echo '<h6 class="mt-3 mb-2 text-info">'.$poste_label.'</h6><div class="row">';
            if (!empty($joueurs_par_poste[$poste_key])) {
                foreach ($joueurs_par_poste[$poste_key] as $j) {
                    $val = htmlspecialchars($j['nom'].'|'.$j['poste']);
                    $checked = '';
                    foreach ($titulaires_reels as $tr) {
                        if ($tr['joueur'] === $j['nom']) $checked = 'checked';
                    }
                    $img_path = '../assets/titulaire/'.htmlspecialchars($j['poste']).'/'.htmlspecialchars($j['image']);
                    echo '<div class="col-12 col-md-6 col-lg-4 mb-3">';
                    echo '<div class="card bg-secondary text-white shadow-sm d-flex flex-row align-items-center p-2">';
                    echo '<input type="checkbox" class="form-check-input me-2" style="transform:scale(1.3);margin-right:10px;" name="titulaire_reel[]" value="'.$val.'" '.$checked.'> ';
                    echo '<img src="'.$img_path.'" style="height:48px;width:48px;border-radius:50%;margin-right:16px;">';
                    echo '<div class="flex-grow-1">';
                    echo '<span class="fw-bold">'.htmlspecialchars($j['nom']).'</span>';
                    echo '</div>';
                    echo '</div></div>';
                }
            } else {
                echo '<div class="col-12 text-muted">Aucun joueur</div>';
            }
            echo '</div>';
        }
        echo '<button type="submit" class="btn btn-success btn-lg mt-3"><i class="fa-solid fa-save"></i> Enregistrer les 11 titulaires réels</button>';
        echo '</form>';
        echo '</div></div></div>';
    }
    echo '</div>';
} else {
    echo '<div class="alert alert-warning">Aucun match du Maroc trouvé.</div>';
}
?>
<script>
document.addEventListener('DOMContentLoaded', function() {
  document.querySelectorAll('form').forEach(function(form) {
    const checkboxes = form.querySelectorAll('input[type="checkbox"][name^="titulaire_reel"]');
    const max = 11;
    function updateCheckboxes() {
      const checked = Array.from(checkboxes).filter(cb => cb.checked);
      if (checked.length >= max) {
        checkboxes.forEach(cb => { if (!cb.checked) cb.disabled = true; });
        if (!form.querySelector('.titulaire-limit-msg')) {
          const msg = document.createElement('div');
          msg.className = 'titulaire-limit-msg text-danger fw-bold mt-2';
          msg.textContent = 'Vous ne pouvez sélectionner que 11 joueurs.';
          form.appendChild(msg);
        }
      } else {
        checkboxes.forEach(cb => cb.disabled = false);
        const msg = form.querySelector('.titulaire-limit-msg');
        if (msg) msg.remove();
      }
    }
    checkboxes.forEach(cb => cb.addEventListener('change', updateCheckboxes));
    updateCheckboxes();
  });
});
</script>
<?php include 'admin_footer.php'; ?> 