<?php
// Script pour mettre à jour les noms en arabe des joueurs
// À exécuter une seule fois depuis l'interface admin

include 'admin_header.php';
require_once '../includes/db.php';

if (!isset($_SESSION['role']) || $_SESSION['role'] !== 'admin') {
    header('Location: ../index.php');
    exit;
}

$msg = '';

// Dictionnaire de traductions (nom français => nom arabe)
$translations = [
    // Gardiens
    'Yassine Bounou' => 'ياسين بونو',
    'Bounou' => 'بونو',
    'Munir El Kajoui' => 'مونير الكعبي',
    'Munir' => 'مونير',
    'Ahmed Reda Tagnaouti' => 'أحمد رضا التكناوتي',
    'Tagnaouti' => 'التكناوتي',
    
    // Défenseurs
    'Achraf Hakimi' => 'أشرف حكيمي',
    'Hakimi' => 'حكيمي',
    'Noussair Mazraoui' => 'نصير مزراوي',
    'Mazraoui' => 'مزراوي',
    'Romain Saïss' => 'رومان سايس',
    'Saiss' => 'سايس',
    'Saïss' => 'سايس',
    'Nayef Aguerd' => 'نعيم أجرد',
    'Aguerd' => 'أجرد',
    'Jawad El Yamiq' => 'جاويد النخلي',
    'El Yamiq' => 'النخلي',
    'Yamiq' => 'النخلي',
    'Badr Benoun' => 'بدر بانون',
    'Benoun' => 'بانون',
    
    // Milieux
    'Sofyan Amrabat' => 'سفيان أمرباط',
    'Amrabat' => 'أمرباط',
    'Azzedine Ounahi' => 'عزيز بوحدوز',
    'Ounahi' => 'بوحدوز',
    'Selim Amallah' => 'سليم أمالاح',
    'Amallah' => 'أمالاح',
    'Bilal El Khannous' => 'بليل الخنوس',
    'El Khannous' => 'الخنوس',
    'Khannous' => 'الخنوس',
    
    // Attaquants
    'Youssef En-Nesyri' => 'يوسف النصيري',
    'En-Nesyri' => 'النصيري',
    'En Nesyri' => 'النصيري',
    'Nesyri' => 'النصيري',
    'Abderrazak Hamdallah' => 'عبد الرزاق حمد الله',
    'Hamdallah' => 'حمد الله',
    'Hakim Ziyech' => 'حكيم زياش',
    'Ziyech' => 'زياش',
    'Imran Louza' => 'عمران لوزون',
    'Louza' => 'لوزون',
    'Amine Harit' => 'أمين هاريت',
    'Harit' => 'هاريت',
];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_all'])) {
    // Récupérer tous les joueurs
    $res = $mysqli->query('SELECT id, nom FROM joueurs_maroc WHERE nom_ar IS NULL OR nom_ar = ""');
    $updated = 0;
    $not_found = [];
    
    while ($row = $res->fetch_assoc()) {
        $nom = $row['nom'];
        $id = $row['id'];
        $nom_ar = null;
        
        // Chercher une correspondance exacte
        if (isset($translations[$nom])) {
            $nom_ar = $translations[$nom];
        } else {
            // Chercher une correspondance partielle
            foreach ($translations as $key => $value) {
                if (stripos($nom, $key) !== false || stripos($key, $nom) !== false) {
                    $nom_ar = $value;
                    break;
                }
            }
        }
        
        if ($nom_ar) {
            $stmt = $mysqli->prepare('UPDATE joueurs_maroc SET nom_ar = ? WHERE id = ?');
            $stmt->bind_param('si', $nom_ar, $id);
            $stmt->execute();
            $stmt->close();
            $updated++;
        } else {
            $not_found[] = $nom;
        }
    }
    
    $msg = "Mise à jour terminée : $updated joueur(s) mis à jour.";
    if (!empty($not_found)) {
        $msg .= "<br>Joueurs non trouvés dans le dictionnaire : " . implode(', ', $not_found);
    }
}

// Afficher tous les joueurs avec leurs traductions
$res = $mysqli->query('SELECT id, nom, nom_ar, poste FROM joueurs_maroc ORDER BY poste, nom');
$all_joueurs = $res ? $res->fetch_all(MYSQLI_ASSOC) : [];
?>

<div class="container py-4">
    <h2 class="mb-4 text-center text-warning">Mise à jour des noms en arabe</h2>
    
    <?php if ($msg): ?>
        <div class="alert alert-info"><?= $msg ?></div>
    <?php endif; ?>
    
    <form method="post" class="mb-4">
        <button type="submit" name="update_all" class="btn btn-primary btn-lg">
            Mettre à jour automatiquement tous les joueurs
        </button>
    </form>
    
    <div class="table-responsive">
        <table class="table table-dark table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nom (FR)</th>
                    <th>Nom (AR)</th>
                    <th>Poste</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($all_joueurs as $j): ?>
                <tr>
                    <td><?= $j['id'] ?></td>
                    <td><?= htmlspecialchars($j['nom']) ?></td>
                    <td>
                        <?php if (empty($j['nom_ar'])): ?>
                            <span class="text-warning">Non traduit</span>
                        <?php else: ?>
                            <?= htmlspecialchars($j['nom_ar']) ?>
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($j['poste']) ?></td>
                    <td>
                        <a href="edit_player_name_ar.php?id=<?= $j['id'] ?>" class="btn btn-sm btn-warning">
                            Modifier
                        </a>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php include 'admin_footer.php'; ?>

