<?php include 'admin_header.php'; ?>
<?php
require '../includes/db.php';

// Récupérer tous les utilisateurs (sauf les admins)
$users = [];
// Vérifier si le champ is_blocked existe
$checkColumn = $mysqli->query("SHOW COLUMNS FROM Users LIKE 'is_blocked'");
$hasIsBlocked = $checkColumn->num_rows > 0;

$sql = 'SELECT id, username, email, site, ville, departement, photo, created_at';
if ($hasIsBlocked) {
    $sql .= ', is_blocked';
}
$sql .= ' FROM Users WHERE role = "user" ORDER BY created_at DESC';

$stmt = $mysqli->prepare($sql);
$stmt->execute();
$result = $stmt->get_result();
while ($row = $result->fetch_assoc()) {
    $users[] = $row;
}
$stmt->close();

// Récupérer les valeurs uniques pour les filtres (sites uniquement depuis les utilisateurs)
$sites = [];
foreach ($users as $user) {
    if (!empty($user['site']) && !in_array($user['site'], $sites)) {
        $sites[] = $user['site'];
    }
}
sort($sites);

// Liste complète des villes du Maroc (pour les filtres et les formulaires)
$all_villes = [
    'Casablanca',
    'Rabat',
    'Fès',
    'Marrakech',
    'Agadir',
    'Tanger',
    'Meknès',
    'Oujda',
    'Kénitra',
    'Tétouan',
    'Safi',
    'Mohammedia',
    'Khouribga',
    'Beni Mellal',
    'El Jadida',
    'Taza',
    'Nador',
    'Settat',
    'Larache',
    'Ksar El Kebir',
    'Khemisset',
    'Guelmim',
    'Berrechid',
    'Ouarzazate',
    'Errachidia',
    'Essaouira',
    'Dakhla',
    'Laâyoune',
    'Tiznit',
    'Sidi Kacem',
    'Azrou',
    'Ifrane',
    'Chefchaouen',
    'Autre'
];

// Liste complète des départements (pour les filtres et les formulaires)
$all_departements = [
    'CREDIT CONSO',
    'PRODUCTION & APPUI COMMERCIAL',
    'OPC',
    'RESSOURCES HUMAINES',
    'CORPORATE BANKING',
    'CONFORMITE',
    'RETAIL BANKING',
    'LEASING',
    'DSI',
    'IMEX',
    'ACHATS',
    'FINANCE PARTICIPATIVE',
    'RECOUVREMENT',
    'SECURITIES SERVICES',
    'BANQUE PRIVEE',
    'SECURITE PHYSIQUE',
    'RISQUES',
    'FINANCE',
    'EXPERIENCE CLIENT & QUALITE',
    'TRANSFORMATION ET EFFICACITE OPERATIONNELLE',
    'ALM TREASURY',
    'LOCAL CAPITAL MARKET',
    'COMMUNICATION',
    'PROGRAMME SAB',
    'DIGITAL FACTORY',
    'MONETIQUE',
    'AFFAIRES JURIDIQUES',
    'DIRECTION GENERALE',
    'CDO',
    'INSPECTION GENERALE',
    'ENGAGEMENT',
    'PILOTAGE STRATEGIQUE',
    'Association des Retraités BMCI'
];

// Utiliser les listes complètes pour les filtres
$villes = $all_villes;
$departements = $all_departements;

// Compter le nombre total d'utilisateurs
$total_users = count($users);
?>

<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0 text-white"><i class="fas fa-users me-2"></i>Liste des utilisateurs inscrits</h2>
    <div class="d-flex align-items-center gap-3">
        <span class="badge bg-primary fs-6" id="totalBadge">Total : <?= $total_users ?> utilisateur<?= $total_users > 1 ? 's' : '' ?></span>
        <button type="button" class="btn btn-danger" onclick="openAddUserModal()">
            <i class="fas fa-plus me-2"></i>Ajouter un utilisateur
        </button>
    </div>
</div>

<!-- Filtres -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-header bg-dark text-white">
        <h5 class="mb-0"><i class="fas fa-filter me-2"></i>Filtres de recherche</h5>
    </div>
    <div class="card-body">
        <div class="row g-3">
            <!-- Recherche par nom/email -->
            <div class="col-md-3">
                <label for="searchInput" class="form-label text-white"><i class="fas fa-search me-2"></i>Recherche</label>
                <input type="text" id="searchInput" class="form-control" placeholder="Nom, email...">
            </div>
            
            <!-- Filtre par ville -->
            <div class="col-md-2">
                <label for="filterVille" class="form-label text-white"><i class="fas fa-city me-2"></i>Ville</label>
                <select id="filterVille" class="form-select">
                    <option value="">Toutes les villes</option>
                    <?php foreach ($all_villes as $ville): ?>
                        <option value="<?= htmlspecialchars($ville) ?>"><?= htmlspecialchars($ville) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Filtre par département -->
            <div class="col-md-2">
                <label for="filterDepartement" class="form-label text-white"><i class="fas fa-map-marker-alt me-2"></i>Département</label>
                <select id="filterDepartement" class="form-select">
                    <option value="">Tous les départements</option>
                    <?php foreach ($all_departements as $dept): ?>
                        <option value="<?= htmlspecialchars($dept) ?>"><?= htmlspecialchars($dept) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <!-- Tri -->
            <div class="col-md-2">
                <label for="sortBy" class="form-label text-white"><i class="fas fa-sort me-2"></i>Tri</label>
                <select id="sortBy" class="form-select">
                    <option value="date-desc">Date (récent)</option>
                    <option value="date-asc">Date (ancien)</option>
                    <option value="name-asc">Nom (A-Z)</option>
                    <option value="name-desc">Nom (Z-A)</option>
                </select>
            </div>
            <!-- Bouton réinitialiser -->
            <div class="col-md-3 d-flex align-items-end">
                <button type="button" class="btn btn-secondary btn-sm" onclick="resetFilters()">
                    <i class="fas fa-redo me-2"></i>Réinitialiser les filtres
                </button>
            </div>
        </div>
    </div>
</div>

<div class="card border-0 shadow-sm">
    <div class="card-body">
        <?php if (empty($users)): ?>
            <div class="alert alert-info text-center">
                <i class="fas fa-info-circle me-2"></i>Aucun utilisateur inscrit pour le moment.
            </div>
        <?php else: ?>
            <div class="table-responsive">
                <table class="table table-hover table-striped align-middle" id="usersTable">
                    <thead class="table-dark">
                        <tr>
                            <th>ID</th>
                            <th>Nom d'utilisateur</th>
                            <th>Email</th>
                            <th>Ville</th>
                            <th>Département</th>
                            <th>Date d'inscription</th>
                            <th>Photo</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="usersTableBody">
                        <?php foreach ($users as $user): ?>
                            <tr data-username="<?= strtolower(htmlspecialchars($user['username'])) ?>" 
                                data-email="<?= strtolower(htmlspecialchars($user['email'])) ?>"
                                data-site="<?= htmlspecialchars($user['site'] ?? '') ?>"
                                data-ville="<?= htmlspecialchars($user['ville'] ?? '') ?>"
                                data-departement="<?= htmlspecialchars($user['departement'] ?? '') ?>"
                                data-date="<?= strtotime($user['created_at']) ?>">
                                <td><?= htmlspecialchars($user['id']) ?></td>
                                <td>
                                    <strong><?= htmlspecialchars($user['username']) ?></strong>
                                    <?php if (isset($user['is_blocked']) && $user['is_blocked'] == 1): ?>
                                        <span class="badge bg-danger ms-2" title="Compte bloqué">
                                            <i class="fas fa-lock me-1"></i>Bloqué
                                        </span>
                                    <?php endif; ?>
                                </td>
                                <td><?= htmlspecialchars($user['email']) ?></td>
                                <td><?= htmlspecialchars($user['ville'] ?? '-') ?></td>
                                <td><?= htmlspecialchars($user['departement'] ?? '-') ?></td>
                                <td>
                                    <?php 
                                    $date = new DateTime($user['created_at']);
                                    echo $date->format('d/m/Y H:i');
                                    ?>
                                </td>
                                <td>
                                    <?php
                                    $photo_path = '';
                                    if (!empty($user['photo'])) {
                                        // Vérifier si le fichier existe dans le dossier upload
                                        $upload_path = '../assets/img/upload/' . $user['photo'];
                                        if (file_exists($upload_path)) {
                                            $photo_path = '../assets/img/upload/' . htmlspecialchars($user['photo']);
                                        }
                                    }
                                    
                                    // Si pas de photo uploadée, utiliser une image anonyme avec les initiales
                                    if (empty($photo_path)) {
                                        // Extraire les initiales du nom et prénom
                                        $username = trim($user['username']);
                                        $words = explode(' ', $username);
                                        $initials = '';
                                        
                                        if (count($words) >= 2) {
                                            // Prendre la première lettre du prénom et du nom
                                            $initials = strtoupper(substr($words[0], 0, 1) . substr($words[count($words) - 1], 0, 1));
                                        } elseif (count($words) == 1 && strlen($words[0]) > 0) {
                                            // Si un seul mot, prendre les deux premières lettres
                                            $initials = strtoupper(substr($words[0], 0, min(2, strlen($words[0]))));
                                        } else {
                                            $initials = 'AN';
                                        }
                                        
                                        // Utiliser un service d'avatar avec les initiales
                                        $initials_encoded = urlencode($initials);
                                        $photo_path = 'https://ui-avatars.com/api/?name=' . $initials_encoded . '&background=6c757d&color=fff&size=128&bold=true';
                                    }
                                    ?>
                                    <img src="<?= $photo_path ?>" 
                                         alt="Photo de profil" 
                                         class="rounded-circle" 
                                         style="width: 40px; height: 40px; object-fit: cover;"
                                         onerror="this.src='https://ui-avatars.com/api/?name=AN&background=6c757d&color=fff&size=128&bold=true'">
                                </td>
                                <td>
                                    <button class="btn btn-sm btn-secondary" type="button" onclick="openActionMenu(<?= $user['id'] ?>, '<?= htmlspecialchars(addslashes($user['username'])) ?>', '<?= htmlspecialchars(addslashes($user['email'])) ?>', '<?= htmlspecialchars(addslashes($user['site'] ?? '')) ?>', '<?= htmlspecialchars(addslashes($user['ville'] ?? '')) ?>', '<?= htmlspecialchars(addslashes($user['departement'] ?? '')) ?>', <?= isset($user['is_blocked']) && $user['is_blocked'] ? 'true' : 'false' ?>)" title="Actions">
                                        <i class="fas fa-cog"></i>
                                    </button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
    .table {
        background-color: #fff;
    }
    .table thead th {
        border-bottom: 2px solid #dee2e6;
    }
    .table tbody tr:hover {
        background-color: #f8f9fa;
    }
    .form-label {
        font-weight: 500;
    }
    /* Style pour les modals SweetAlert - éviter que le backdrop bloque la saisie */
    .swal2-popup {
        z-index: 10000 !important;
    }
    .swal2-container {
        z-index: 9999 !important;
    }
    .swal2-backdrop-show {
        pointer-events: auto !important;
    }
    .swal2-popup input {
        pointer-events: auto !important;
    }
</style>

<script>
function filterUsers() {
    const searchTerm = document.getElementById('searchInput').value.toLowerCase();
    const filterVille = document.getElementById('filterVille').value;
    const filterDepartement = document.getElementById('filterDepartement').value;
    const sortBy = document.getElementById('sortBy').value;
    
    const rows = document.querySelectorAll('#usersTableBody tr');
    let visibleRows = [];
    let visibleCount = 0;
    
    // Filtrer les lignes
    rows.forEach(row => {
        const username = row.getAttribute('data-username') || '';
        const email = row.getAttribute('data-email') || '';
        const ville = row.getAttribute('data-ville') || '';
        const departement = row.getAttribute('data-departement') || '';
        
        // Vérifier la recherche
        const matchesSearch = !searchTerm || 
            username.includes(searchTerm) || 
            email.includes(searchTerm);
        
        // Vérifier les filtres
        const matchesVille = !filterVille || ville === filterVille;
        const matchesDepartement = !filterDepartement || departement === filterDepartement;
        
        if (matchesSearch && matchesVille && matchesDepartement) {
            row.style.display = '';
            visibleRows.push(row);
            visibleCount++;
        } else {
            row.style.display = 'none';
        }
    });
    
    // Trier les lignes visibles
    visibleRows.sort((a, b) => {
        if (sortBy === 'date-desc') {
            return parseInt(b.getAttribute('data-date')) - parseInt(a.getAttribute('data-date'));
        } else if (sortBy === 'date-asc') {
            return parseInt(a.getAttribute('data-date')) - parseInt(b.getAttribute('data-date'));
        } else if (sortBy === 'name-asc') {
            const nameA = a.getAttribute('data-username');
            const nameB = b.getAttribute('data-username');
            return nameA.localeCompare(nameB);
        } else if (sortBy === 'name-desc') {
            const nameA = a.getAttribute('data-username');
            const nameB = b.getAttribute('data-username');
            return nameB.localeCompare(nameA);
        }
        return 0;
    });
    
    // Réorganiser les lignes dans le DOM
    const tbody = document.getElementById('usersTableBody');
    visibleRows.forEach(row => {
        tbody.appendChild(row);
    });
    
    // Mettre à jour le badge
    const totalBadge = document.getElementById('totalBadge');
    totalBadge.textContent = `Affichés : ${visibleCount} / <?= $total_users ?> utilisateur${visibleCount > 1 ? 's' : ''}`;
}

function resetFilters() {
    document.getElementById('searchInput').value = '';
    document.getElementById('filterVille').value = '';
    document.getElementById('filterDepartement').value = '';
    document.getElementById('sortBy').value = 'date-desc';
    filterUsers();
}

// Écouter les changements
document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('searchInput').addEventListener('input', filterUsers);
    document.getElementById('filterVille').addEventListener('change', filterUsers);
    document.getElementById('filterDepartement').addEventListener('change', filterUsers);
    document.getElementById('sortBy').addEventListener('change', filterUsers);
});

// Fonction pour ouvrir le menu d'actions avec SweetAlert
function openActionMenu(userId, username, email, site, ville, departement, isBlocked) {
    // Échapper les apostrophes pour JavaScript
    const usernameEscaped = username.replace(/'/g, "\\'");
    const emailEscaped = email.replace(/'/g, "\\'");
    const siteEscaped = site.replace(/'/g, "\\'");
    const villeEscaped = ville.replace(/'/g, "\\'");
    const departementEscaped = departement.replace(/'/g, "\\'");
    
    Swal.fire({
        title: 'Actions',
        html: `
            <div style="text-align: left; padding: 10px;">
                <button id="btnEdit" class="btn btn-warning w-100 mb-2" style="text-align: left;">
                    <i class="fas fa-edit me-2"></i>Modifier
                </button>
                <button id="btnChangePassword" class="btn btn-info w-100 mb-2" style="text-align: left;">
                    <i class="fas fa-key me-2"></i>Modifier le mot de passe
                </button>
                <button id="btnDelete" class="btn btn-danger w-100 mb-2" style="text-align: left;">
                    <i class="fas fa-trash me-2"></i>Supprimer
                </button>
                <button id="btnBlock" class="btn ${isBlocked ? 'btn-success' : 'btn-danger'} w-100" style="text-align: left;">
                    <i class="fas fa-${isBlocked ? 'unlock' : 'lock'} me-2"></i>${isBlocked ? 'Débloquer' : 'Bloquer'} l'accès
                </button>
            </div>
        `,
        showConfirmButton: false,
        showCancelButton: true,
        cancelButtonText: 'Fermer',
        cancelButtonColor: '#6c757d',
        width: '400px',
        didOpen: () => {
            document.getElementById('btnEdit').addEventListener('click', function() {
                Swal.close();
                setTimeout(() => {
                    openEditUserModal(userId, usernameEscaped, emailEscaped, siteEscaped, villeEscaped, departementEscaped);
                }, 100);
            });
            
            document.getElementById('btnChangePassword').addEventListener('click', function() {
                Swal.close();
                setTimeout(() => {
                    openChangePasswordModal(userId, usernameEscaped);
                }, 100);
            });
            
            document.getElementById('btnDelete').addEventListener('click', function() {
                Swal.close();
                setTimeout(() => {
                    confirmDeleteUser(userId, usernameEscaped);
                }, 100);
            });
            
            document.getElementById('btnBlock').addEventListener('click', function() {
                Swal.close();
                setTimeout(() => {
                    toggleBlockUser(userId, usernameEscaped, isBlocked);
                }, 100);
            });
        }
    });
}

// Fonction pour ouvrir le modal d'ajout
function openAddUserModal() {
    Swal.fire({
        title: 'Ajouter un utilisateur',
        html: `
            <form id="addUserForm" style="text-align: left;">
                <div class="mb-3">
                    <label for="add_username" class="form-label">Nom et Prénom <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="add_username" name="username" required>
                </div>
                <div class="mb-3">
                    <label for="add_email" class="form-label">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control" id="add_email" name="email" required>
                </div>
                <div class="mb-3">
                    <label for="add_ville" class="form-label">Ville</label>
                    <select class="form-control" id="add_ville" name="ville">
                        <option value="">Sélectionner une ville</option>
                        <?php foreach ($all_villes as $ville): ?>
                            <option value="<?= htmlspecialchars($ville) ?>"><?= htmlspecialchars($ville) ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="add_departement" class="form-label">Département</label>
                    <select class="form-control" id="add_departement" name="departement">
                        <option value="">-- Sélectionner un département --</option>
                        <option value="CREDIT CONSO">CREDIT CONSO</option>
                        <option value="PRODUCTION &amp; APPUI COMMERCIAL">PRODUCTION &amp; APPUI COMMERCIAL</option>
                        <option value="OPC">OPC</option>
                        <option value="RESSOURCES HUMAINES">RESSOURCES HUMAINES</option>
                        <option value="CORPORATE BANKING">CORPORATE BANKING</option>
                        <option value="CONFORMITE">CONFORMITE</option>
                        <option value="RETAIL BANKING">RETAIL BANKING</option>
                        <option value="LEASING">LEASING</option>
                        <option value="DSI">DSI</option>
                        <option value="IMEX">IMEX</option>
                        <option value="ACHATS">ACHATS</option>
                        <option value="FINANCE PARTICIPATIVE">FINANCE PARTICIPATIVE</option>
                        <option value="RECOUVREMENT">RECOUVREMENT</option>
                        <option value="SECURITIES SERVICES">SECURITIES SERVICES</option>
                        <option value="BANQUE PRIVEE">BANQUE PRIVEE</option>
                        <option value="SECURITE PHYSIQUE">SECURITE PHYSIQUE</option>
                        <option value="RISQUES">RISQUES</option>
                        <option value="FINANCE">FINANCE</option>
                        <option value="EXPERIENCE CLIENT &amp; QUALITE">EXPERIENCE CLIENT &amp; QUALITE</option>
                        <option value="TRANSFORMATION ET EFFICACITE OPERATIONNELLE">TRANSFORMATION ET EFFICACITE OPERATIONNELLE</option>
                        <option value="ALM TREASURY">ALM TREASURY</option>
                        <option value="LOCAL CAPITAL MARKET">LOCAL CAPITAL MARKET</option>
                        <option value="COMMUNICATION">COMMUNICATION</option>
                        <option value="PROGRAMME SAB">PROGRAMME SAB</option>
                        <option value="DIGITAL FACTORY">DIGITAL FACTORY</option>
                        <option value="MONETIQUE">MONETIQUE</option>
                        <option value="AFFAIRES JURIDIQUES">AFFAIRES JURIDIQUES</option>
                        <option value="DIRECTION GENERALE">DIRECTION GENERALE</option>
                        <option value="CDO">CDO</option>
                        <option value="INSPECTION GENERALE">INSPECTION GENERALE</option>
                        <option value="ENGAGEMENT">ENGAGEMENT</option>
                        <option value="PILOTAGE STRATEGIQUE">PILOTAGE STRATEGIQUE</option>
                        <option value="Association des Retraités BMCI">Association des Retraités BMCI</option>
                    </select>
                </div>
            </form>
        `,
        showCancelButton: true,
        confirmButtonText: 'Ajouter',
        cancelButtonText: 'Annuler',
        confirmButtonColor: '#198754',
        cancelButtonColor: '#6c757d',
        backdrop: true,
        allowOutsideClick: true,
        allowEscapeKey: true,
        didOpen: () => {
            // S'assurer que les champs sont focusables
            const inputs = document.querySelectorAll('.swal2-popup input');
            if (inputs.length > 0) {
                inputs[0].focus();
            }
        },
        preConfirm: () => {
            const username = document.getElementById('add_username').value.trim();
            const email = document.getElementById('add_email').value.trim();
            const ville = document.getElementById('add_ville').value.trim();
            const departement = document.getElementById('add_departement').value.trim();
            
            if (!username || !email) {
                Swal.showValidationMessage('Le nom et l\'email sont obligatoires');
                return false;
            }
            
            if (!email.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
                Swal.showValidationMessage('Format d\'email invalide');
                return false;
            }
            
            return { username, email, ville, departement };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'add');
            formData.append('username', result.value.username);
            formData.append('email', result.value.email);
            formData.append('site', 'Jorf'); // Valeur par défaut
            formData.append('ville', result.value.ville);
            formData.append('departement', result.value.departement);
            
            fetch('../ajax/manage_user.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    let htmlMessage = data.message;
                    if (!data.email_sent) {
                        htmlMessage += '<br><br><strong>Mot de passe temporaire :</strong><br><code style="font-size: 1.2em;">' + data.password + '</code><br><small>Notez-le précieusement ! L\'email n\'a pas pu être envoyé.</small>';
                    }
                    
                    Swal.fire({
                        icon: 'success',
                        title: 'Succès',
                        html: htmlMessage,
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#198754'
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erreur',
                        text: data.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Erreur',
                    text: 'Une erreur est survenue lors de l\'ajout.',
                    confirmButtonColor: '#dc3545'
                });
            });
        }
    });
}

// Fonction pour ouvrir le modal de modification
function openEditUserModal(userId, username, email, site, ville, departement) {
    // site est conservé mais non affiché dans le formulaire
    Swal.fire({
        title: 'Modifier l\'utilisateur',
        html: `
            <form id="editUserForm" style="text-align: left;">
                <div class="mb-3">
                    <label for="edit_username" class="form-label">Nom et Prénom <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="edit_username" name="username" value="${username}" required>
                </div>
                <div class="mb-3">
                    <label for="edit_email" class="form-label">Email <span class="text-danger">*</span></label>
                    <input type="email" class="form-control" id="edit_email" name="email" value="${email}" required>
                </div>
                <div class="mb-3">
                    <label for="edit_ville" class="form-label">Ville</label>
                    <select class="form-control" id="edit_ville" name="ville">
                        <option value="">Sélectionner une ville</option>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="edit_departement" class="form-label">Département</label>
                    <select class="form-control" id="edit_departement" name="departement">
                        <option value="">Sélectionner un département</option>
                    </select>
                </div>
            </form>
        `,
        showCancelButton: true,
        confirmButtonText: 'Modifier',
        cancelButtonText: 'Annuler',
        confirmButtonColor: '#ffc107',
        cancelButtonColor: '#6c757d',
        backdrop: true,
        allowOutsideClick: true,
        allowEscapeKey: true,
        didOpen: () => {
            // Remplir les selects avec les options disponibles
            const villesOptions = <?= json_encode(array_map('htmlspecialchars', $all_villes)) ?>;
            const departementsOptions = [
                'CREDIT CONSO',
                'PRODUCTION & APPUI COMMERCIAL',
                'OPC',
                'RESSOURCES HUMAINES',
                'CORPORATE BANKING',
                'CONFORMITE',
                'RETAIL BANKING',
                'LEASING',
                'DSI',
                'IMEX',
                'ACHATS',
                'FINANCE PARTICIPATIVE',
                'RECOUVREMENT',
                'SECURITIES SERVICES',
                'BANQUE PRIVEE',
                'SECURITE PHYSIQUE',
                'RISQUES',
                'FINANCE',
                'EXPERIENCE CLIENT & QUALITE',
                'TRANSFORMATION ET EFFICACITE OPERATIONNELLE',
                'ALM TREASURY',
                'LOCAL CAPITAL MARKET',
                'COMMUNICATION',
                'PROGRAMME SAB',
                'DIGITAL FACTORY',
                'MONETIQUE',
                'AFFAIRES JURIDIQUES',
                'DIRECTION GENERALE',
                'CDO',
                'INSPECTION GENERALE',
                'ENGAGEMENT',
                'PILOTAGE STRATEGIQUE',
                'Association des Retraités BMCI'
            ];
            
            const villeSelect = document.getElementById('edit_ville');
            const departementSelect = document.getElementById('edit_departement');
            
            // Remplir le select des villes
            villesOptions.forEach(v => {
                const option = document.createElement('option');
                option.value = v;
                option.textContent = v;
                if (v === ville) {
                    option.selected = true;
                }
                villeSelect.appendChild(option);
            });
            
            // Remplir le select des départements
            departementsOptions.forEach(d => {
                const option = document.createElement('option');
                option.value = d;
                option.textContent = d;
                if (d === departement) {
                    option.selected = true;
                }
                departementSelect.appendChild(option);
            });
            
            // S'assurer que les champs sont focusables
            const inputs = document.querySelectorAll('.swal2-popup input');
            if (inputs.length > 0) {
                inputs[0].focus();
            }
        },
        preConfirm: () => {
            const username = document.getElementById('edit_username').value.trim();
            const email = document.getElementById('edit_email').value.trim();
            const ville = document.getElementById('edit_ville').value.trim();
            const departement = document.getElementById('edit_departement').value.trim();
            
            if (!username || !email) {
                Swal.showValidationMessage('Le nom et l\'email sont obligatoires');
                return false;
            }
            
            if (!email.match(/^[^\s@]+@[^\s@]+\.[^\s@]+$/)) {
                Swal.showValidationMessage('Format d\'email invalide');
                return false;
            }
            
            return { username, email, ville, departement };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'edit');
            formData.append('user_id', userId);
            formData.append('username', result.value.username);
            formData.append('email', result.value.email);
            formData.append('site', site); // Conserver la valeur existante
            formData.append('ville', result.value.ville);
            formData.append('departement', result.value.departement);
            
            fetch('../ajax/manage_user.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Succès',
                        text: data.message,
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#198754'
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erreur',
                        text: data.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Erreur',
                    text: 'Une erreur est survenue lors de la modification.',
                    confirmButtonColor: '#dc3545'
                });
            });
        }
    });
}

// Fonction pour ouvrir le modal de modification du mot de passe
function openChangePasswordModal(userId, username) {
    Swal.fire({
        title: 'Modifier le mot de passe',
        html: `
            <form id="changePasswordForm" style="text-align: left;">
                <div class="mb-3">
                    <label for="new_password" class="form-label">Nouveau mot de passe <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" id="new_password" name="new_password" required minlength="6" placeholder="Minimum 6 caractères">
                    <small class="form-text text-muted">Le mot de passe doit contenir au moins 6 caractères.</small>
                </div>
                <div class="mb-3">
                    <label for="confirm_password" class="form-label">Confirmer le mot de passe <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" id="confirm_password" name="confirm_password" required minlength="6" placeholder="Répétez le mot de passe">
                </div>
            </form>
        `,
        showCancelButton: true,
        confirmButtonText: 'Modifier',
        cancelButtonText: 'Annuler',
        confirmButtonColor: '#0dcaf0',
        cancelButtonColor: '#6c757d',
        backdrop: true,
        allowOutsideClick: true,
        allowEscapeKey: true,
        didOpen: () => {
            // S'assurer que les champs sont focusables
            const inputs = document.querySelectorAll('.swal2-popup input');
            if (inputs.length > 0) {
                inputs[0].focus();
            }
        },
        preConfirm: () => {
            const newPassword = document.getElementById('new_password').value.trim();
            const confirmPassword = document.getElementById('confirm_password').value.trim();
            
            if (!newPassword || newPassword.length < 6) {
                Swal.showValidationMessage('Le mot de passe doit contenir au moins 6 caractères');
                return false;
            }
            
            if (newPassword !== confirmPassword) {
                Swal.showValidationMessage('Les mots de passe ne correspondent pas');
                return false;
            }
            
            return { new_password: newPassword };
        }
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'change_password');
            formData.append('user_id', userId);
            formData.append('new_password', result.value.new_password);
            
            fetch('../ajax/manage_user.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Succès',
                        text: data.message,
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#198754'
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erreur',
                        text: data.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Erreur',
                    text: 'Une erreur est survenue lors de la modification du mot de passe.',
                    confirmButtonColor: '#dc3545'
                });
            });
        }
    });
}

// Fonction pour confirmer la suppression
function confirmDeleteUser(userId, username) {
    Swal.fire({
        title: 'Confirmer la suppression',
        html: `Êtes-vous sûr de vouloir supprimer l'utilisateur <strong>${username}</strong> ?<br><br>Cette action est irréversible !`,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'Oui, supprimer',
        cancelButtonText: 'Annuler'
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'delete');
            formData.append('user_id', userId);
            
            fetch('../ajax/manage_user.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Succès',
                        text: data.message,
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#198754'
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erreur',
                        text: data.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Erreur',
                    text: 'Une erreur est survenue lors de la suppression.',
                    confirmButtonColor: '#dc3545'
                });
            });
        }
    });
}

// Fonction pour bloquer/débloquer un utilisateur
function toggleBlockUser(userId, username, isBlocked) {
    const action = isBlocked ? 'débloquer' : 'bloquer';
    const actionText = isBlocked ? 'débloquer' : 'bloquer';
    
    Swal.fire({
        title: `Confirmer le ${actionText}`,
        html: `Êtes-vous sûr de vouloir ${actionText} l'accès de l'utilisateur <strong>${username}</strong> ?`,
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: isBlocked ? '#198754' : '#dc3545',
        cancelButtonColor: '#6c757d',
        confirmButtonText: `Oui, ${actionText}`,
        cancelButtonText: 'Annuler'
    }).then((result) => {
        if (result.isConfirmed) {
            const formData = new FormData();
            formData.append('action', 'toggle_block');
            formData.append('user_id', userId);
            
            fetch('../ajax/manage_user.php', {
                method: 'POST',
                body: formData
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    Swal.fire({
                        icon: 'success',
                        title: 'Succès',
                        text: data.message,
                        confirmButtonText: 'OK',
                        confirmButtonColor: '#198754'
                    }).then(() => {
                        location.reload();
                    });
                } else {
                    Swal.fire({
                        icon: 'error',
                        title: 'Erreur',
                        text: data.message,
                        confirmButtonColor: '#dc3545'
                    });
                }
            })
            .catch(error => {
                Swal.fire({
                    icon: 'error',
                    title: 'Erreur',
                    text: 'Une erreur est survenue lors de la modification.',
                    confirmButtonColor: '#dc3545'
                });
            });
        }
    });
}
</script>

<?php include 'admin_footer.php'; ?>

