<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';
if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}
$team_1 = trim($_POST['team_1'] ?? '');
$team_2 = trim($_POST['team_2'] ?? '');
$match_date = $_POST['match_date'] ?? '';
$phase = trim($_POST['phase'] ?? 'Phase de groupes');
if(!$team_1 || !$team_2 || !$match_date || !$phase) {
    echo json_encode(['success' => false, 'message' => 'Tous les champs sont obligatoires.']);
    exit;
}
try {
    $stmt = $mysqli->prepare('INSERT INTO Matches (team_1, team_2, match_date, phase) VALUES (?, ?, ?, ?)');
    $stmt->bind_param('ssss', $team_1, $team_2, $match_date, $phase);
    $stmt->execute();
    $stmt->close();
    echo json_encode(['success' => true]);
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'ajout.']);
} 