<?php
session_start();
header('Content-Type: application/json');
require_once '../includes/db.php';

if (!isset($_SESSION['user_id']) || !isset($_SESSION['quiz_started'])) {
    echo json_encode(['success' => false, 'error' => 'No active quiz']);
    exit;
}

$user_id = $_SESSION['user_id'];
$phase = $_SESSION['quiz_phase'];

// Calculer le score actuel
$score = 0;
$current_lang = $_SESSION['language'] ?? 'fr';

if (isset($_SESSION['quiz_answers']) && is_array($_SESSION['quiz_answers'])) {
    foreach ($_SESSION['quiz_answers'] as $qid => $user_answer) {
        $table_name = ($current_lang === 'ar') ? 'quizz_questions_ar' : 'quizz_questions';
        $stmt = $mysqli->prepare("SELECT answer FROM {$table_name} WHERE id = ?");
        $stmt->bind_param('i', $qid);
        $stmt->execute();
        $result = $stmt->get_result();
        $question = $result->fetch_assoc();
        $stmt->close();
        
        if ($question && $user_answer === $question['answer']) {
            $score += 10;
        }
    }
}

// Si la phase était "Match pour la 3e place", sauvegarder sous "Finale" (car combinées)
if ($phase === 'Match pour la 3e place') {
    $phase = 'Finale';
}

// Terminer le quiz et verrouiller
$stmt = $mysqli->prepare('UPDATE quizz_results_phases SET score = ?, completed_at = UTC_TIMESTAMP(), locked = 1 WHERE user_id = ? AND phase = ?');
$stmt->bind_param('iis', $score, $user_id, $phase);
$success = $stmt->execute();
$stmt->close();

// Supprimer le timer de session
$stmt = $mysqli->prepare('DELETE FROM quiz_timer_sessions WHERE user_id = ? AND phase = ?');
$stmt->bind_param('is', $user_id, $phase);
$stmt->execute();
$stmt->close();

// Nettoyer la session
unset($_SESSION['quiz_phase']);
unset($_SESSION['quiz_theme_idx']);
unset($_SESSION['quiz_question_idx']);
unset($_SESSION['quiz_answers']);
unset($_SESSION['quiz_started']);
unset($_SESSION['quiz_start_time']);
unset($_SESSION['quiz_show_feedback']);
unset($_SESSION['quiz_current_question_id']);
unset($_SESSION['quiz_questions']);
unset($_SESSION['quiz_validation_result']);

echo json_encode([
    'success' => $success,
    'score' => $score,
    'message' => 'Quiz sauvegardé et terminé automatiquement'
]);

