<?php
// Activer l'affichage des erreurs pour le débogage
error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once '../includes/language.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

// Log pour débogage
error_log("change_language.php appelé avec POST: " . print_r($_POST, true));

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $new_lang = $_POST['language'] ?? '';
    
    error_log("Langue demandée: " . $new_lang);
    
    if (setLanguage($new_lang)) {
        $response = [
            'success' => true, 
            'language' => $new_lang,
            'direction' => getTextDirection(),
            'message' => __('language') . ' ' . __('success')
        ];
        error_log("Changement de langue réussi: " . json_encode($response));
        echo json_encode($response);
    } else {
        $response = [
            'success' => false, 
            'error' => __('error'),
            'message' => 'Langue invalide: ' . $new_lang
        ];
        error_log("Échec du changement de langue: " . json_encode($response));
        echo json_encode($response);
    }
} else {
    $response = [
        'success' => false, 
        'error' => __('error'),
        'message' => 'Méthode non autorisée: ' . $_SERVER['REQUEST_METHOD']
    ];
    error_log("Méthode non autorisée: " . json_encode($response));
    echo json_encode($response);
}
?>