<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit;
}

require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];
$newPassword = $_POST['newPassword'] ?? '';

if (!$newPassword) {
    echo json_encode(['success' => false, 'message' => 'Le nouveau mot de passe est requis']);
    exit;
}

if (strlen($newPassword) < 6) {
    echo json_encode(['success' => false, 'message' => 'Le nouveau mot de passe doit contenir au moins 6 caractères']);
    exit;
}

try {
    // Mettre à jour le mot de passe directement
    $hashedPassword = password_hash($newPassword, PASSWORD_DEFAULT);
    $stmt = $mysqli->prepare("UPDATE Users SET password = ? WHERE id = ?");
    $stmt->bind_param('si', $hashedPassword, $user_id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
    }
    $stmt->close();
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur']);
}
?>
