<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';

// Définir le fuseau horaire GMT+1
date_default_timezone_set('Etc/GMT-1');
if(!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}

$user_id = $_SESSION['user_id'];
$match_id = intval($_POST['match_id'] ?? 0);
$new_score_1 = intval($_POST['new_score_1'] ?? 0);
$new_score_2 = intval($_POST['new_score_2'] ?? 0);

if(!$match_id || $new_score_1 < 0 || $new_score_2 < 0) {
    echo json_encode(['success' => false, 'message' => 'Données invalides.']);
    exit;
}

// Vérifier que les nouveaux scores ne sont pas égaux
if($new_score_1 == $new_score_2) {
    echo json_encode(['success' => false, 'message' => 'Les scores ne peuvent pas être égaux dans cette phase.']);
    exit;
}

// Charger la configuration du délai de clôture des pronostics de matchs
$match_deadline_hours_file = __DIR__.'/../includes/match_deadline_hours.txt';
$match_deadline_hours = 1; // Valeur par défaut : 1 heure
if (file_exists($match_deadline_hours_file)) {
    $match_deadline_hours = (int)trim(file_get_contents($match_deadline_hours_file));
    if ($match_deadline_hours <= 0) $match_deadline_hours = 1; // Minimum 1 heure
}

// Récupérer la date du match
$stmt = $mysqli->prepare('SELECT match_date FROM Matches WHERE id = ?');
$stmt->bind_param('i', $match_id);
$stmt->execute();
$result = $stmt->get_result();
$match = $result->fetch_assoc();
$stmt->close();

if(!$match) {
    echo json_encode(['success' => false, 'message' => 'Match introuvable.']);
    exit;
}

// Calculer la deadline : X heures avant le match (en GMT+1)
$deadline = date('Y-m-d H:i:s', strtotime($match['match_date']) - ($match_deadline_hours * 3600));
$current_time = date('Y-m-d H:i:s');

if(date('Y-m-d H:i:s') >= $deadline) {
    echo json_encode(['success' => false, 'message' => 'Pronostic fermé pour ce match.']);
    exit;
}

// Vérifier si un pronostic existe déjà
$stmt = $mysqli->prepare('SELECT id FROM Predictions WHERE user_id = ? AND match_id = ?');
$stmt->bind_param('ii', $user_id, $match_id);
$stmt->execute();
$result = $stmt->get_result();
$existing = $result->fetch_assoc();
$stmt->close();

if($existing) {
    $stmt = $mysqli->prepare('UPDATE Predictions SET predicted_team_1 = ?, predicted_team_2 = ?, prediction_time = NOW() WHERE id = ?');
    $stmt->bind_param('iii', $new_score_1, $new_score_2, $existing['id']);
    $stmt->execute();
    $stmt->close();
} else {
    $stmt = $mysqli->prepare('INSERT INTO Predictions (user_id, match_id, predicted_team_1, predicted_team_2) VALUES (?, ?, ?, ?)');
    $stmt->bind_param('iiii', $user_id, $match_id, $new_score_1, $new_score_2);
    $stmt->execute();
    $stmt->close();
}

echo json_encode(['success' => true, 'message' => 'Pronostic corrigé avec succès.']);
?>
