<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';

// Vérifier que l'utilisateur est admin
if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}

// Vérifier que l'ID du match est fourni
if(!isset($_POST['match_id']) || empty($_POST['match_id'])) {
    echo json_encode(['success' => false, 'message' => 'ID du match manquant.']);
    exit;
}

$match_id = intval($_POST['match_id']);

try {
    // Vérifier que le match existe
    $stmt = $mysqli->prepare('SELECT id, team_1, team_2, match_date FROM Matches WHERE id = ?');
    $stmt->bind_param('i', $match_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if($result->num_rows === 0) {
        echo json_encode(['success' => false, 'message' => 'Match introuvable.']);
        exit;
    }
    
    $match = $result->fetch_assoc();
    $stmt->close();
    
    // Supprimer le match
    $stmt = $mysqli->prepare('DELETE FROM Matches WHERE id = ?');
    $stmt->bind_param('i', $match_id);
    
    if($stmt->execute()) {
        echo json_encode([
            'success' => true, 
            'message' => 'Match supprimé avec succès.',
            'deleted_match' => $match
        ]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur lors de la suppression du match.']);
    }
    
    $stmt->close();
    
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de la suppression du match.']);
}
?>
