<?php
header('Content-Type: application/json');
session_start();

if (!isset($_SESSION['user_id']) || ($_SESSION['role'] !== 'admin' && $_SESSION['role'] !== 'stat')) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit;
}

require_once '../includes/db.php';

$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-7 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');

try {
    // Vérifier si la table existe, sinon la créer
    $tableCheck = $mysqli->query("SHOW TABLES LIKE 'user_logins'");
    if ($tableCheck->num_rows == 0) {
        // Créer la table si elle n'existe pas
        $mysqli->query("CREATE TABLE IF NOT EXISTS user_logins (
            id INT AUTO_INCREMENT PRIMARY KEY,
            user_id INT NOT NULL,
            login_date DATETIME NOT NULL,
            INDEX idx_user_id (user_id),
            INDEX idx_login_date (login_date)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
    }
    
    // Récupérer les statistiques de connexion par jour
    $stmt = $mysqli->prepare("
        SELECT 
            DATE(login_date) as date,
            COUNT(DISTINCT user_id) as unique_users,
            COUNT(*) as total_logins
        FROM user_logins
        WHERE DATE(login_date) BETWEEN ? AND ?
        GROUP BY DATE(login_date)
        ORDER BY date ASC
    ");
    
    $stmt->bind_param('ss', $start_date, $end_date);
    $stmt->execute();
    $result = $stmt->get_result();
    
    $stats = [];
    while ($row = $result->fetch_assoc()) {
        $stats[] = $row;
    }
    $stmt->close();
    
    // Calculer le total d'utilisateurs uniques sur toute la période
    $totalUniqueUsersStmt = $mysqli->prepare("
        SELECT COUNT(DISTINCT user_id) as total_unique_users
        FROM user_logins
        WHERE DATE(login_date) BETWEEN ? AND ?
    ");
    $totalUniqueUsersStmt->bind_param('ss', $start_date, $end_date);
    $totalUniqueUsersStmt->execute();
    $totalUniqueResult = $totalUniqueUsersStmt->get_result();
    $totalUniqueRow = $totalUniqueResult->fetch_assoc();
    $totalUniqueUsersStmt->close();
    
    echo json_encode([
        'success' => true, 
        'data' => $stats,
        'total_unique_users' => $totalUniqueRow['total_unique_users'] ?? 0
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur: ' . $e->getMessage()]);
}

