<?php
date_default_timezone_set('Etc/GMT-1');
session_start();
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}
require_once '../includes/language.php';
$match_id = intval($_GET['match_id'] ?? 0);
if (!$match_id) {
    echo json_encode(['success' => false, 'message' => 'Match non trouvé.']);
    exit;
}
require_once '../includes/db.php';
$stmt = $mysqli->prepare('SELECT match_date FROM Matches WHERE id = ?');
$stmt->bind_param('i', $match_id);
$stmt->execute();
$result = $stmt->get_result();
$match = $result->fetch_assoc();
$stmt->close();
if (!$match) {
    echo json_encode(['success' => false, 'message' => 'Match non trouvé.']);
    exit;
}

// Vérifier si le match est dans moins de 2 heures
$match_time = strtotime($match['match_date']);
$deadline_titulaires = $match_time - 2*3600; // 2 heures avant le match
$now = time();

if ($now >= $deadline_titulaires) {
    echo json_encode(['success' => false, 'message' => 'La sélection des titulaires est fermée. Elle se ferme 2 heures avant le match.']);
    exit;
}
$user_id = $_SESSION['user_id'];
$joueurs_selected = [];
$res = $mysqli->prepare('SELECT joueur FROM titulaires WHERE user_id = ? AND match_id = ?');
$res->bind_param('ii', $user_id, $match_id);
$res->execute();
$res->bind_result($nom_joueur);
while ($res->fetch()) {
    $joueurs_selected[] = $nom_joueur;
}
$res->close();
$postes = [
    'gardiens' => __('goalkeepers'),
    'défenseurs' => __('defenders'),
    'milieux de terrain' => __('midfielders'),
    'attaquants' => __('forwards')
];
$current_lang = getCurrentLanguage();
$html = '';
foreach ($postes as $poste => $label) {
    $stmt = $mysqli->prepare('SELECT id, nom, nom_ar, image FROM joueurs_maroc WHERE poste = ? ORDER BY nom');
    $stmt->bind_param('s', $poste);
    $stmt->execute();
    $res = $stmt->get_result();
    $joueurs = $res->fetch_all(MYSQLI_ASSOC);
    $stmt->close();
    $html .= "<h5 class='mt-3'>$label</h5><div class='row'>";
    if (!$joueurs) {
        $html .= "<div class='col-12 text-muted'>Aucun joueur</div>";
    }
    foreach ($joueurs as $j) {
        $id = $j['id'];
        $nom = getPlayerName($j['nom'], $j['nom_ar'] ?? null);
        $nom_original = $j['nom']; // Garder le nom original pour la vérification
        $img = $j['image'];
        $checked = in_array($nom_original, $joueurs_selected) ? 'checked' : '';
        $html .= "<div class='col-6 col-md-4 col-lg-3 mb-2'>";
        $html .= "<label class='d-flex align-items-center'>";
        $html .= "<input type='checkbox' class='joueur-checkbox me-2' value='$id' $checked>";
        $html .= "<img src='./assets/titulaire/$poste/$img' style='height:32px;width:32px;border-radius:50%;margin-right:8px;'>";
        $html .= "<span>" . htmlspecialchars($nom) . "</span>";
        $html .= "</label></div>";
    }
    $html .= "</div>";
}
echo json_encode(['success' => true, 'html' => $html]);

require_once '../includes/db.php';
// Pour chaque match du Maroc terminé
$res = $mysqli->query("SELECT id FROM Matches WHERE (team_1 = 'Maroc' OR team_2 = 'Maroc') AND status = 'completed'");
while ($m = $res->fetch_assoc()) {
    $match_id = $m['id'];
    // Récupérer la compo réelle
    $reels = [];
    $r = $mysqli->prepare('SELECT joueur FROM titulaires_reels WHERE match_id = ?');
    $r->bind_param('i', $match_id);
    $r->execute();
    $r->bind_result($nom);
    while ($r->fetch()) $reels[] = $nom;
    $r->close();
    if (count($reels) !== 11) continue; // Pas de compo réelle, on saute
    // Pour chaque utilisateur ayant pronostiqué ce match (même s'il n'a pas saisi ses titulaires)
    $users_pred = $mysqli->prepare('SELECT DISTINCT user_id FROM Predictions WHERE match_id = ?');
    $users_pred->bind_param('i', $match_id);
    $users_pred->execute();
    $result_users = $users_pred->get_result();
    while ($u = $result_users->fetch_assoc()) {
        $user_id = $u['user_id'];
        $pronos = [];
        $p = $mysqli->prepare('SELECT joueur FROM titulaires WHERE user_id = ? AND match_id = ?');
        $p->bind_param('ii', $user_id, $match_id);
        $p->execute();
        $p->bind_result($j);
        while ($p->fetch()) $pronos[] = $j;
        $p->close();
        
        // Si l'utilisateur n'a pas saisi ses 11 titulaires, mettre 0
        if (count($pronos) !== 11) {
            $pts = 0;
        } else {
            $pts = count(array_intersect($pronos, $reels)) * 2; // 2 points par joueur correct
        }
        
        // Met à jour ou crée l'entrée dans match_points avec titulaire_11
        $stmt = $mysqli->prepare('INSERT INTO match_points (user_id, match_id, titulaire_11) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE titulaire_11 = VALUES(titulaire_11)');
        $stmt->bind_param('iii', $user_id, $match_id, $pts);
        $stmt->execute();
        $stmt->close();
    }
    $users_pred->close();
} 