<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';
if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}
try {
    $result = $mysqli->query('SELECT * FROM Matches ORDER BY phase ASC, match_date ASC');
    $matches = [];
    while ($row = $result->fetch_assoc()) {
        $matches[] = $row;
    }
    $result->close();
    if(!$matches) {
        echo json_encode(['success' => true, 'html' => '<div class="alert alert-info">Aucun match enregistré.</div>']);
        exit;
    }
    // Grouper par phase
    $grouped = [];
    $flags = [
        'Maroc' => 'ma', 'Mali' => 'ml', 'Zambie' => 'zm', 'Comores' => 'km',
        'Égypte' => 'eg', 'Afrique du Sud' => 'za', 'Angola' => 'ao', 'Zimbabwe' => 'zw',
        'Nigeria' => 'ng', 'Tunisie' => 'tn', 'Ouganda' => 'ug', 'Tanzanie' => 'tz',
        'Sénégal' => 'sn', 'RD Congo' => 'cd', 'Bénin' => 'bj', 'Botswana' => 'bw',
        'Algérie' => 'dz', 'Burkina Faso' => 'bf', 'Guinée Équatoriale' => 'gq', 'Soudan' => 'sd',
        "Côte d'Ivoire" => 'ci', 'Cameroun' => 'cm', 'Gabon' => 'ga', 'Mozambique' => 'mz'
    ];
    foreach($matches as $m) {
        $phase = $m['phase'] ?? 'Phase de groupes';
        $grouped[$phase][] = $m;
    }
    // Définir l'ordre logique des phases
    $phases_order = [
        "Phase de groupes · Journée 1 sur 3",
        "Phase de groupes · Journée 2 sur 3",
        "Phase de groupes · Journée 3 sur 3",
        "8e de finale",
        "Quart de finale",
        "Demi-finale",
        "Match pour la 3e place",
        "Finale"
    ];
    $phases_sorted = array_keys($grouped);
    usort($phases_sorted, function($a, $b) use ($phases_order) {
        $ia = array_search($a, $phases_order);
        $ib = array_search($b, $phases_order);
        if ($ia === false) $ia = 999;
        if ($ib === false) $ib = 999;
        if ($ia === $ib) return strcmp($a, $b);
        return $ia - $ib;
    });
    // Générer les onglets pour chaque phase
    $html = '<ul class="nav nav-tabs mb-4" id="phaseTabs" role="tablist">';
    $first = true;
    foreach($phases_sorted as $phase) {
        $phase_id = 'phase-' . md5($phase);
        $active_class = $first ? ' active' : '';
        $aria_selected = $first ? 'true' : 'false';
        $html .= '<li class="nav-item" role="presentation">';
        $html .= '<button class="nav-link' . $active_class . '" id="' . $phase_id . '-tab" data-bs-toggle="tab" data-bs-target="#' . $phase_id . '" type="button" role="tab" aria-selected="' . $aria_selected . '">';
        $html .= htmlspecialchars($phase ?? '');
        $html .= '</button></li>';
        $first = false;
    }
    $html .= '</ul>';
    // Générer le contenu des onglets
    $html .= '<div class="tab-content" id="phaseTabsContent">';
    $first = true;
    foreach($phases_sorted as $phase) {
        $phaseMatches = $grouped[$phase];
        $phase_id = 'phase-' . md5($phase);
        $active_class = $first ? ' show active' : '';
        
        $html .= '<div class="tab-pane fade' . $active_class . '" id="' . $phase_id . '" role="tabpanel">';
        
        // Table desktop
        $html .= '<div class="d-none d-md-block">';
        $html .= '<table class="table align-middle table-bordered table-striped bg-white"><thead class="table-dark"><tr><th>Date</th><th>Équipe 1</th><th></th><th>Score</th><th></th><th>Équipe 2</th><th>Status</th><th>Actions</th></tr></thead><tbody>';
        foreach($phaseMatches as $m) {
            $flag1 = $flags[$m['team_1']] ?? 'un';
            $flag2 = $flags[$m['team_2']] ?? 'un';
            $date = date('d/m/Y H:i', strtotime($m['match_date']));
            $html .= '<tr>';
            $html .= '<td>'.$date.'</td>';
            $html .= '<td><img src="https://flagcdn.com/24x18/'.$flag1.'.png" class="me-2">'.htmlspecialchars($m['team_1'] ?? '').'</td>';
            $html .= '<td class="text-end">';
            $html .= '</td>';
            $html .= '<td style="min-width:120px;">';
            $html .= '<input type="number" min="0" max="20" class="form-control d-inline-block" style="width:60px;" id="score1_'.$m['id'].'" value="'.($m['result_team_1'] ?? '').'"> - ';
            $html .= '<input type="number" min="0" max="20" class="form-control d-inline-block" style="width:60px;" id="score2_'.$m['id'].'" value="'.($m['result_team_2'] ?? '').'">';
            $html .= '</td>';
            $html .= '<td class="text-start">';
            $html .= '</td>';
            $html .= '<td><img src="https://flagcdn.com/24x18/'.$flag2.'.png" class="me-2">'.htmlspecialchars($m['team_2'] ?? '').'</td>';
            $html .= '<td>'.htmlspecialchars($m['status'] ?? '').'</td>';
            $html .= '<td>';
            $html .= '<button class="btn btn-sm btn-warning edit-match-btn me-2" data-match="'.$m['id'].'" data-team1="'.htmlspecialchars($m['team_1']).'" data-team2="'.htmlspecialchars($m['team_2']).'" data-date="'.date('Y-m-d\TH:i', strtotime($m['match_date'])).'" data-phase="'.htmlspecialchars($m['phase'] ?? '').'" title="Modifier le match"><i class="fas fa-edit"></i></button>';
            $html .= '<button class="btn btn-sm btn-primary set-result-btn me-2" data-match="'.$m['id'].'" title="Enregistrer le score"><i class="fas fa-save"></i></button>';
            $html .= '<button class="btn btn-sm btn-danger delete-match-btn" data-match="'.$m['id'].'" data-team1="'.htmlspecialchars($m['team_1']).'" data-team2="'.htmlspecialchars($m['team_2']).'" data-date="'.$date.'" title="Supprimer le match"><i class="fas fa-trash"></i></button>';
            $html .= '</td>';
            $html .= '</tr>';
        }
        $html .= '</tbody></table></div>';

        // Cartes mobile
        $html .= '<div class="d-md-none">';
        foreach($phaseMatches as $m) {
            $flag1 = $flags[$m['team_1']] ?? 'un';
            $flag2 = $flags[$m['team_2']] ?? 'un';
            $date = date('d/m/Y H:i', strtotime($m['match_date']));
            $html .= '<div class="admin-match-card">';
            $html .= '<div class="admin-match-header">'.$date.'</div>';
            $html .= '<div class="admin-match-teams">';
            $html .= '<span class="admin-match-team"><img src="https://flagcdn.com/40x30/'.$flag1.'.png" alt="'.htmlspecialchars($m['team_1'] ?? '').'">'.htmlspecialchars($m['team_1'] ?? '').'</span>';
            $html .= '<span class="admin-match-score">'
                .'<input type="number" min="0" max="20" class="form-control d-inline-block text-center" name="score1_'.$m['id'].'" style="width:38px;display:inline-block;" id="mobilescore1_'.$m['id'].'" value="'.($m['result_team_1'] ?? '').'">'
                .' - '
                .'<input type="number" min="0" max="20" class="form-control d-inline-block text-center" name="score2_'.$m['id'].'" style="width:38px;display:inline-block;" id="mobilescore2_'.$m['id'].'" value="'.($m['result_team_2'] ?? '').'">'
            .'</span>';
            $html .= '<span class="admin-match-team"><img src="https://flagcdn.com/40x30/'.$flag2.'.png" alt="'.htmlspecialchars($m['team_2'] ?? '').'">'.htmlspecialchars($m['team_2'] ?? '').'</span>';
            $html .= '</div>';
            $status = htmlspecialchars($m['status'] ?? '');
            $badge = $status === 'completed' ? 'completed' : ($status === 'upcoming' ? 'upcoming' : $status);
            $html .= '<div class="admin-match-status">'.$badge.'</div>';
            $html .= '<div class="admin-match-actions">';
            $html .= '<button class="btn btn-warning admin-match-btn edit-match-btn me-2" data-match="'.$m['id'].'" data-team1="'.htmlspecialchars($m['team_1']).'" data-team2="'.htmlspecialchars($m['team_2']).'" data-date="'.date('Y-m-d\TH:i', strtotime($m['match_date'])).'" data-phase="'.htmlspecialchars($m['phase'] ?? '').'" title="Modifier le match"><i class="fas fa-edit"></i></button>';
            $html .= '<button class="btn btn-primary admin-match-btn set-result-btn me-2" data-match="'.$m['id'].'" title="Enregistrer le score"><i class="fas fa-save"></i></button>';
            $html .= '<button class="btn btn-danger admin-match-btn delete-match-btn" data-match="'.$m['id'].'" data-team1="'.htmlspecialchars($m['team_1']).'" data-team2="'.htmlspecialchars($m['team_2']).'" data-date="'.$date.'" title="Supprimer le match"><i class="fas fa-trash"></i></button>';
            $html .= '</div>';
            $html .= '</div>';
        }
        $html .= '</div>';
        $html .= '</div>'; // Fin du tab-pane
        $first = false;
    }
    $html .= '</div>'; // Fin du tab-content
    $html .= '<script>$(function(){
      // Les onglets Bootstrap gèrent automatiquement l\'affichage
      $(document).off("click", ".set-result-btn").on("click", ".set-result-btn", function() {
        var match_id = $(this).data("match");
        var score1, score2;
        if ($(window).width() < 768) {
          // Mobile
          score1 = $("#mobilescore1_"+match_id).val();
          score2 = $("#mobilescore2_"+match_id).val();
        } else {
          // Desktop
          score1 = $("#score1_"+match_id).val();
          score2 = $("#score2_"+match_id).val();
        }
        $.ajax({
          url: "../ajax/set_result.php",
          method: "POST",
          data: {match_id: match_id, result_team_1: score1, result_team_2: score2},
          dataType: "json",
          success: function(data) {
            if(data.success) {
              Swal.fire({icon: "success", title: "Succès", text: "Score enregistré !"});
            } else {
              Swal.fire({icon: "error", title: "Erreur", text: data.message});
            }
          }
        });
      });
      
      // Gestion de la suppression des matchs
      $(document).off("click", ".delete-match-btn").on("click", ".delete-match-btn", function() {
        var match_id = $(this).data("match");
        var team1 = $(this).data("team1");
        var team2 = $(this).data("team2");
        var date = $(this).data("date");
        
        Swal.fire({
          title: "Confirmer la suppression",
          html: `Êtes-vous sûr de vouloir supprimer le match :<br><strong>${team1} vs ${team2}</strong><br>Date : ${date}`,
          icon: "warning",
          showCancelButton: true,
          confirmButtonColor: "#d33",
          cancelButtonColor: "#3085d6",
          confirmButtonText: "Oui, supprimer",
          cancelButtonText: "Annuler"
        }).then((result) => {
          if (result.isConfirmed) {
            $.ajax({
              url: "../ajax/delete_match.php",
              method: "POST",
              data: {match_id: match_id},
              dataType: "json",
              success: function(data) {
                if(data.success) {
                  Swal.fire({
                    icon: "success",
                    title: "Succès",
                    text: "Match supprimé avec succès !"
                  }).then(() => {
                    // Recharger la liste des matchs
                    location.reload();
                  });
                } else {
                  Swal.fire({
                    icon: "error",
                    title: "Erreur",
                    text: data.message
                  });
                }
              },
              error: function() {
                Swal.fire({
                  icon: "error",
                  title: "Erreur",
                  text: "Une erreur est survenue lors de la suppression."
                });
              }
            });
          }
        });
      });
    });</script>';
    echo json_encode(['success' => true, 'html' => $html]);
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de la récupération.']);
} 