<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';

// Utiliser dirname pour obtenir le chemin actuel et ajouter "../" pour revenir au répertoire parent
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

// Maintenant, vous utilisez ../ pour revenir d'un dossier en arrière
$redirectUrl = $base . '/../home.php';

$email = trim($_POST['email'] ?? '');
$password = $_POST['password'] ?? '';
$username = $_POST['username'] ?? '';

if (!$email || !$password) {
    echo json_encode(['success' => false, 'message' => 'Tous les champs sont obligatoires.']);
    exit;
}

try {
    // Vérifier si le champ is_blocked existe
    $checkColumn = $mysqli->query("SHOW COLUMNS FROM Users LIKE 'is_blocked'");
    $hasIsBlocked = $checkColumn->num_rows > 0;
    
    $sql = 'SELECT * FROM Users WHERE email = ?';
    $stmt = $mysqli->prepare($sql);
    $stmt->bind_param('s', $email);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();
    $stmt->close();

    if ($user && password_verify($password, $user['password'])) {
        // Vérifier si l'utilisateur est bloqué
        if ($hasIsBlocked) {
            // Si le champ existe mais n'est pas dans le résultat, le récupérer séparément
            if (!isset($user['is_blocked'])) {
                $checkStmt = $mysqli->prepare('SELECT is_blocked FROM Users WHERE id = ?');
                $checkStmt->bind_param('i', $user['id']);
                $checkStmt->execute();
                $checkResult = $checkStmt->get_result();
                $blockData = $checkResult->fetch_assoc();
                $checkStmt->close();
                $user['is_blocked'] = $blockData['is_blocked'] ?? 0;
            }
            
            // Vérifier si l'utilisateur est bloqué (1 ou true)
            if (isset($user['is_blocked']) && ($user['is_blocked'] == 1 || $user['is_blocked'] === true)) {
                echo json_encode(['success' => false, 'message' => 'Votre compte a été bloqué. Veuillez contacter l\'administrateur.']);
                exit;
            }
        }
        
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role'];

        // Enregistrer la connexion dans la table user_logins
        try {
            // Vérifier si la table existe, sinon la créer
            $tableCheck = $mysqli->query("SHOW TABLES LIKE 'user_logins'");
            if ($tableCheck->num_rows == 0) {
                // Créer la table sans contrainte de clé étrangère pour éviter les erreurs
                $mysqli->query("CREATE TABLE IF NOT EXISTS user_logins (
                    id INT AUTO_INCREMENT PRIMARY KEY,
                    user_id INT NOT NULL,
                    login_date DATETIME NOT NULL,
                    INDEX idx_user_id (user_id),
                    INDEX idx_login_date (login_date)
                ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4");
            }
            
            // Enregistrer la connexion
            $loginStmt = $mysqli->prepare('INSERT INTO user_logins (user_id, login_date) VALUES (?, NOW())');
            $loginStmt->bind_param('i', $user['id']);
            $loginStmt->execute();
            $loginStmt->close();
        } catch (Exception $e) {
            // Ignorer les erreurs d'enregistrement de connexion pour ne pas bloquer le login
            error_log('Erreur enregistrement connexion: ' . $e->getMessage());
        }

        // Redirection selon le rôle
        if ($user['role'] === 'admin' || $user['role'] === 'stat') {
            $redirectUrl = $base . '/../admin/dashboard.php';
        } else {
            $redirectUrl = $base . '/../home.php';
        }

        // Redirection avec le chemin corrigé
        echo json_encode(['success' => true, 'redirect' => $redirectUrl]);
    } else {
        echo json_encode(['success' => false, 'message' => 'Identifiants invalides.']);
    }
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur.']);
}
