<?php
session_start();

// Si un quiz est en cours, le sauvegarder automatiquement
if (isset($_SESSION['quiz_started']) && isset($_SESSION['user_id']) && isset($_SESSION['quiz_phase'])) {
    require_once '../includes/db.php';
    
    $user_id = $_SESSION['user_id'];
    $phase = $_SESSION['quiz_phase'];
    $current_lang = $_SESSION['language'] ?? 'fr';
    
    // Calculer le score actuel avec la même logique que validate_quiz_answer.php
    $score = 0;
    if (isset($_SESSION['quiz_answers']) && is_array($_SESSION['quiz_answers'])) {
        foreach ($_SESSION['quiz_answers'] as $qid => $user_answer) {
            $is_correct = false;
            
            // Vérifier dans les deux tables (français et arabe)
            $tables_to_check = ['quizz_questions', 'quizz_questions_ar'];
            
            foreach ($tables_to_check as $table) {
                $stmt = $mysqli->prepare("SELECT answer, option1, option2, option3, option4 FROM {$table} WHERE id = ?");
                if ($stmt) {
                    $stmt->bind_param('i', $qid);
                    $stmt->execute();
                    $result = $stmt->get_result();
                    $q = $result->fetch_assoc();
                    $stmt->close();
                    
                    if ($q) {
                        $correct_text = '';
                        
                        // Vérifier si c'est une lettre (A, B, C, D) ou du texte direct
                        if (in_array($q['answer'], ['A', 'B', 'C', 'D'])) {
                            switch($q['answer']) {
                                case 'A': $correct_text = $q['option1']; break;
                                case 'B': $correct_text = $q['option2']; break;
                                case 'C': $correct_text = $q['option3']; break;
                                case 'D': $correct_text = $q['option4']; break;
                            }
                        } else {
                            // C'est déjà du texte direct
                            $correct_text = $q['answer'];
                        }
                        
                        // Comparaison avec trim pour être cohérent avec la validation
                        if (trim($user_answer) === trim($correct_text)) {
                            $is_correct = true;
                            break; // Réponse trouvée, pas besoin de vérifier l'autre table
                        }
                    }
                }
            }
            
            if ($is_correct) {
                $score += 2; // 2 points par bonne réponse (comme dans validate_quiz_answer.php)
            }
        }
    }
    
    // Si la phase était "Match pour la 3e place", sauvegarder sous "Finale" (car combinées)
    $phase_for_db = $phase;
    if ($phase_for_db === 'Match pour la 3e place') {
        $phase_for_db = 'Finale';
    }
    
    // Vérifier le score actuel en base de données pour s'assurer qu'on utilise le bon score
    $stmt = $mysqli->prepare('SELECT score FROM quizz_results_phases WHERE user_id = ? AND phase = ?');
    $stmt->bind_param('is', $user_id, $phase_for_db);
    $stmt->execute();
    $result = $stmt->get_result();
    $db_row = $result->fetch_assoc();
    $stmt->close();
    
    // Utiliser le score calculé depuis la session (score actuel réel)
    // Si le score calculé est différent de celui en base, utiliser le score calculé
    // Cela garantit que le score sauvegardé correspond aux réponses actuelles
    $final_score = $score; // Score calculé depuis les réponses de la session
    
    // Terminer le quiz et verrouiller avec le score actuel calculé
    $stmt = $mysqli->prepare('UPDATE quizz_results_phases SET score = ?, completed_at = UTC_TIMESTAMP(), locked = 1 WHERE user_id = ? AND phase = ?');
    $stmt->bind_param('iis', $final_score, $user_id, $phase_for_db);
    $stmt->execute();
    $stmt->close();

    // Supprimer le timer de session
    $stmt = $mysqli->prepare('DELETE FROM quiz_timer_sessions WHERE user_id = ? AND phase = ?');
    $stmt->bind_param('is', $user_id, $phase_for_db);
    $stmt->execute();
    $stmt->close();
}

session_unset();
session_destroy();
header('Content-Type: application/json');
echo json_encode(['success' => true]); 