<?php
header('Content-Type: application/json');
require_once '../includes/db.php';
require_once '../includes/email.php';
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\');

$username = trim($_POST['username'] ?? '');
$email = trim($_POST['email'] ?? '');
$site = trim($_POST['site'] ?? 'Jorf'); // Default site
$ville = trim($_POST['ville'] ?? '');
$departement = trim($_POST['departement'] ?? '');

// Validation des champs obligatoires
if(!$username || !$email) {
    echo json_encode(['success' => false, 'message' => 'Nom & Prénom et email sont obligatoires.']);
    exit;
}

// Validation du format email
if(!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Format d\'email invalide.']);
    exit;
}

// Validation que l'email est un email BNP Paribas
if(!isValidBNPEmail($email)) {
    echo json_encode(['success' => false, 'message' => 'Seuls les emails @bnpparibas.com ou @externe.bnpparibas.com sont autorisés.']);
    exit;
}

// Générer un mot de passe aléatoire
$generatedPassword = generateRandomPassword(12);
$hash = password_hash($generatedPassword, PASSWORD_DEFAULT);

try {
    // Vérifier si l'email existe déjà
    $checkStmt = $mysqli->prepare('SELECT id FROM Users WHERE email = ?');
    $checkStmt->bind_param('s', $email);
    $checkStmt->execute();
    $checkResult = $checkStmt->get_result();
    
    if ($checkResult->num_rows > 0) {
        echo json_encode(['success' => false, 'message' => 'Cet email est déjà utilisé.']);
        $checkStmt->close();
        exit;
    }
    $checkStmt->close();
    
    // Insérer le nouvel utilisateur
    $stmt = $mysqli->prepare('INSERT INTO Users (username, email, password, site, ville, departement) VALUES (?, ?, ?, ?, ?, ?)');
    $stmt->bind_param('ssssss', $username, $email, $hash, $site, $ville, $departement);
    
    if ($stmt->execute()) {
        // Envoyer l'email avec le mot de passe
        $emailSent = sendPasswordEmail($email, $username, $generatedPassword);
        
        if ($emailSent) {
            echo json_encode([
                'success' => true, 
                'redirect' => $base . '/../welcome.php?registered=1', 
                'message' => 'Inscription réussie ! Un email avec votre mot de passe vous a été envoyé. Veuillez vérifier votre boîte de réception.'
            ]);
        } else {
            // Si l'email n'a pas pu être envoyé, on affiche quand même le mot de passe
            // Dans un environnement de production, vous devriez gérer cela différemment
            echo json_encode([
                'success' => true,
                'redirect' => $base . '/../welcome.php?registered=1',
                'message' => 'Inscription réussie ! Votre mot de passe temporaire est : ' . $generatedPassword . ' (Conservez-le précieusement)',
                'show_password' => true,
                'password' => $generatedPassword
            ]);
        }
    } else {
        if ($stmt->errno == 1062) {
            echo json_encode(['success' => false, 'message' => 'Email déjà utilisé.']);
        } else {
            echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'inscription.']);
        }
    }
    $stmt->close();
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur : ' . $e->getMessage()]);
} 