<?php
date_default_timezone_set('Africa/Casablanca');
session_start();
require '../includes/db.php';

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false]);
    exit;
}

$user_id = $_SESSION['user_id'];
$groupe = $_POST['groupe'];
$classement = $_POST['classement'];

// Vérifier la deadline pour les pronostics de groupes
$groupes_deadline_file = __DIR__.'/../includes/groupes_deadline.txt';
if (file_exists($groupes_deadline_file)) {
    $groupes_deadline = trim(file_get_contents($groupes_deadline_file));
    if (!empty($groupes_deadline) && date('Y-m-d H:i:s') >= $groupes_deadline) {
        echo json_encode(['success' => false, 'message' => 'Les pronostics de groupes sont fermés.']);
        exit;
    }
}

// Conversion éventuelle des codes 2 lettres en 3 lettres
$map2to3 = [
  'MA'=>'MAR','ML'=>'MAL','ZM'=>'ZAM','KM'=>'COM',
  'EG'=>'EGY','ZA'=>'RSA','AO'=>'ANG','ZW'=>'ZIM',
  'NG'=>'NGA','TN'=>'TUN','UG'=>'UGA','TZ'=>'TAN',
  'SN'=>'SEN','CD'=>'COD','BJ'=>'BEN','BW'=>'BOT',
  'DZ'=>'ALG','BF'=>'BFA','GQ'=>'EQG','SD'=>'SUD',
  'CI'=>'CIV','CM'=>'CMR','GA'=>'GAB','MZ'=>'MOZ'
];
$codes = explode(',', $classement);
foreach ($codes as &$c) {
    if (isset($map2to3[$c])) $c = $map2to3[$c];
}
$classement = implode(',', $codes);

$stmt = $mysqli->prepare("INSERT INTO groupe_predictions (user_id, groupe, classement) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE classement = VALUES(classement), created_at = NOW()");
$stmt->bind_param('iss', $user_id, $groupe, $classement);
$stmt->execute();
$stmt->close();
echo json_encode(['success' => true]); 