<?php
date_default_timezone_set('Etc/GMT-1');
session_start();
require_once '../includes/db.php';
if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}
$user_id = $_SESSION['user_id'];
$match_id = intval($_POST['match_id'] ?? 0);
$joueurs = $_POST['joueurs'] ?? [];
if (!$match_id || count($joueurs) !== 11) {
    echo json_encode(['success' => false, 'message' => 'Vous devez sélectionner 11 joueurs.']);
    exit;
}

// Vérifier si le match est dans moins de 2 heures
$stmt = $mysqli->prepare('SELECT match_date FROM Matches WHERE id = ?');
$stmt->bind_param('i', $match_id);
$stmt->execute();
$result = $stmt->get_result();
$match = $result->fetch_assoc();
$stmt->close();

if (!$match) {
    echo json_encode(['success' => false, 'message' => 'Match non trouvé.']);
    exit;
}

$match_time = strtotime($match['match_date']);
$deadline_titulaires = $match_time - 2*3600; // 2 heures avant le match
$now = time();

if ($now >= $deadline_titulaires) {
    echo json_encode(['success' => false, 'message' => 'La sélection des titulaires est fermée. Elle se ferme 2 heures avant le match.']);
    exit;
}
$stmt = $mysqli->prepare('DELETE FROM titulaires WHERE user_id = ? AND match_id = ?');
$stmt->bind_param('ii', $user_id, $match_id);
$stmt->execute();
$stmt->close();
foreach ($joueurs as $id_joueur) {
    $stmt = $mysqli->prepare('SELECT nom, poste FROM joueurs_maroc WHERE id = ?');
    $stmt->bind_param('i', $id_joueur);
    $stmt->execute();
    $stmt->bind_result($nom, $poste);
    if ($stmt->fetch()) {
        $stmt->close();
        $stmt2 = $mysqli->prepare('INSERT INTO titulaires (user_id, match_id, joueur, poste) VALUES (?, ?, ?, ?)');
        $stmt2->bind_param('iiss', $user_id, $match_id, $nom, $poste);
        $stmt2->execute();
        $stmt2->close();
    } else {
        $stmt->close();
    }
}
echo json_encode(['success' => true]); 