<?php
date_default_timezone_set('Africa/Casablanca');
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}
$user_id = $_SESSION['user_id'];
$team = $_POST['team'] ?? '';
if (!$team) {
    echo json_encode(['success' => false, 'message' => 'Aucune équipe sélectionnée.']);
    exit;
}

// Vérifier la deadline
$winner_deadline_file = __DIR__.'/../includes/winner_deadline.txt';
if (file_exists($winner_deadline_file)) {
    $winner_deadline = trim(file_get_contents($winner_deadline_file));
    if (!empty($winner_deadline) && date('Y-m-d H:i:s') >= $winner_deadline) {
        echo json_encode(['success' => false, 'message' => 'Pronostics fermés.']);
        exit;
    }
}

// Enregistrer ou mettre à jour le pronostic
$stmt = $mysqli->prepare('INSERT INTO winner_predictions (user_id, team) VALUES (?, ?) ON DUPLICATE KEY UPDATE team = VALUES(team), created_at = NOW()');
$stmt->bind_param('is', $user_id, $team);
$stmt->execute();
$stmt->close();
echo json_encode(['success' => true]); 