<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';
if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}
$match_id = intval($_POST['match_id'] ?? 0);
$result_team_1 = $_POST['result_team_1'] ?? null;
$result_team_2 = $_POST['result_team_2'] ?? null;
if(!$match_id || $result_team_1 === null || $result_team_2 === null) {
    echo json_encode(['success' => false, 'message' => 'Données incomplètes.']);
    exit;
}
try {
    $stmt = $mysqli->prepare('UPDATE Matches SET result_team_1 = ?, result_team_2 = ?, status = "completed" WHERE id = ?');
    $stmt->bind_param('iii', $result_team_1, $result_team_2, $match_id);
    $stmt->execute();
    $stmt->close();

    // Charger la config des points
    $points_score_exact = file_exists('../includes/points_score_exact.txt') ? intval(trim(file_get_contents('../includes/points_score_exact.txt'))) : 10;
    $points_bon_vainqueur = file_exists('../includes/points_bon_vainqueur.txt') ? intval(trim(file_get_contents('../includes/points_bon_vainqueur.txt'))) : 5;
    $points_bonus_both = file_exists('../includes/points_bonus_both.txt') ? intval(trim(file_get_contents('../includes/points_bonus_both.txt'))) : 15;

    // Récupérer tous les pronostics pour ce match
    $stmt = $mysqli->prepare('SELECT * FROM Predictions WHERE match_id = ?');
    $stmt->bind_param('i', $match_id);
    $stmt->execute();
    $result = $stmt->get_result();
    $predictions = [];
    while ($row = $result->fetch_assoc()) {
        $predictions[] = $row;
    }
    $stmt->close();

    // Récupérer le score réel
    $score1 = intval($result_team_1);
    $score2 = intval($result_team_2);
    $winner = ($score1 === $score2) ? 'draw' : (($score1 > $score2) ? 'team1' : 'team2');

    foreach ($predictions as $pred) {
        $pts = 0;
        $p1 = intval($pred['predicted_team_1']);
        $p2 = intval($pred['predicted_team_2']);
        $pred_winner = ($p1 === $p2) ? 'draw' : (($p1 > $p2) ? 'team1' : 'team2');
        $score_exact = ($p1 === $score1 && $p2 === $score2);
        $bon_vainqueur = ($pred_winner === $winner && $winner !== 'draw');
        $is_draw = ($winner === 'draw');
        if ($is_draw && $pred_winner === 'draw') {
            // Egalité trouvée (peu importe le score)
            $pts += $points_bon_vainqueur;
            if ($score_exact) {
                $pts += $points_score_exact;
            }
        } else {
            if ($score_exact) {
                $pts += $points_score_exact;
            }
            if ($bon_vainqueur) {
                $pts += $points_bon_vainqueur;
            }
        }
        // Stocker les points dans une table (ex: match_points)
        $stmt2 = $mysqli->prepare('INSERT INTO match_points (user_id, match_id, points) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE points = VALUES(points)');
        $stmt2->bind_param('iii', $pred['user_id'], $match_id, $pts);
        $stmt2->execute();
        $stmt2->close();
    }
    
    // Recalculer les points des 11 titulaires si c'est un match du Maroc
    $stmt_match = $mysqli->prepare('SELECT team_1, team_2 FROM Matches WHERE id = ?');
    $stmt_match->bind_param('i', $match_id);
    $stmt_match->execute();
    $result_match = $stmt_match->get_result();
    $match_info = $result_match->fetch_assoc();
    $stmt_match->close();
    
    if ($match_info && ($match_info['team_1'] === 'Maroc' || $match_info['team_2'] === 'Maroc')) {
        // Récupérer la compo réelle pour ce match
        $reels = [];
        $r = $mysqli->prepare('SELECT joueur FROM titulaires_reels WHERE match_id = ?');
        $r->bind_param('i', $match_id);
        $r->execute();
        $r->bind_result($nom);
        while ($r->fetch()) $reels[] = $nom;
        $r->close();
        
        if (count($reels) === 11) {
            // Pour chaque utilisateur ayant pronostiqué ce match (même s'il n'a pas saisi ses titulaires)
            foreach ($predictions as $pred) {
                $user_id = $pred['user_id'];
                $pronos = [];
                $p = $mysqli->prepare('SELECT joueur FROM titulaires WHERE user_id = ? AND match_id = ?');
                $p->bind_param('ii', $user_id, $match_id);
                $p->execute();
                $p->bind_result($j);
                while ($p->fetch()) $pronos[] = $j;
                $p->close();
                
                // Si l'utilisateur n'a pas saisi ses 11 titulaires, mettre 0
                if (count($pronos) !== 11) {
                    $pts = 0;
                } else {
                    $pts = count(array_intersect($pronos, $reels)) * 2; // 2 points par joueur correct
                }
                
                // Met à jour ou crée l'entrée dans match_points avec titulaire_11
                $stmt = $mysqli->prepare('INSERT INTO match_points (user_id, match_id, titulaire_11) VALUES (?, ?, ?) ON DUPLICATE KEY UPDATE titulaire_11 = VALUES(titulaire_11)');
                $stmt->bind_param('iii', $user_id, $match_id, $pts);
                $stmt->execute();
                $stmt->close();
            }
        }
    }
    
    echo json_encode(['success' => true]);
} catch(PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de l\'enregistrement.']);
} 