<?php
header('Content-Type: application/json');
session_start();
require_once '../includes/db.php';

if(!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    echo json_encode(['success' => false, 'message' => 'Non autorisé.']);
    exit;
}

$action = $_POST['action'] ?? '';
$value = $_POST['value'] ?? '';

if(empty($action) || empty($value)) {
    echo json_encode(['success' => false, 'message' => 'Paramètres manquants.']);
    exit;
}

try {
    switch($action) {
        case 'prediction_deadline':
            $deadline_file = __DIR__.'/../includes/prediction_deadline.txt';
            file_put_contents($deadline_file, $value);
            echo json_encode(['success' => true, 'message' => 'Date limite mise à jour.']);
            break;
            
        case 'groupes_deadline':
            $groupes_deadline_file = __DIR__.'/../includes/groupes_deadline.txt';
            file_put_contents($groupes_deadline_file, $value);
            echo json_encode(['success' => true, 'message' => 'Date limite des groupes mise à jour.']);
            break;
            
        case 'match_deadline_hours':
            $match_deadline_hours_file = __DIR__.'/../includes/match_deadline_hours.txt';
            file_put_contents($match_deadline_hours_file, $value);
            echo json_encode(['success' => true, 'message' => 'Délai de clôture des pronostics de matchs mis à jour.']);
            break;
            
        case 'match_deadline':
            $match_deadline_file = __DIR__.'/../includes/match_deadline.txt';
            file_put_contents($match_deadline_file, $value);
            echo json_encode(['success' => true, 'message' => 'Date limite des matchs mise à jour.']);
            break;
            
        case 'phase_to_show':
            $phase_file = __DIR__.'/../includes/phase_dashboard.txt';
            file_put_contents($phase_file, $value);
            echo json_encode(['success' => true, 'message' => 'Phase affichée mise à jour.']);
            break;
            
        default:
            echo json_encode(['success' => false, 'message' => 'Action non reconnue.']);
            break;
    }
} catch(Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour.']);
}
?> 