<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit;
}

require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];
$username = trim($_POST['username'] ?? '');
$email = trim($_POST['email'] ?? '');
$ville = trim($_POST['ville'] ?? '');
$departement = trim($_POST['departement'] ?? '');

if (!$username || !$email) {
    echo json_encode(['success' => false, 'message' => 'Nom d\'utilisateur et email requis']);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    echo json_encode(['success' => false, 'message' => 'Email invalide']);
    exit;
}

try {
    // Vérifier si l'email est déjà utilisé par un autre utilisateur
    $stmt = $mysqli->prepare("SELECT id FROM Users WHERE email = ? AND id != ?");
    $stmt->bind_param('si', $email, $user_id);
    $stmt->execute();
    $result = $stmt->get_result();
    
    if ($result->num_rows > 0) {
        echo json_encode(['success' => false, 'message' => 'Email déjà utilisé']);
        exit;
    }
    $stmt->close();
    
    // Mettre à jour le profil
    $stmt = $mysqli->prepare("UPDATE Users SET username = ?, email = ?, ville = ?, departement = ? WHERE id = ?");
    $stmt->bind_param('ssssi', $username, $email, $ville, $departement, $user_id);
    
    if ($stmt->execute()) {
        // Mettre à jour la session si le nom d'utilisateur a changé
        if ($_SESSION['username'] !== $username) {
            $_SESSION['username'] = $username;
            echo json_encode(['success' => true, 'new_username' => $username]);
        } else {
            echo json_encode(['success' => true]);
        }
    } else {
        echo json_encode(['success' => false, 'message' => 'Erreur lors de la mise à jour']);
    }
    $stmt->close();
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erreur serveur']);
}
?>
