<?php
session_start();
header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['success' => false, 'message' => 'Non autorisé']);
    exit;
}

require_once '../includes/db.php';

$user_id = $_SESSION['user_id'];

if (!isset($_FILES['photo']) || $_FILES['photo']['error'] !== UPLOAD_ERR_OK) {
    echo json_encode(['success' => false, 'message' => 'Erreur lors du téléchargement']);
    exit;
}

$file = $_FILES['photo'];
$allowed_types = ['image/jpeg', 'image/png', 'image/gif'];
$max_size = 2 * 1024 * 1024; // 2MB

if (!in_array($file['type'], $allowed_types)) {
    echo json_encode(['success' => false, 'message' => 'Type de fichier non autorisé']);
    exit;
}

if ($file['size'] > $max_size) {
    echo json_encode(['success' => false, 'message' => 'Fichier trop volumineux (max 2MB)']);
    exit;
}

// Créer le dossier upload s'il n'existe pas
$upload_dir = '../assets/img/upload/';
if (!is_dir($upload_dir)) {
    mkdir($upload_dir, 0755, true);
}

// Générer un nom de fichier unique
$extension = pathinfo($file['name'], PATHINFO_EXTENSION);
$filename = 'user_' . $user_id . '_' . time() . '.' . $extension;
$filepath = $upload_dir . $filename;

if (move_uploaded_file($file['tmp_name'], $filepath)) {
    // Mettre à jour la base de données
    $stmt = $mysqli->prepare("UPDATE Users SET photo = ? WHERE id = ?");
    $stmt->bind_param('si', $filename, $user_id);
    
    if ($stmt->execute()) {
        echo json_encode(['success' => true, 'filename' => $filename]);
    } else {
        unlink($filepath); // Supprimer le fichier si la DB échoue
        echo json_encode(['success' => false, 'message' => 'Erreur lors de la sauvegarde']);
    }
    $stmt->close();
} else {
    echo json_encode(['success' => false, 'message' => 'Erreur lors du téléchargement']);
}
?>
