// Chargement de jQuery
// <script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>

$(document).ready(function() {
    // Exemple de notification
    window.showToast = function(message, type = 'success') {
        const toast = `<div class="toast align-items-center text-bg-${type} border-0 show" role="alert" aria-live="assertive" aria-atomic="true">
            <div class="d-flex">
                <div class="toast-body">${message}</div>
                <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast" aria-label="Close"></button>
            </div>
        </div>`;
        $("body").append(toast);
        setTimeout(() => { $(".toast").remove(); }, 4000);
    };
    // TODO: Ajoute ici les handlers AJAX pour login, register, pronostics, etc.

    // Fonction pour mettre le bouton en état validé
    function setButtonValidated($btn) {
        $btn.addClass('btn-validated');
        const validatedText = typeof translations !== 'undefined' && translations.validated ? translations.validated : 'Validé';
        $btn.find('.btn-text-prediction').text(validatedText);
        $btn.find('.btn-check-prediction').show();
    }

    // Fonction pour réinitialiser le bouton
    function resetButton($btn, matchId) {
        $btn.removeClass('btn-validated');
        const modifyText = typeof translations !== 'undefined' && translations.modify_score ? translations.modify_score : 'Modifier score';
        const validateText = typeof translations !== 'undefined' && translations.validate_my_score ? translations.validate_my_score : 'Valider mon score';
        // Vérifier si les champs de saisie ont des valeurs pour déterminer le texte
        const matchBlock = $btn.closest('.match-row, .match-card-mobile');
        const score1Input = matchBlock.find('[name=score_' + matchId + '_1]');
        const score2Input = matchBlock.find('[name=score_' + matchId + '_2]');
        const score1 = score1Input.val();
        const score2 = score2Input.val();
        const hasScores = score1 && score2 && score1 !== '' && score2 !== '';
        $btn.find('.btn-text-prediction').text(hasScores ? modifyText : validateText);
        $btn.find('.btn-check-prediction').hide();
    }

    // Handler AJAX pour enregistrer un pronostic
    $(document).on('click', '.save-prediction', function() {
        var $btn = $(this);
        var matchId = $btn.data('match');
        // Cherche le bloc parent (desktop ou mobile)
        let matchBlock = $(this).closest('.match-row, .match-card-mobile');
        // Si pas trouvé, fallback sur le parent direct
        if (matchBlock.length === 0) matchBlock = $(this).parent();
        const score1Input = matchBlock.find('[name=score_' + matchId + '_1]');
        const score2Input = matchBlock.find('[name=score_' + matchId + '_2]');
        const score1 = parseInt(score1Input.val(), 10);
        const score2 = parseInt(score2Input.val(), 10);
        if (!matchId) {
            alert('Erreur : matchId non trouvé. data-match sur le bouton manquant ou vide.');
            return;
        }
        if (score1Input.length === 0 || score2Input.length === 0) {
            alert('Erreur : input score non trouvé dans le HTML.');
            return;
        }
        if(isNaN(score1) || isNaN(score2)) {
            alert('Erreur : score1 ou score2 non numérique ou vide.');
            showToast('Veuillez saisir les deux scores.', 'danger');
            return;
        }
        $.post(base + '/ajax/save_prediction.php', {
            match_id: matchId,
            predicted_team_1: score1,
            predicted_team_2: score2
        }, function(data) {
            if(data.success) {
                showToast('Pronostic enregistré !', 'success');
                setButtonValidated($btn);
            } else {
                // Vérifier si c'est une erreur d'égalité
                if(data.error_type === 'equality_not_allowed') {
                    showEqualityCorrectionModal(matchId, score1, score2, $btn, data.teams);
                } else {
                    showToast(data.message, 'danger');
                }
            }
        }, 'json');
    });

    // Réinitialiser le bouton quand on clique sur un champ de saisie
    $(document).on('focus', 'input[name^="score_"]', function() {
        const inputName = $(this).attr('name');
        const matchId = inputName.match(/score_(\d+)_[12]/)[1];
        const matchBlock = $(this).closest('.match-row, .match-card-mobile');
        if (matchBlock.length === 0) return;
        const $btn = matchBlock.find('.save-prediction[data-match="' + matchId + '"]');
        if ($btn.length && $btn.hasClass('btn-validated')) {
            resetButton($btn, matchId);
        }
    });

    // Déconnexion utilisateur
    $(document).on('click', '#logoutBtn', function(e) {
        e.preventDefault();
        $.post(base + '/ajax/logout.php', {}, function(data) {
            window.location = base + '/index.php';
        });
    });

    // Enregistrement du score réel (admin)
    $(document).on('click', '.set-result-btn', function() {
        const matchId = $(this).data('match');
        // Cherche d'abord dans le bloc parent admin-match-card (mobile) ou card (desktop)
        let matchBlock = $(this).closest('.admin-match-card, .card');
        // Inputs mobiles
        let score1Input = matchBlock.find('#mobilescore1_' + matchId);
        let score2Input = matchBlock.find('#mobilescore2_' + matchId);
        // Si non trouvé, fallback desktop
        if (score1Input.length === 0) score1Input = matchBlock.find('#score1_' + matchId);
        if (score2Input.length === 0) score2Input = matchBlock.find('#score2_' + matchId);
        // Fallback global si toujours pas trouvé
        if (score1Input.length === 0) score1Input = $('#mobilescore1_' + matchId);
        if (score2Input.length === 0) score2Input = $('#mobilescore2_' + matchId);
        if (score1Input.length === 0) score1Input = $('#score1_' + matchId);
        if (score2Input.length === 0) score2Input = $('#score2_' + matchId);
        // Force le blur pour valider la saisie mobile
        score1Input.blur();
        score2Input.blur();
        const score1 = score1Input.val();
        const score2 = score2Input.val();
        $.post(base + '/ajax/set_result.php', {
            match_id: matchId,
            result_team_1: score1,
            result_team_2: score2
        }, function(data) {
            if(data.success) {
                showToast('Score enregistré !', 'success');
            } else {
                showToast(data.message, 'danger');
            }
        }, 'json');
    });

    function recalculTitulairesPoints(matchId = null) {
        // Si matchId fourni, recalculer pour ce match, sinon pour tous
        if (matchId) {
            $.get('ajax/get_titulaires_list.php', { match_id: matchId, force_recalc: 1 });
        } else {
            // On peut boucler sur tous les boutons .select-titulaires pour tous les matchs affichés
            $('.select-titulaires').each(function() {
                const mid = $(this).data('match');
                if (mid) $.get('ajax/get_titulaires_list.php', { match_id: mid, force_recalc: 1 });
            });
        }
    }

    // Sélection des 11 titulaires Maroc
    $(document).on('click', '.select-titulaires', function() {
        const matchId = $(this).data('match');
        recalculTitulairesPoints(matchId);
        $.get('ajax/get_titulaires_list.php', { match_id: matchId }, function(data) {
            if (data.success) {
                $('#titulairesModalBody').html(data.html);
                // Cacher le header mobile avant d'ouvrir le modal
                $('.header-img-mobile').css('display', 'none');
                $('#titulairesModal').modal('show');
                // Supprime le backdrop Bootstrap si présent
                $('.modal-backdrop').remove();
                updateTitulairesCount();
                $('#saveTitulairesBtn').data('match', matchId);
            } else {
                showToast(data.message, 'danger');
            }
        }, 'json');
    });
    
    // Réafficher le header mobile quand le modal se ferme
    $(document).on('hidden.bs.modal', '#titulairesModal', function() {
        $('.header-img-mobile').css('display', 'block');
    });

    // Gestion de la sélection
    $(document).on('change', '.joueur-checkbox', function() {
        updateTitulairesCount();
    });

    function updateTitulairesCount() {
        const count = $('.joueur-checkbox:checked').length;
        const selectedText = (typeof translations !== 'undefined' && translations.selected) ? translations.selected : 'sélectionnés';
        $('#titulairesCount').text(count + '/11 ' + selectedText);
        $('#saveTitulairesBtn').prop('disabled', count !== 11);
        
        // Bloquer les checkboxes non cochées si on atteint 11 sélections
        if (count >= 11) {
            $('.joueur-checkbox:not(:checked)').prop('disabled', true);
        } else {
            // Réactiver toutes les checkboxes si on est en dessous de 11
            $('.joueur-checkbox').prop('disabled', false);
        }
    }

    // Sauvegarde
    $(document).on('click', '#saveTitulairesBtn', function() {
        const matchId = $(this).data('match');
        const joueurs = $('.joueur-checkbox:checked').map(function(){ return $(this).val(); }).get();
        $.post('ajax/save_titulaires.php', { match_id: matchId, joueurs: joueurs }, function(data) {
            if (data.success) {
                showToast('Titulaires enregistrés !', 'success');
                $('#titulairesModal').modal('hide');
                recalculTitulairesPoints(matchId);
            } else {
                showToast(data.message, 'danger');
            }
        }, 'json');
    });

    // Recalcul au chargement de la page
    recalculTitulairesPoints();

    // Fonction pour obtenir l'URL du flag d'une équipe
    function getTeamFlagUrl(teamName) {
        const flags = {
            'Maroc': 'ma', 'Mali': 'ml', 'Zambie': 'zm', 'Comores': 'km',
            'Égypte': 'eg', 'Afrique du Sud': 'za', 'Angola': 'ao', 'Zimbabwe': 'zw',
            'Nigeria': 'ng', 'Tunisie': 'tn', 'Ouganda': 'ug', 'Tanzanie': 'tz',
            'Sénégal': 'sn', 'RD Congo': 'cd', 'Bénin': 'bj', 'Botswana': 'bw',
            'Algérie': 'dz', 'Burkina Faso': 'bf', 'Guinée Équatoriale': 'gq', 'Soudan': 'sd',
            "Côte d'Ivoire": 'ci', 'Cameroun': 'cm', 'Gabon': 'ga', 'Mozambique': 'mz'
        };
        const code = flags[teamName] || 'un';
        return 'https://flagcdn.com/w40/' + code + '.png';
    }

    // Fonction pour afficher la popup de correction d'égalité
    function showEqualityCorrectionModal(matchId, currentScore1, currentScore2, $btn, teams) {
        // Obtenir les traductions
        const t = typeof translations !== 'undefined' ? translations : {};
        const titleText = t.modify_your_prediction || 'Modifier votre pronostic';
        const scoreToCorrectText = t.score_to_correct || 'Score à corriger';
        const correctionMessageText = t.equality_correction_message || 'Dans les phases d\'élimination directe (8e de finale, quart de finale, demi-finale, finale), il doit y avoir un vainqueur. Veuillez modifier votre pronostic pour qu\'une équipe gagne.';
        const penaltyScoreText = t.penalty_score || 'Score penalti';
        const cancelText = t.cancel || 'Annuler';
        const validateText = t.validate_new_score || 'Valider le nouveau score';
        const validScoresText = t.please_enter_valid_scores || 'Veuillez saisir des scores valides.';
        const chooseWinnerText = t.please_choose_winner || 'Veuillez choisir un score où une équipe gagne.';
        const updatedText = t.prediction_updated || 'Votre pronostic a été mis à jour !';

        // Créer le modal s'il n'existe pas
        if ($('#equalityCorrectionModal').length === 0) {
            const modalHtml = `
                <div class="modal fade" id="equalityCorrectionModal" tabindex="-1" aria-labelledby="equalityCorrectionModalLabel" aria-hidden="true">
                    <div class="modal-dialog">
                        <div class="modal-content bg-dark text-white">
                            <div class="modal-header">
                                <h5 class="modal-title" id="equalityCorrectionModalLabel">${titleText}</h5>
                                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle"></i>
                                    <strong>${scoreToCorrectText}</strong><br>
                                    ${correctionMessageText}
                                </div>
                                <div class="mb-3">
                                    <div class="d-flex align-items-center justify-content-center gap-3">
                                        <div class="text-center">
                                            <img class="team-flag-1" src="" alt="" style="width: 40px; height: 30px; border-radius: 4px; margin-bottom: 5px;">
                                            <div class="fw-bold team-name-1"></div>
                                        </div>
                                        <div class="fw-bold text-warning current-score-display" style="font-size: 1.2rem;">${currentScore1} - ${currentScore2}</div>
                                        <div class="text-center">
                                            <img class="team-flag-2" src="" alt="" style="width: 40px; height: 30px; border-radius: 4px; margin-bottom: 5px;">
                                            <div class="fw-bold team-name-2"></div>
                                        </div>
                                    </div>
                                </div>
                                <h6 class="mb-3" style="color: white; font-weight: bold;">${penaltyScoreText}</h6>
                                <div class="row">
                                    <div class="col-6">
                                        <label for="newScore1" class="form-label team-label-1">
                                        </label>
                                        <input type="number" class="form-control" id="newScore1" min="0" max="20" value="0">
                                    </div>
                                    <div class="col-6">
                                        <label for="newScore2" class="form-label team-label-2">
                                        </label>
                                        <input type="number" class="form-control" id="newScore2" min="0" max="20" value="0">
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">${cancelText}</button>
                                <button type="button" class="btn btn-success" id="confirmEqualityCorrection">${validateText}</button>
                            </div>
                        </div>
                    </div>
                </div>
            `;
            $('body').append(modalHtml);
        }

        // Mettre à jour le contenu du modal avec les informations des équipes et réinitialiser les valeurs
        const modal = $('#equalityCorrectionModal');
        if (modal.length > 0) {
            // Mettre à jour les flags et noms des équipes
            modal.find('.team-flag-1').attr('src', getTeamFlagUrl(teams.team_1));
            modal.find('.team-flag-2').attr('src', getTeamFlagUrl(teams.team_2));
            modal.find('.team-name-1').text(teams.team_1);
            modal.find('.team-name-2').text(teams.team_2);
            modal.find('.team-label-1').html(`<img src="${getTeamFlagUrl(teams.team_1)}" alt="${teams.team_1}" style="width: 24px; height: 18px; border-radius: 2px; margin-right: 8px;">${teams.team_1} :`);
            modal.find('.team-label-2').html(`<img src="${getTeamFlagUrl(teams.team_2)}" alt="${teams.team_2}" style="width: 24px; height: 18px; border-radius: 2px; margin-right: 8px;">${teams.team_2} :`);
            
            // Mettre à jour le score actuel affiché
            modal.find('.current-score-display').text(`${currentScore1} - ${currentScore2}`);
            
            // Réinitialiser les valeurs des inputs à chaque ouverture
            modal.find('#newScore1').val(0);
            modal.find('#newScore2').val(0);
            
            // Mettre à jour les textes traduits
            modal.find('#equalityCorrectionModalLabel').text(titleText);
            modal.find('.alert-info strong').text(scoreToCorrectText);
            modal.find('.alert-info').html(`<i class="fas fa-info-circle"></i><strong>${scoreToCorrectText}</strong><br>${correctionMessageText}`);
            modal.find('h6').text(penaltyScoreText);
            modal.find('.modal-footer .btn-secondary').text(cancelText);
            modal.find('#confirmEqualityCorrection').text(validateText);
        }

        // Afficher le modal
        $('#equalityCorrectionModal').modal('show');

        // Gérer la validation
        $('#confirmEqualityCorrection').off('click').on('click', function() {
            const newScore1 = parseInt($('#newScore1').val());
            const newScore2 = parseInt($('#newScore2').val());

            if (isNaN(newScore1) || isNaN(newScore2)) {
                showToast(validScoresText, 'danger');
                return;
            }

            if (newScore1 === newScore2) {
                showToast(chooseWinnerText, 'warning');
                return;
            }

            // Envoyer la correction
            $.post(base + '/ajax/correct_equality_score.php', {
                match_id: matchId,
                new_score_1: newScore1,
                new_score_2: newScore2
            }, function(data) {
                if (data.success) {
                    showToast(updatedText, 'success');
                    $('#equalityCorrectionModal').modal('hide');
                    setButtonValidated($btn);
                    
                    // Mettre à jour les champs de saisie
                    const matchBlock = $btn.closest('.match-row, .match-card-mobile');
                    if (matchBlock.length === 0) matchBlock = $btn.parent();
                    const score1Input = matchBlock.find('[name=score_' + matchId + '_1]');
                    const score2Input = matchBlock.find('[name=score_' + matchId + '_2]');
                    score1Input.val(newScore1);
                    score2Input.val(newScore2);
                } else {
                    showToast(data.message, 'danger');
                }
            }, 'json');
        });
    }
}); 