<?php
// Script pour nettoyer les doublons dans quiz_answered_questions
require_once 'includes/db.php';

echo "<h2>Nettoyage des doublons dans quiz_answered_questions</h2>";

try {
    // Vérifier si la table existe
    $table_check = $mysqli->query("SHOW TABLES LIKE 'quiz_answered_questions'");
    if (!$table_check || $table_check->num_rows == 0) {
        echo "<p style='color: red;'>✗ La table quiz_answered_questions n'existe pas</p>";
        exit;
    }
    
    // Compter les doublons avant nettoyage
    echo "<p>1. Comptage des doublons...</p>";
    $duplicate_count = $mysqli->query("
        SELECT COUNT(*) as total
        FROM (
            SELECT user_id, question_id, phase, COUNT(*) as cnt
            FROM quiz_answered_questions
            GROUP BY user_id, question_id, phase
            HAVING cnt > 1
        ) as duplicates
    ");
    $dup_row = $duplicate_count->fetch_assoc();
    $total_duplicates = $dup_row['total'] ?? 0;
    echo "<p>Nombre de combinaisons (user_id, question_id, phase) en double : <strong>{$total_duplicates}</strong></p>";
    
    if ($total_duplicates > 0) {
        // Créer une table temporaire avec les enregistrements uniques
        echo "<p>2. Création d'une table temporaire avec les enregistrements uniques...</p>";
        $mysqli->query("DROP TABLE IF EXISTS quiz_answered_questions_temp");
        $mysqli->query("
            CREATE TABLE quiz_answered_questions_temp AS
            SELECT MIN(id) as id, user_id, question_id, phase, MIN(answered_at) as answered_at
            FROM quiz_answered_questions
            GROUP BY user_id, question_id, phase
        ");
        echo "<p style='color: green;'>✓ Table temporaire créée</p>";
        
        // Compter les enregistrements dans la table temporaire
        $temp_count = $mysqli->query("SELECT COUNT(*) as total FROM quiz_answered_questions_temp");
        $temp_row = $temp_count->fetch_assoc();
        $temp_total = $temp_row['total'] ?? 0;
        echo "<p>Nombre d'enregistrements uniques : <strong>{$temp_total}</strong></p>";
        
        // Supprimer l'ancienne table et renommer la nouvelle
        echo "<p>3. Remplacement de l'ancienne table...</p>";
        $mysqli->query("DROP TABLE quiz_answered_questions");
        $mysqli->query("RENAME TABLE quiz_answered_questions_temp TO quiz_answered_questions");
        echo "<p style='color: green;'>✓ Table remplacée</p>";
        
        // Recréer la structure complète avec les contraintes
        echo "<p>4. Recréation de la structure avec les contraintes...</p>";
        $mysqli->query("
            ALTER TABLE quiz_answered_questions
            MODIFY id INT AUTO_INCREMENT PRIMARY KEY,
            ADD UNIQUE KEY unique_user_question_phase (user_id, question_id, phase),
            ADD INDEX idx_user_phase (user_id, phase),
            ADD INDEX idx_question (question_id)
        ");
        echo "<p style='color: green;'>✓ Structure recréée avec les contraintes UNIQUE</p>";
        
        // Vérifier qu'il n'y a plus de doublons
        echo "<p>5. Vérification finale...</p>";
        $final_check = $mysqli->query("
            SELECT COUNT(*) as total
            FROM (
                SELECT user_id, question_id, phase, COUNT(*) as cnt
                FROM quiz_answered_questions
                GROUP BY user_id, question_id, phase
                HAVING cnt > 1
            ) as duplicates
        ");
        $final_row = $final_check->fetch_assoc();
        $final_duplicates = $final_row['total'] ?? 0;
        
        if ($final_duplicates == 0) {
            echo "<p style='color: green; font-size: 1.2rem; font-weight: bold;'>✓ Nettoyage terminé avec succès ! Aucun doublon restant.</p>";
        } else {
            echo "<p style='color: orange;'>⚠ Il reste {$final_duplicates} doublons. Veuillez vérifier manuellement.</p>";
        }
        
        // Afficher le nombre total d'enregistrements
        $total_count = $mysqli->query("SELECT COUNT(*) as total FROM quiz_answered_questions");
        $total_row = $total_count->fetch_assoc();
        $total = $total_row['total'] ?? 0;
        echo "<p>Nombre total d'enregistrements après nettoyage : <strong>{$total}</strong></p>";
        
    } else {
        echo "<p style='color: green;'>✓ Aucun doublon trouvé. La table est propre.</p>";
        
        // Vérifier que la contrainte UNIQUE existe
        $index_check = $mysqli->query("
            SHOW INDEX FROM quiz_answered_questions 
            WHERE Key_name = 'unique_user_question_phase'
        ");
        if ($index_check->num_rows == 0) {
            echo "<p style='color: orange;'>⚠ La contrainte UNIQUE n'existe pas. Création...</p>";
            $mysqli->query("
                ALTER TABLE quiz_answered_questions
                ADD UNIQUE KEY unique_user_question_phase (user_id, question_id, phase)
            ");
            echo "<p style='color: green;'>✓ Contrainte UNIQUE créée</p>";
        } else {
            echo "<p style='color: green;'>✓ La contrainte UNIQUE existe déjà</p>";
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Erreur: " . $e->getMessage() . "</p>";
}

$mysqli->close();
?>

