# Configuration des dates limites des pronostics

## Vue d'ensemble

Le système utilise deux types de dates limites différents pour les pronostics, tous deux configurables avec date, heure et minute :

1. **Pronostics de matchs** : Date/heure globale configurable OU règle par défaut (1 heure avant chaque match)
2. **Pronostics de groupes** : Date et heure de fermeture configurable par l'administrateur

## Accès à la configuration

1. Connectez-vous en tant qu'administrateur
2. Accédez à la page **Configuration** dans le menu d'administration

## Configuration des pronostics de matchs

### Options disponibles

#### Option 1 : Date/heure globale configurable
- **Configuration admin** : Définir une date et heure précise pour tous les matchs
- **Interface** : Champ datetime-local dans la page Configuration
- **Comportement** : Tous les pronostics se ferment à cette date/heure

#### Option 2 : Règle par défaut (si aucune config)
- **Configuration automatique** : Les pronostics se ferment automatiquement **1 heure avant** chaque match
- **Aucune configuration nécessaire** : Appliqué automatiquement si aucune deadline globale n'est définie

### Exemples concrets
- **Deadline globale** : 20/12/2025 à 23h59 → Tous les pronostics se ferment à cette date/heure
- **Règle par défaut** : Match à 15h00 → Pronostics fermés à 14h00

## Configuration des pronostics de groupes

### Interface graphique

1. Dans la section "Configuration des pronostics de groupes"
2. Modifiez la date et l'heure dans le champ "Date et heure limite"
3. Cliquez sur "Enregistrer" ou laissez le champ se mettre à jour automatiquement

### Format de la date
- Format : YYYY-MM-DDTHH:MM (exemple : 2025-12-20T23:59)
- Interface datetime-local pour faciliter la saisie

### Comportement
- **Configurable** : L'administrateur définit une date et heure précise
- **Global** : S'applique à tous les groupes en même temps
- **Exemple concret** : 
  - Date limite configurée : 20/12/2025 à 23h59
  - Tous les pronostics de groupes se ferment à cette date/heure

## Fichiers de configuration

### Pronostics de matchs
La configuration est stockée dans le fichier :
```
includes/match_deadline.txt
```

#### Contenu du fichier
```
2025-12-20T23:59
```
**Note** : Si le fichier est vide, la règle par défaut (1h avant) s'applique.

### Pronostics de groupes
La configuration est stockée dans le fichier :
```
includes/groupes_deadline.txt
```

#### Contenu du fichier
```
2025-12-20T23:59
```

## Impact sur le système

### Pour les utilisateurs - Matchs
- **Deadline globale** : Tous les champs désactivés à la date/heure configurée
- **Règle par défaut** : Champs désactivés 1h avant chaque match
- Un message "Pronostic fermé" s'affiche
- Impossible de soumettre de nouveaux pronostics

### Pour les utilisateurs - Groupes
- Les boutons "Enregistrer" sont désactivés après la deadline
- Un message d'alerte s'affiche en haut de la page
- Le drag & drop est désactivé
- Impossible de soumettre de nouveaux pronostics

### Pour les administrateurs
- Vue en temps réel des deadlines dans la page Configuration
- Tableau des prochains matchs avec statut des pronostics
- Mise à jour automatique des statuts toutes les minutes
- Configuration centralisée pour les deux types de pronostics

## Surveillance

### Page de configuration
- Statistiques générales du système
- Configuration en temps réel
- Tableau des prochains matchs avec deadlines
- Statut actuel des pronostics (ouverts/fermés)

### Informations affichées
- **Matchs** : Date et heure du match, deadline (globale ou 1h avant), statut
- **Groupes** : Date limite configurée, statut actuel (ouvert/fermé)

## Sécurité

- Seuls les administrateurs peuvent modifier la configuration
- Validation des données côté serveur
- Sauvegarde automatique des paramètres
- Vérification côté client et serveur

## Dépannage

### Problème : La configuration ne se sauvegarde pas
- Vérifiez les permissions du dossier `includes/`
- Assurez-vous d'être connecté en tant qu'administrateur

### Problème : Les pronostics de matchs ne se ferment pas
- Vérifiez si une deadline globale est configurée dans `includes/match_deadline.txt`
- Si vide, vérifiez que la logique 1h avant est bien appliquée
- Vérifiez le fuseau horaire du serveur

### Problème : Les pronostics de groupes ne se ferment pas
- Vérifiez le format de la date (YYYY-MM-DDTHH:MM)
- Vérifiez la configuration dans `includes/groupes_deadline.txt`
- Rechargez la page pour voir les changements

### Problème : Affichage incorrect des deadlines
- Vérifiez le fuseau horaire du serveur
- Vérifiez que l'heure est au format 24h 