# Configuration des Emails - Système d'Inscription

## Vue d'ensemble

Le système d'inscription a été modifié pour :
1. **Afficher le formulaire d'inscription par défaut** au lieu du formulaire de connexion
2. **Valider les emails BNP Paribas** - seuls les emails `@bnpparibas.com` sont autorisés
3. **Générer automatiquement un mot de passe** pour chaque nouvel utilisateur
4. **Envoyer le mot de passe par email** pour vérification et sécurité

## Fonctionnement

### Processus d'inscription

1. L'utilisateur saisit son nom d'utilisateur, email (@bnpparibas.com), ville et département
2. Le système valide le format de l'email (doit se terminer par @bnpparibas.com)
3. Un mot de passe aléatoire de 12 caractères est généré automatiquement
4. Un email est envoyé à l'utilisateur avec son mot de passe temporaire
5. L'utilisateur peut se connecter et modifier son mot de passe dans "Mon profil"

### Validation de l'email

- **Côté client** : Validation JavaScript en temps réel avec feedback visuel
- **Côté serveur** : Double validation PHP pour garantir la sécurité
- **Format requis** : `prenom.nom@bnpparibas.com`

## Configuration de l'envoi d'emails

### Fichier de configuration

Le fichier `includes/email.php` contient toutes les fonctions d'envoi d'emails.

### Configuration SMTP (Recommandé pour production)

Pour un environnement de production, il est recommandé d'utiliser un serveur SMTP. Modifiez les constantes dans `includes/email.php` :

```php
define('SMTP_HOST', 'smtp.votre-serveur.com');
define('SMTP_PORT', 587);
define('SMTP_USERNAME', 'votre-email@bnpparibas.com');
define('SMTP_PASSWORD', 'votre-mot-de-passe');
define('FROM_EMAIL', 'noreply@bnpparibas.com');
define('FROM_NAME', 'BMCI - CAN 2025');
```

### Option 1 : Utiliser PHPMailer (Recommandé)

Pour une meilleure fiabilité, installez PHPMailer :

```bash
composer require phpmailer/phpmailer
```

Puis modifiez la fonction `sendPasswordEmail()` dans `includes/email.php` :

```php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

function sendPasswordEmail($to, $username, $password) {
    $mail = new PHPMailer(true);
    
    try {
        // Configuration SMTP
        $mail->isSMTP();
        $mail->Host = SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USERNAME;
        $mail->Password = SMTP_PASSWORD;
        $mail->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $mail->Port = SMTP_PORT;
        $mail->CharSet = 'UTF-8';
        
        // Destinataires
        $mail->setFrom(FROM_EMAIL, FROM_NAME);
        $mail->addAddress($to, $username);
        
        // Contenu
        $mail->isHTML(true);
        $mail->Subject = 'Bienvenue sur la plateforme CAN 2025 - BMCI';
        $mail->Body = '...'; // Utilisez le même contenu HTML
        
        $mail->send();
        return true;
    } catch (Exception $e) {
        error_log("Erreur d'envoi email: {$mail->ErrorInfo}");
        return false;
    }
}
```

### Option 2 : Fonction mail() native de PHP

La fonction `mail()` native de PHP est actuellement utilisée. Pour qu'elle fonctionne :

1. **Sur serveur Linux** : Assurez-vous que `sendmail` est installé et configuré
2. **Sur WAMP/XAMPP** : Configurez `php.ini` :

```ini
[mail function]
SMTP = smtp.gmail.com
smtp_port = 587
sendmail_from = votre-email@bnpparibas.com
```

### Option 3 : Service externe (SendGrid, Mailgun, etc.)

Pour une solution professionnelle, utilisez un service d'envoi d'emails :

```php
// Exemple avec SendGrid
$email = new \SendGrid\Mail\Mail();
$email->setFrom(FROM_EMAIL, FROM_NAME);
$email->setSubject("Bienvenue sur la plateforme CAN 2025");
$email->addTo($to, $username);
$email->addContent("text/html", $message);

$sendgrid = new \SendGrid(getenv('SENDGRID_API_KEY'));
try {
    $response = $sendgrid->send($email);
    return $response->statusCode() == 202;
} catch (Exception $e) {
    return false;
}
```

## Gestion des erreurs d'envoi

Si l'email ne peut pas être envoyé, le système :
1. Inscrit quand même l'utilisateur
2. Affiche le mot de passe temporaire directement dans une popup
3. L'utilisateur doit le copier et le conserver

**Note** : En production, il est préférable de ne pas afficher le mot de passe à l'écran et d'empêcher l'inscription si l'email ne peut pas être envoyé.

## Sécurité

### Génération du mot de passe

- Longueur : 12 caractères minimum
- Contient : majuscules, minuscules, chiffres, caractères spéciaux
- Aléatoire et cryptographiquement sécurisé

### Stockage

- Le mot de passe est hashé avec `password_hash()` (bcrypt)
- Jamais stocké en clair dans la base de données

### Changement de mot de passe

L'utilisateur peut changer son mot de passe temporaire dans la page "Mon profil" (`profile.php`).

## Tests

### Test en local

Pour tester en développement local :

1. Utilisez un service comme [Mailtrap](https://mailtrap.io/) pour intercepter les emails
2. Ou affichez temporairement le mot de passe dans les logs :

```php
error_log("Mot de passe généré pour {$email}: {$generatedPassword}");
```

### Test en production

1. Créez un compte test avec votre email BNP Paribas
2. Vérifiez la réception de l'email
3. Testez la connexion avec le mot de passe reçu
4. Testez le changement de mot de passe dans le profil

## Fichiers modifiés

- `includes/email.php` - Nouveau fichier pour la gestion des emails
- `ajax/register.php` - Logique d'inscription modifiée
- `welcome.php` - Interface utilisateur modifiée
- `docs/email_configuration.md` - Cette documentation

## Support

Pour toute question ou problème, contactez l'équipe technique.

