# Guide de la réinitialisation de mot de passe

## Fonctionnalités ajoutées

Le système de réinitialisation de mot de passe a été intégré à la plateforme CAN 2025. Voici les nouvelles fonctionnalités :

### 1. Interface utilisateur
- **Lien "Mot de passe oublié"** sur la page de connexion
- **Modal de demande** de réinitialisation avec validation email
- **Page de réinitialisation** sécurisée avec token
- **Indicateur de force** du mot de passe
- **Validation en temps réel** des mots de passe

### 2. Sécurité
- **Tokens sécurisés** avec expiration (1 heure)
- **Validation côté serveur** et client
- **Emails professionnels** avec design cohérent
- **Nettoyage automatique** des tokens expirés

### 3. Processus de réinitialisation

#### Pour l'utilisateur :
1. Cliquer sur "Mot de passe oublié ?" sur la page de connexion
2. Saisir son adresse email
3. Recevoir un email avec un lien sécurisé
4. Cliquer sur le lien (valide 1 heure)
5. Saisir le nouveau mot de passe
6. Confirmer le nouveau mot de passe
7. Se connecter avec les nouveaux identifiants

#### Pour l'administrateur :
1. Exécuter `setup_password_reset.php` pour créer la table
2. Vérifier la configuration SMTP dans `includes/smtp.php`
3. Tester le processus complet

## Fichiers créés/modifiés

### Nouveaux fichiers :
- `ajax/forgot_password.php` - Traitement de la demande de réinitialisation
- `ajax/reset_password.php` - Traitement de la réinitialisation effective
- `reset_password.php` - Page de réinitialisation
- `includes/password_reset_tokens.sql` - Structure de la table
- `setup_password_reset.php` - Script de configuration

### Fichiers modifiés :
- `includes/email.php` - Ajout de la fonction d'email de réinitialisation
- `welcome.php` - Ajout du lien et de la modal

## Configuration requise

### 1. Base de données
Exécuter le script de configuration :
```bash
php setup_password_reset.php
```

### 2. Configuration SMTP
Vérifier que la configuration email est correcte dans `includes/smtp.php`

### 3. Permissions
S'assurer que les fichiers ont les bonnes permissions :
- Fichiers PHP : 644
- Dossiers : 755

## Sécurité

### Mesures de sécurité implémentées :
- **Tokens cryptographiquement sécurisés** (64 caractères hexadécimaux)
- **Expiration automatique** des tokens (1 heure)
- **Validation stricte** des emails
- **Protection CSRF** via tokens uniques
- **Nettoyage automatique** des tokens expirés
- **Messages d'erreur génériques** pour éviter l'énumération d'emails

### Recommandations :
- Surveiller les tentatives de réinitialisation
- Implémenter un rate limiting si nécessaire
- Considérer l'ajout d'un captcha pour les environnements de production

## Tests

### Tests recommandés :
1. **Test du lien "Mot de passe oublié"**
2. **Test de l'envoi d'email**
3. **Test de la réinitialisation avec token valide**
4. **Test de la réinitialisation avec token expiré**
5. **Test de validation des mots de passe**
6. **Test de l'interface utilisateur**

### Scénarios de test :
- Email valide existant
- Email valide inexistant
- Token expiré
- Token invalide
- Mots de passe différents
- Mot de passe trop court

## Maintenance

### Nettoyage automatique :
Les tokens expirés peuvent être nettoyés automatiquement via un cron job :
```sql
DELETE FROM password_reset_tokens WHERE expires_at < NOW();
```

### Surveillance :
- Surveiller les logs d'erreur
- Surveiller les tentatives de réinitialisation
- Vérifier la configuration SMTP régulièrement

## Support

En cas de problème :
1. Vérifier les logs d'erreur PHP
2. Vérifier la configuration SMTP
3. Vérifier la connectivité à la base de données
4. Tester avec un email de test

## Notes techniques

- **Durée de validité** : 1 heure (configurable)
- **Longueur du token** : 64 caractères hexadécimaux
- **Encodage** : UTF-8
- **Base de données** : MySQL/MariaDB
- **Framework** : PHP natif avec Bootstrap

