<?php
// Inclure le système de langue en premier
require_once 'includes/language.php';

// Fonction pour obtenir le titre traduit d'une phase
function getPhaseTitreGoodies($phase, $current_lang) {
    $phase_translations = [
        'fr' => [
            'Phase de groupes' => 'Phase de groupes',
            '8e de finale' => '8e de finale',
            'Quart de finale' => 'Quart de finale',
            'Demi-finale' => 'Demi-finale',
            'Match pour la 3e place' => 'Match pour la 3e place',
            'Finale' => 'Finale'
        ],
        'ar' => [
            'Phase de groupes' => 'مرحلة المجموعات',
            '8e de finale' => 'دور الثمن النهائي',
            'Quart de finale' => 'ربع النهائي',
            'Demi-finale' => 'نصف النهائي',
            'Match pour la 3e place' => 'مباراة المركز الثالث',
            'Finale' => 'النهائي'
        ]
    ];
    return $phase_translations[$current_lang][$phase] ?? $phase;
}

include 'templates/header.php';
?>
<style>
/* Styles RTL pour l'arabe */
.lang-ar .container {
    text-align: right;
}

.lang-ar h1,
.lang-ar h2 {
    text-align: center;
}

.lang-ar p {
    text-align: right;
}
</style>
<div class="container" style="max-width:650px;margin:40px auto 30px auto;background:#23232b;border-radius:18px;box-shadow:0 4px 24px #0005;padding:32px 24px 24px 24px;">
  <h1 style="color:#ffb300;text-align:center;font-weight:800;"><?= __('goodies_title') ?></h1>

  <div class="goodies-bloc" style="margin-bottom:32px;">
    <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('group_phase'), $current_lang) ?></h2>
    <p style="color:white;"><?= __('group_phase_goodies') ?></p>
  </div>

  <div class="goodies-bloc" style="margin-bottom:32px;">
    <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('round_of_16'), $current_lang) ?></h2>
    <p style="color:white;"><?= __('round_of_16_goodies') ?></p>
  </div>

  <div class="goodies-bloc" style="margin-bottom:32px;">
    <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('quarter_final'), $current_lang) ?></h2>
    <p style="color:white;"><?= __('quarter_final_goodies') ?></p>
  </div>

  <div class="goodies-bloc" style="margin-bottom:32px;">
    <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('semi_final'), $current_lang) ?></h2>
    <p style="color:white;"><?= __('semi_final_goodies') ?></p>
  </div>

  <div class="goodies-bloc" style="margin-bottom:32px;">
    <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('third_place_match'), $current_lang) ?></h2>
    <p style="color:white;"><?= __('third_place_goodies') ?></p>
  </div>

  <div class="goodies-bloc" style="margin-bottom:32px;">
    <h2 style="color:#ffb300;"><?= getPhaseTitreGoodies(__('final'), $current_lang) ?></h2>
    <p style="color:white;"><?= __('final_goodies') ?></p>
  </div>
</div>
<?php include 'templates/footer.php'; ?> 