<?php 
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/\\'); 

// Inclure le système de langue en premier
require_once 'includes/language.php';
require_once 'includes/image_mapping.php';

if (isset($_SESSION['role']) && ($_SESSION['role'] === 'admin' || $_SESSION['role'] === 'stat')) {
    header('Location: admin/dashboard.php');
    exit;
}

include 'templates/header.php';
?>

<?php
// Fonction pour obtenir le chemin des images selon la langue
function getMenuIcon($filename) {
    $current_lang = getCurrentLanguage();
    
    if ($current_lang === 'ar') {
        // Utiliser les images arabes
        if (strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Mobile') !== false || 
            (isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i', $_SERVER['HTTP_USER_AGENT']))) {
            $arabic_name = getArabicImageName($filename, 'mobile');
            return 'assets/img/AR mobile/' . $arabic_name;
        } else {
            $arabic_name = getArabicImageName($filename, 'pc');
            return 'assets/img/AR pc/' . $arabic_name;
        }
    } else {
        // Utiliser les images françaises
        if (strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Mobile') !== false || 
            (isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i', $_SERVER['HTTP_USER_AGENT']))) {
            return 'assets/img/icon_menu_mobile/' . $filename;
        } else {
            return 'assets/img/icon_menu_pc/' . $filename;
        }
    }
}
?>
<style>
@media (min-width: 768px) {
  .menu-btn-can2025 img[data-pc-src] {
    content: attr(data-pc-src);
  }
}
</style>
<script>
document.addEventListener('DOMContentLoaded', function() {
  if (window.matchMedia('(min-width: 768px)').matches) {
    document.querySelectorAll('.menu-btn-can2025 img[data-pc-src]').forEach(function(img) {
      img.src = img.getAttribute('data-pc-src');
    });
  }
});
</script>

<div class="header-img-mobile d-md-none"></div>

<!-- Contenu principal -->
<div class="d-flex flex-column align-items-center justify-content-center" style="min-height: 70vh;">
  <h1 class="mb-5 text-center" style="font-weight:700;color:white;letter-spacing:1px;margin-top: 10px;"><?= __('welcome_title') ?></h1>
  <div class="menu-grid-can2025">
    <a href="<?= $base ?>/pronostic_vainqueur.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('champion can.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('champion can.png', 'pc') : 'assets/img/icon_menu_pc/champion can.png' ?>" alt="<?= __('champion_can') ?>" />
    </a>
    <a href="<?= $base ?>/pronostics_groupe.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('classement des groupes.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('classement des groupes.png', 'pc') : 'assets/img/icon_menu_pc/classement des groupes.png' ?>" alt="<?= __('group_ranking') ?>" />
    </a>
    <a href="<?= $base ?>/pronostics_matchs.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('matchs.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('matchs.png', 'pc') : 'assets/img/icon_menu_pc/matchs.png' ?>" alt="<?= __('matches') ?>" />
    </a>
    <a href="<?= $base ?>/titulaires_vote.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('11 titulaires.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('11 titulaires.png', 'pc') : 'assets/img/icon_menu_pc/11 titulaires.png' ?>" alt="<?= __('eleven_starters') ?>" />
    </a>
    <a href="mur_message.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('mur de message.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('mur de message.png', 'pc') : 'assets/img/icon_menu_pc/mur de message.png' ?>" alt="<?= __('message_wall') ?>" />
    </a>
    <a href="quizz.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('quizz.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('quizz.png', 'pc') : 'assets/img/icon_menu_pc/quizz.png' ?>" alt="<?= __('quiz') ?>" />
    </a>
    <a href="<?= $base ?>/challenge_photos.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('challenge photo-phone.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('challenge photo.png', 'pc') : 'assets/img/icon_menu_pc/challenge photo.png' ?>" alt="<?= __('photo_challenge') ?>" />
    </a>
    <a href="<?= $base ?>/score.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('mon score & classement.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('mon score & classement.png', 'pc') : 'assets/img/icon_menu_pc/mon score & classement.png' ?>" alt="<?= __('my_score_ranking') ?>" />
    </a>
    <a href="<?= $base ?>/gagnants.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('vainqueurs.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('vainqueurs.png', 'pc') : 'assets/img/icon_menu_pc/vainqueurs.png' ?>" alt="<?= __('rules') ?>" />
    </a>
    <a href="<?= $base ?>/reglement_goodies.php" class="menu-btn-can2025">
      <img src="<?= getMenuIcon('regle&goodies.png') ?>" data-pc-src="<?= getCurrentLanguage() === 'ar' ? 'assets/img/AR pc/' . getArabicImageName('regle&goodies.png', 'pc') : 'assets/img/icon_menu_pc/regle&goodies.png' ?>" alt="<?= __('goodies') ?>" />
    </a>
  </div>
</div>

<div class="footer-img-mobile d-md-none"></div>
<?php include 'templates/footer.php'; ?>
