<?php
/**
 * Fichier de gestion des emails
 * Configuration et fonctions d'envoi d'emails
 */

// Charger la configuration SMTP
require_once __DIR__ . '/smtp.php';

/**
 * Génère un mot de passe aléatoire sécurisé
 * @param int $length Longueur du mot de passe (par défaut 12)
 * @return string Mot de passe généré
 */
function generateRandomPassword($length = 12) {
    $chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!@#$%&*';
    $password = '';
    $max = strlen($chars) - 1;
    
    // Assurer qu'il y a au moins une majuscule, une minuscule, un chiffre et un caractère spécial
    $password .= chr(rand(65, 90)); // Majuscule
    $password .= chr(rand(97, 122)); // Minuscule
    $password .= chr(rand(48, 57)); // Chiffre
    $password .= $chars[rand(strlen($chars) - 8, $max)]; // Caractère spécial
    
    // Compléter le reste
    for ($i = 4; $i < $length; $i++) {
        $password .= $chars[rand(0, $max)];
    }
    
    // Mélanger le mot de passe
    return str_shuffle($password);
}

/**
 * Envoie un email avec le mot de passe généré
 * @param string $to Email du destinataire
 * @param string $username Nom d'utilisateur
 * @param string $password Mot de passe généré
 * @return bool True si l'email est envoyé avec succès
 */
function sendPasswordEmail($to, $username, $password) {
    $subject = 'Bienvenue sur la plateforme CAN 2025 - BMCI';
    
    $message = '
    <!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <!--[if mso]>
        <style type="text/css">
            table {border-collapse: collapse; border-spacing: 0; margin: 0;}
            div, td {padding: 0;}
            div {margin: 0 !important;}
        </style>
        <![endif]-->
    </head>
    <body style="margin: 0; padding: 0; background-color: #f0f0f0; font-family: Arial, sans-serif;">
        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" style="background-color: #f0f0f0;">
            <tr>
                <td align="center" style="padding: 20px 0;">
                    <table role="presentation" width="600" cellspacing="0" cellpadding="0" border="0" style="background-color: #ffffff; max-width: 600px;">
                        
                        <!-- En-tête -->
                        <tr>
                            <td style="background-color: #ab2024; padding: 30px 20px; text-align: center;">
                                <h2 style="color: #ffffff; margin: 0 0 10px 0; font-size: 24px; font-weight: bold;">
                                    🏆 Bienvenue sur la plateforme CAN 2025
                                </h2>
                                <p style="color: #ffffff; margin: 0; font-size: 16px;">
                                    BMCI - Groupe BNP Paribas
                                </p>
                            </td>
                        </tr>
                        
                        <!-- Contenu -->
                        <tr>
                            <td style="background-color: #f4f4f4; padding: 30px 20px;">
                                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                    
                                    <!-- Salutation -->
                                    <tr>
                                        <td>
                                            <h3 style="color: #006d44; margin: 0 0 15px 0; font-size: 20px;">
                                                Bonjour ' . htmlspecialchars($username) . ',
                                            </h3>
                                            <p style="color: #333333; line-height: 1.6; margin: 0 0 20px 0;">
                                                Votre inscription a été validée avec succès ! Vous faites maintenant partie de la communauté des pronostiqueurs CAN 2025.
                                            </p>
                                        </td>
                                    </tr>
                                    
                                    <!-- Section identifiants -->
                                    <tr>
                                        <td style="padding: 15px; background-color: #ffffff; border-left: 4px solid #00915a;">
                                            <strong style="color: #006d44; font-size: 16px;">
                                                Voici vos identifiants de connexion :
                                            </strong>
                                        </td>
                                    </tr>
                                    
                                    <!-- Mot de passe -->
                                    <tr>
                                        <td align="center" style="padding: 20px 0;">
                                            <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                <tr>
                                                    <td style="background-color: #00915a; padding: 25px; text-align: center;">
                                                        <p style="color: #ffffff; margin: 0 0 10px 0; font-size: 14px; font-weight: bold;">
                                                            Votre mot de passe temporaire :
                                                        </p>
                                                        <p style="color: #ffffff; margin: 0; font-size: 24px; font-weight: bold; letter-spacing: 2px; font-family: Courier New, monospace;">
                                                            ' . htmlspecialchars($password) . '
                                                        </p>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    
                                    <!-- Avertissement -->
                                    <tr>
                                        <td style="padding: 15px; background-color: #fff3cd; border-left: 4px solid #ffc107;">
                                            <p style="color: #333333; margin: 0; line-height: 1.6;">
                                                <strong>⚠️ Important :</strong> Conservez précieusement ce mot de passe. Vous pourrez le modifier à tout moment depuis votre profil.
                                            </p>
                                        </td>
                                    </tr>
                                    
                                    <!-- Instructions -->
                                    <tr>
                                        <td style="padding: 20px 0 10px 0;">
                                            <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                <tr>
                                                    <td style="padding: 15px; background-color: #ffffff; border-left: 4px solid #00915a;">
                                                        <strong style="color: #006d44; font-size: 16px;">
                                                            Pour vous connecter :
                                                        </strong>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 15px 20px; background-color: #ffffff;">
                                                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    1. Rendez-vous sur la plateforme
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    2. Cliquez sur l\'onglet "Connexion"
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    3. Utilisez votre email et le mot de passe ci-dessus
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    4. N\'oubliez pas de changer votre mot de passe dans "Mon profil"
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    
                                    <!-- Message final -->
                                    <tr>
                                        <td style="padding: 20px 0; text-align: center;">
                                            <p style="color: #333333; line-height: 1.6; margin: 0 0 15px 0;">
                                                Participez dès maintenant et tentez de remporter de magnifiques cadeaux en pronostiquant les scores des matchs de la CAN Maroc 2025 !
                                            </p>
                                            <p style="color: #00915a; font-size: 18px; font-weight: bold; margin: 0;">
                                                Bonne chance ! 🏆⚽
                                            </p>
                                        </td>
                                    </tr>
                                    
                                </table>
                            </td>
                        </tr>
                        
                        <!-- Pied de page -->
                        <tr>
                            <td style="background-color: #e9ecef; padding: 20px; text-align: center;">
                                <p style="color: #666666; font-size: 12px; margin: 0 0 5px 0; line-height: 1.5;">
                                    Ceci est un email automatique, merci de ne pas y répondre.
                                </p>
                                <p style="color: #666666; font-size: 12px; margin: 0; line-height: 1.5;">
                                    &copy; 2025 BMCI - Groupe BNP Paribas. Tous droits réservés.
                                </p>
                            </td>
                        </tr>
                        
                    </table>
                </td>
            </tr>
        </table>
    </body>
    </html>
    ';
    
    // Utiliser la fonction sendEmail du fichier smtp.php
    $result = sendEmail($to, $subject, $message, true);
    return $result['success'];
}

/**
 * Envoie un email de réinitialisation de mot de passe
 * @param string $to Email du destinataire
 * @param string $username Nom d'utilisateur
 * @param string $resetUrl URL de réinitialisation
 * @return bool True si l'email est envoyé avec succès
 */
function sendPasswordResetEmail($to, $username, $resetUrl) {
    $subject = 'Réinitialisation de votre mot de passe - CAN 2025 BMCI';
    
    $message = '
    <!DOCTYPE html>
    <html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
        <!--[if mso]>
        <style type="text/css">
            table {border-collapse: collapse; border-spacing: 0; margin: 0;}
            div, td {padding: 0;}
            div {margin: 0 !important;}
        </style>
        <![endif]-->
    </head>
    <body style="margin: 0; padding: 0; background-color: #f0f0f0; font-family: Arial, sans-serif;">
        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0" style="background-color: #f0f0f0;">
            <tr>
                <td align="center" style="padding: 20px 0;">
                    <table role="presentation" width="600" cellspacing="0" cellpadding="0" border="0" style="background-color: #ffffff; max-width: 600px;">
                        
                        <!-- En-tête -->
                        <tr>
                            <td style="background-color: #ab2024; padding: 30px 20px; text-align: center;">
                                <h2 style="color: #ffffff; margin: 0 0 10px 0; font-size: 24px; font-weight: bold;">
                                    🔐 Réinitialisation de mot de passe
                                </h2>
                                <p style="color: #ffffff; margin: 0; font-size: 16px;">
                                    CAN 2025 - BMCI Groupe BNP Paribas
                                </p>
                            </td>
                        </tr>
                        
                        <!-- Contenu -->
                        <tr>
                            <td style="background-color: #f4f4f4; padding: 30px 20px;">
                                <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                    
                                    <!-- Salutation -->
                                    <tr>
                                        <td>
                                            <h3 style="color: #006d44; margin: 0 0 15px 0; font-size: 20px;">
                                                Bonjour ' . htmlspecialchars($username) . ',
                                            </h3>
                                            <p style="color: #333333; line-height: 1.6; margin: 0 0 20px 0;">
                                                Vous avez demandé une réinitialisation de votre mot de passe pour votre compte sur la plateforme CAN 2025.
                                            </p>
                                        </td>
                                    </tr>
                                    
                                    <!-- Bouton de réinitialisation -->
                                    <tr>
                                        <td align="center" style="padding: 20px 0;">
                                            <a href="' . htmlspecialchars($resetUrl) . '" 
                                               style="display: inline-block; padding: 20px 40px; background-color: #00915a; color: #ffffff; text-decoration: none; font-weight: bold; font-size: 18px; border-radius: 8px; box-shadow: 0 4px 8px rgba(0,0,0,0.2);">
                                                🔑 Cliquez ici pour réinitialiser votre mot de passe
                                            </a>
                                        </td>
                                    </tr>
                                    
                                    <!-- Avertissement de sécurité -->
                                    <tr>
                                        <td style="padding: 15px; background-color: #fff3cd; border-left: 4px solid #ffc107;">
                                            <p style="color: #333333; margin: 0; line-height: 1.6;">
                                                <strong>⚠️ Important :</strong> Ce lien est valide pendant 1 heure uniquement. Si vous n\'avez pas demandé cette réinitialisation, ignorez cet email.
                                            </p>
                                        </td>
                                    </tr>
                                    
                                    <!-- Instructions -->
                                    <tr>
                                        <td style="padding: 20px 0 10px 0;">
                                            <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                <tr>
                                                    <td style="padding: 15px; background-color: #ffffff; border-left: 4px solid #00915a;">
                                                        <strong style="color: #006d44; font-size: 16px;">
                                                            Pour réinitialiser votre mot de passe :
                                                        </strong>
                                                    </td>
                                                </tr>
                                                <tr>
                                                    <td style="padding: 15px 20px; background-color: #ffffff;">
                                                        <table role="presentation" width="100%" cellspacing="0" cellpadding="0" border="0">
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    1. Cliquez sur le bouton ci-dessus
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    2. Saisissez votre nouveau mot de passe
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    3. Confirmez votre nouveau mot de passe
                                                                </td>
                                                            </tr>
                                                            <tr>
                                                                <td style="color: #333333; line-height: 1.8; padding: 5px 0;">
                                                                    4. Connectez-vous avec vos nouveaux identifiants
                                                                </td>
                                                            </tr>
                                                        </table>
                                                    </td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    
                                    
                                </table>
                            </td>
                        </tr>
                        
                        <!-- Pied de page -->
                        <tr>
                            <td style="background-color: #e9ecef; padding: 20px; text-align: center;">
                                <p style="color: #666666; font-size: 12px; margin: 0 0 5px 0; line-height: 1.5;">
                                    Ceci est un email automatique, merci de ne pas y répondre.
                                </p>
                                <p style="color: #666666; font-size: 12px; margin: 0; line-height: 1.5;">
                                    &copy; 2025 BMCI - Groupe BNP Paribas. Tous droits réservés.
                                </p>
                            </td>
                        </tr>
                        
                    </table>
                </td>
            </tr>
        </table>
    </body>
    </html>
    ';
    
    // Utiliser la fonction sendEmail du fichier smtp.php
    $result = sendEmail($to, $subject, $message, true);
    return $result['success'];
}

/**
 * Valide que l'email est un email BNP Paribas ou une exception autorisée
 * @param string $email Email à valider
 * @return bool True si l'email est valide
 */
function isValidBNPEmail($email) {
    $email = strtolower(trim($email));
    
    // Liste des emails autorisés en exception
    $exceptions = [
        'tarik@thedreamtouch.com',
        'shun@thedreamtouch.com',
        'tarikbaghati@gmail.com'
    ];
    
    // Vérifier si l'email est dans les exceptions
    if (in_array($email, $exceptions)) {
        return true;
    }
    
    // Sinon, vérifier si c'est un email @bnpparibas.com ou @externe.bnpparibas.com
    return preg_match('/^[a-zA-Z0-9._%+-]+@(bnpparibas|externe\.bnpparibas)\.com$/i', $email);
}

