<?php
// Démarrer la session seulement si elle n'est pas déjà active
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Langues disponibles
$available_languages = ['fr', 'ar'];

// Fonction pour obtenir la langue actuelle
function getCurrentLanguage() {
    global $available_languages;
    
    // Vérifier si la langue est définie en session
    if (isset($_SESSION['language']) && in_array($_SESSION['language'], $available_languages)) {
        return $_SESSION['language'];
    }
    
    // Détecter la langue du navigateur
    $browser_lang = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'] ?? 'fr', 0, 2);
    if (in_array($browser_lang, $available_languages)) {
        return $browser_lang;
    }
    
    // Langue par défaut
    return 'fr';
}

// Fonction pour changer la langue
function setLanguage($lang) {
    global $available_languages;
    
    if (in_array($lang, $available_languages)) {
        $_SESSION['language'] = $lang;
        return true;
    }
    return false;
}

// Fonction pour obtenir une traduction
function __($key) {
    static $translations = null;
    
    if ($translations === null) {
        $current_lang = getCurrentLanguage();
        $lang_file = __DIR__ . '/../lang/' . $current_lang . '.php';
        
        if (file_exists($lang_file)) {
            $translations = include $lang_file;
        } else {
            $translations = include __DIR__ . '/../lang/fr.php';
        }
    }
    
    return $translations[$key] ?? $key;
}

// Fonction pour obtenir le chemin des images selon la langue
function getImagePath($image_name, $type = 'menu') {
    $current_lang = getCurrentLanguage();
    
    if ($type === 'menu') {
        if ($current_lang === 'ar') {
            // Utiliser les images arabes
            if (strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Mobile') !== false || 
                (isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i', $_SERVER['HTTP_USER_AGENT']))) {
                return 'assets/img/AR mobile/' . $image_name;
            } else {
                return 'assets/img/AR pc/' . $image_name;
            }
        } else {
            // Utiliser les images françaises
            if (strpos($_SERVER['HTTP_USER_AGENT'] ?? '', 'Mobile') !== false || 
                (isset($_SERVER['HTTP_USER_AGENT']) && preg_match('/Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i', $_SERVER['HTTP_USER_AGENT']))) {
                return 'assets/img/icon_menu_mobile/' . $image_name;
            } else {
                return 'assets/img/icon_menu_pc/' . $image_name;
            }
        }
    }
    
    return 'assets/img/' . $image_name;
}

// Fonction pour obtenir la direction du texte selon la langue
function getTextDirection() {
    return getCurrentLanguage() === 'ar' ? 'rtl' : 'ltr';
}

// Fonction pour obtenir la classe CSS selon la langue
function getLanguageClass() {
    return 'lang-' . getCurrentLanguage();
}

// Fonction pour obtenir le nom traduit d'un joueur
function getPlayerName($nom, $nom_ar = null) {
    $current_lang = getCurrentLanguage();
    if ($current_lang === 'ar' && !empty($nom_ar)) {
        return $nom_ar;
    }
    return $nom;
}

// Gestion du changement de langue via AJAX
if (isset($_POST['action']) && $_POST['action'] === 'change_language') {
    $new_lang = $_POST['language'] ?? 'fr';
    if (setLanguage($new_lang)) {
        echo json_encode(['success' => true, 'language' => $new_lang]);
    } else {
        echo json_encode(['success' => false, 'error' => 'Invalid language']);
    }
    exit;
}
?>