<?php
/**
 * Configuration SMTP pour l'envoi d'emails
 */

// Configuration SMTP
define('SMTP_HOST', 'mail.infomaniak.com');
define('SMTP_USERNAME', 'tarik@thedreamtouch.com');
define('SMTP_PASSWORD', '2580TDT@teb');
define('SMTP_SECURE', 'tls');
define('SMTP_PORT', 587);
define('SMTP_FROM_EMAIL', 'no-reply@footscore.app');
define('SMTP_FROM_NAME', 'BMCI - CAN 2025');

/**
 * Envoie un email via SMTP
 */
function sendEmail($to, $subject, $message, $isHTML = true, $replyTo = null) {
    require_once __DIR__ . '/../vendor/autoload.php';
    
    try {
        $mail = new PHPMailer\PHPMailer\PHPMailer(true);
        
        // Configuration SMTP
        $mail->isSMTP();
        $mail->Host = SMTP_HOST;
        $mail->SMTPAuth = true;
        $mail->Username = SMTP_USERNAME;
        $mail->Password = SMTP_PASSWORD;
        $mail->SMTPSecure = SMTP_SECURE;
        $mail->Port = SMTP_PORT;
        
        // Expéditeur et destinataire
        $mail->setFrom(SMTP_FROM_EMAIL, SMTP_FROM_NAME);
        $mail->addAddress($to);
        
        // Ajouter Reply-To si spécifié
        if ($replyTo) {
            $mail->addReplyTo($replyTo);
        }
        
        // Contenu
        $mail->isHTML($isHTML);
        $mail->CharSet = 'UTF-8';
        $mail->Subject = $subject;
        $mail->Body = $message;
        
        $mail->send();
        return ['success' => true, 'message' => 'Email envoyé avec succès'];
        
    } catch (Exception $e) {
        return ['success' => false, 'error' => 'Erreur lors de l\'envoi : ' . $e->getMessage()];
    }
}

/**
 * Envoie un email avec la fonction mail() de PHP (fallback)
 */
function sendEmailWithPHPMail($to, $subject, $message, $isHTML = true) {
    $headers = [
        'From: ' . SMTP_FROM_NAME . ' <' . SMTP_FROM_EMAIL . '>',
        'Reply-To: ' . SMTP_FROM_EMAIL,
        'X-Mailer: PHP/' . phpversion()
    ];
    
    if ($isHTML) {
        $headers[] = 'MIME-Version: 1.0';
        $headers[] = 'Content-type: text/html; charset=UTF-8';
        $headers[] = 'Content-Transfer-Encoding: base64';
    } else {
        $headers[] = 'Content-type: text/plain; charset=UTF-8';
        $headers[] = 'Content-Transfer-Encoding: base64';
    }
    
    $headersString = implode("\r\n", $headers);
    
    // Encoder le message en base64 pour éviter les problèmes d'encodage
    $encodedMessage = base64_encode($message);
    
    if (mail($to, $subject, $encodedMessage, $headersString)) {
        return ['success' => true, 'message' => 'Email envoyé avec succès'];
    } else {
        return ['success' => false, 'error' => 'Erreur lors de l\'envoi de l\'email'];
    }
}
?>
