<?php
// Inclure le système de langue en premier
require_once 'includes/language.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

require_once 'includes/db.php';
include 'templates/header.php';
$user_id = $_SESSION['user_id'] ?? 0;
$pseudo = '';
if ($user_id) {
    $stmt = $mysqli->prepare('SELECT username FROM Users WHERE id = ?');
    $stmt->bind_param('i', $user_id);
    $stmt->execute();
    $stmt->bind_result($pseudo);
    $stmt->fetch();
    $stmt->close();
}
?>
<style>
body {
  /* background: linear-gradient(135deg, #23232b 80%, #ffb30022 100%); */
  min-height: 100vh;
}
.mur-container {
  max-width: 900px;
  margin: 40px auto 30px auto;
  background: #23232b;
  border-radius: 18px;
  box-shadow: 0 4px 24px #0005;
  padding: 32px 24px 24px 24px;
}
.mur-title {
  color: #ffb300;
  font-size: 2rem;
  font-weight: 800;
  text-align: center;
  margin-bottom: 18px;
  letter-spacing: 1px;
}
#mur-form {
  display: flex;
  flex-direction: column;
  gap: 10px;
  margin-bottom: 18px;
}
#mur-form textarea {
  border-radius: 8px;
  border: 1px solid #ffb300;
  padding: 12px;
  font-size: 1.1rem;
  resize: vertical;
  min-height: 150px;
}
#mur-form input[type=file] {
  background: #fffbe6;
  border-radius: 8px;
  padding: 6px;
}
#mur-form button {
  background: linear-gradient(90deg, #ffb300 60%, #fffbe6 100%);
  color: #23232b;
  border: none;
  border-radius: 10px;
  font-weight: 800;
  font-size: 1.13rem;
  padding: 10px 28px;
  margin-top: 6px;
  cursor: pointer;
}
.mur-message-card {
  background: #29293a;
  border-radius: 14px;
  padding: 14px 12px;
  box-shadow: 0 2px 8px #0002;
  border: 2px solid #ffb30044;
  display: flex;
  flex-direction: column;
  gap: 8px;
  position: relative;
  color: white;
}

.messages-grid {
  display: grid;
  grid-template-columns: repeat(auto-fill, minmax(300px, 1fr));
  gap: 20px;
  margin-top: 20px;
}

@media (max-width: 768px) {
  .messages-grid {
    grid-template-columns: 1fr;
  }
  
  .mur-message-img {
    max-height: 350px;
  }
}
.mur-message-img {
  max-width: 100%;
  max-height: 500px;
  width: auto;
  height: auto;
  object-fit: contain;
  border-radius: 8px;
  margin-top: 6px;
}
.mur-message-footer {
  display: flex;
  align-items: center;
  gap: 12px;
  font-size: 0.98rem;
}
.mur-like-btn {
  background: none;
  border: none;
  color: #ffb300;
  font-size: 1.3rem;
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 4px;
}
.mur-like-btn.liked {
  color: #e53935;
}
.mur-message-pseudo {
  color: #ffb300;
  font-weight: 700;
  font-size: 1.08rem;
  margin-bottom: 2px;
}
.mur-fab {
  position: fixed;
  right: 32px;
  bottom: 32px;
  width: 56px;
  height: 56px;
  border-radius: 50%;
  background: linear-gradient(90deg, #ffffff 60%, #fffbe6 100%);
  color: #23232b;
  font-size: 2.2rem;
  font-weight: 900;
  border: none;
  box-shadow: 0 4px 24px #0005;
  cursor: pointer;
  z-index: 1001;
  transition: transform 0.12s;
  display: flex;
  align-items: center;
  justify-content: center;
  overflow: hidden;
}
.mur-fab:hover {
  transform: scale(1.08);
}
.mur-modal-bg {
  position: fixed;
  top: 0; left: 0; right: 0; bottom: 0;
  background: rgba(30,30,40,0.85);
  z-index: 1000;
  display: flex;
  align-items: center;
  justify-content: center;
}
.mur-modal {
  background: #23232b;
  border-radius: 18px;
  box-shadow: 0 4px 24px #000a;
  padding: 32px 28px 28px 28px;
  min-width: 600px;
  max-width: 750px;
  position: relative;
}
.mur-modal-close {
  position: absolute;
  top: 12px; right: 16px;
  background: none;
  border: none;
  color: #ffb300;
  font-size: 2rem;
  font-weight: 900;
  cursor: pointer;
}

/* Styles RTL pour l'arabe */
.lang-ar .mur-fab {
  right: auto;
  left: 32px;
}

.lang-ar .mur-modal-close {
  right: auto;
  left: 16px;
}

.lang-ar .mur-message-footer {
  flex-direction: row-reverse;
}

.lang-ar .mur-like-btn {
  flex-direction: row-reverse;
}

@media (min-width: 768px) and (max-width: 1023.98px) {
  .mur-container {
    max-width: 700px;
  }
}

@media (max-width: 600px) {
  .mur-container { padding: 8px 2vw; }
  .mur-title { font-size: 1.3rem; }
  #mur-form textarea { font-size: 1rem; min-height: 120px; }
  .mur-modal { min-width: 0; max-width: 95vw; padding: 24px 16px 20px 16px; }
}
</style>

<!-- Script LottieFiles -->
<script src="https://unpkg.com/@lottiefiles/dotlottie-wc@0.6.2/dist/dotlottie-wc.js" type="module"></script>

<div class="mur-container">
  <div class="mur-title"><?= __('message_wall') ?></div>
  <div id="mur-messages" class="messages-grid"></div>
</div>

<!-- Bouton flottant avec animation Lottie -->
<dotlottie-wc
  id="openMurPopup"
  class="mur-fab"
  src="https://lottie.host/75265b49-3815-4282-a3d1-9f635943bc56/qPOOBhabqB.lottie"
  style="width: 56px; height: 56px; cursor: pointer;"
  speed="1"
  autoplay
  loop
  title="<?= __('add_message') ?>"
  onerror="this.style.display='none'; document.getElementById('openMurPopupFallback').style.display='flex';"
></dotlottie-wc>

<!-- Bouton fallback si l'animation ne charge pas -->
<button
  id="openMurPopupFallback"
  class="mur-fab"
  style="display: none;"
  title="<?= __('add_message') ?>"
>
  +
</button>
<!-- Popup modal -->
<div id="murModal" class="mur-modal-bg" style="display:none;">
  <div class="mur-modal">
    <button class="mur-modal-close" id="closeMurPopup">&times;</button>
    <form id="mur-form" enctype="multipart/form-data">
      <textarea name="message" placeholder="<?= __('write_message') ?>" required></textarea>
      <input type="file" id="imageInput" name="imageInput" accept="image/*">
      <button type="submit"><?= __('publish') ?></button>
    </form>
  </div>
</div>
<script>
function escapeHTML(str) {
  return str.replace(/[&<>'\"]/g, function(c) {
    return ({
      '&': '&amp;',
      '<': '&lt;',
      '>': '&gt;',
      "'": '&#39;',
      '"': '&quot;'
    })[c];
  });
}
const imageInput = document.getElementById('imageInput');
imageInput.addEventListener('change', function(e) {
  const file = e.target.files[0];
  if (!file) return;
  const reader = new FileReader();
  reader.onload = function(event) {
    const img = new Image();
    img.onload = function() {
      const canvas = document.createElement('canvas');
      const maxDim = 800;
      let w = img.width, h = img.height;
      if (w > h && w > maxDim) { h *= maxDim / w; w = maxDim; }
      else if (h > maxDim) { w *= maxDim / h; h = maxDim; }
      canvas.width = w; canvas.height = h;
      canvas.getContext('2d').drawImage(img, 0, 0, w, h);
      canvas.toBlob(function(blob) {
        const newFile = new File([blob], file.name, {type: 'image/jpeg'});
        const dt = new DataTransfer();
        dt.items.add(newFile);
        e.target.files = dt.files;
      }, 'image/jpeg', 0.7);
    };
    img.src = event.target.result;
  };
  reader.readAsDataURL(file);
});
// Popup ouverture/fermeture
const openBtn = document.getElementById('openMurPopup');
const openBtnFallback = document.getElementById('openMurPopupFallback');

if (openBtn) {
  openBtn.addEventListener('click', function() { murModal.style.display = 'flex'; });
}

if (openBtnFallback) {
  openBtnFallback.addEventListener('click', function() { murModal.style.display = 'flex'; });
}
const closeBtn = document.getElementById('closeMurPopup');
const murModal = document.getElementById('murModal');
closeBtn.onclick = function() { murModal.style.display = 'none'; };
murModal.onclick = function(e) { if (e.target === this) this.style.display = 'none'; };
document.getElementById('mur-form').onsubmit = async function(e) {
  e.preventDefault();
  const formData = new FormData(this);
  const res = await fetch('ajax/mur_message_post.php', { method: 'POST', body: formData });
  if (res.ok) {
    this.reset();
    murModal.style.display = 'none';
    alert('Votre message a été envoyé et est en attente de validation par un administrateur.');
    loadMessages();
  } else {
    alert('<?= __('publish_error') ?>');
  }
};
async function loadMessages() {
  const res = await fetch('ajax/mur_message_list.php');
  const messages = await res.json();
  let html = '';
  if (messages.length === 0) {
    html = '<div style="color:#ffb300; text-align:center; font-weight:700; margin:32px 0; font-size:1.2rem;"><?= __('no_messages') ?><br><?= __('be_first_to_post') ?></div>';
  } else {
    messages.forEach(msg => {
      html += `<div class=\"mur-message-card\">
      <div class=\"mur-message-pseudo\">${escapeHTML(msg.username || '<?= __('user') ?>')}</div>
      <div>${escapeHTML(msg.message)}</div>
      ${msg.image_path ? `<img src=\"${msg.image_path}\" class=\"mur-message-img\" onerror=\"this.style.display='none'\">` : ''}
      <div class=\"mur-message-footer\">
        <button class=\"mur-like-btn${msg.liked ? ' liked' : ''}\" data-id=\"${msg.id}\">
          <span>${msg.liked ? '❤️' : '🤍'}</span> <span>${msg.likes}</span>
        </button>
        <span style=\"color:#ffb300;\"><?= __('posted_on') ?> ${msg.created_at}</span>
      </div>
    </div>`;
    });
  }
  document.getElementById('mur-messages').innerHTML = html;
  document.querySelectorAll('.mur-like-btn').forEach(btn => {
    btn.onclick = async function(e) {
      e.preventDefault();
      const id = this.getAttribute('data-id');
      await fetch('ajax/mur_message_like.php', { method: 'POST', headers: {'Content-Type':'application/x-www-form-urlencoded'}, body: 'id='+id });
      loadMessages();
    }
  });
}
loadMessages();
</script>
<?php include 'templates/footer.php'; ?> 